/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.expression.ExpressionScriptExecutionException;
import org.elasticsearch.script.expression.ReplaceableConstValueSource;

class ExpressionSearchScript
implements SearchScript {
    final CompiledScript compiledScript;
    final SimpleBindings bindings;
    final ValueSource source;
    final ReplaceableConstValueSource specialValue;
    final boolean needsScores;
    Scorer scorer;
    int docid;

    ExpressionSearchScript(CompiledScript c, SimpleBindings b, ReplaceableConstValueSource v, boolean needsScores) {
        this.compiledScript = c;
        this.bindings = b;
        this.source = ((Expression)this.compiledScript.compiled()).getValueSource((Bindings)this.bindings);
        this.specialValue = v;
        this.needsScores = needsScores;
    }

    @Override
    public boolean needsScores() {
        return this.needsScores;
    }

    @Override
    public LeafSearchScript getLeafSearchScript(final LeafReaderContext leaf) throws IOException {
        return new LeafSearchScript(){
            FunctionValues values;
            {
                this.values = ExpressionSearchScript.this.source.getValues(Collections.singletonMap("scorer", Lucene.illegalScorer("Scores are not available in the current context")), leaf);
            }

            double evaluate() {
                try {
                    return this.values.doubleVal(ExpressionSearchScript.this.docid);
                }
                catch (Exception exception) {
                    throw new ScriptException("Error evaluating " + ExpressionSearchScript.this.compiledScript, exception);
                }
            }

            @Override
            public Object run() {
                return new Double(this.evaluate());
            }

            @Override
            public float runAsFloat() {
                return (float)this.evaluate();
            }

            @Override
            public long runAsLong() {
                return (long)this.evaluate();
            }

            @Override
            public double runAsDouble() {
                return this.evaluate();
            }

            @Override
            public Object unwrap(Object value) {
                return value;
            }

            @Override
            public void setDocument(int d) {
                ExpressionSearchScript.this.docid = d;
            }

            @Override
            public void setScorer(Scorer s) {
                ExpressionSearchScript.this.scorer = s;
                try {
                    this.values = ExpressionSearchScript.this.source.getValues(Collections.singletonMap("scorer", ExpressionSearchScript.this.scorer), leaf);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't get values using " + ExpressionSearchScript.this.compiledScript, e);
                }
            }

            @Override
            public void setSource(Map<String, Object> source) {
            }

            @Override
            public void setNextVar(String name, Object value) {
                assert (ExpressionSearchScript.this.specialValue != null);
                assert (name.equals("_value"));
                if (!(value instanceof Number)) {
                    throw new ExpressionScriptExecutionException("Cannot use expression with text variable using " + ExpressionSearchScript.this.compiledScript);
                }
                ExpressionSearchScript.this.specialValue.setValue(((Number)value).doubleValue());
            }
        };
    }
}

