/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<MultiMatchQueryBuilder> {
    private final Object text;
    private final List<String> fields = new ArrayList<String>();
    private ObjectFloatHashMap<String> fieldsBoosts;
    private Type type;
    private MatchQueryBuilder.Operator operator;
    private String analyzer;
    private Float boost;
    private Integer slop;
    private Fuzziness fuzziness;
    private Integer prefixLength;
    private Integer maxExpansions;
    private String minimumShouldMatch;
    private String fuzzyRewrite = null;
    private Boolean useDisMax;
    private Float tieBreaker;
    private Boolean lenient;
    private Float cutoffFrequency = null;
    private MatchQueryBuilder.ZeroTermsQuery zeroTermsQuery = null;
    private String queryName;

    public MultiMatchQueryBuilder(Object text, String ... fields) {
        this.fields.addAll(Arrays.asList(fields));
        this.text = text;
    }

    public MultiMatchQueryBuilder field(String field) {
        this.fields.add(field);
        return this;
    }

    public MultiMatchQueryBuilder field(String field, float boost) {
        this.fields.add(field);
        if (this.fieldsBoosts == null) {
            this.fieldsBoosts = new ObjectFloatHashMap();
        }
        this.fieldsBoosts.put((Object)field, boost);
        return this;
    }

    public MultiMatchQueryBuilder type(Type type) {
        this.type = type;
        return this;
    }

    public MultiMatchQueryBuilder type(Object type) {
        this.type = type == null ? null : Type.parse(type.toString().toLowerCase(Locale.ROOT), ParseFieldMatcher.EMPTY);
        return this;
    }

    public MultiMatchQueryBuilder operator(MatchQueryBuilder.Operator operator) {
        this.operator = operator;
        return this;
    }

    public MultiMatchQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public MultiMatchQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public MultiMatchQueryBuilder slop(int slop) {
        this.slop = slop;
        return this;
    }

    public MultiMatchQueryBuilder fuzziness(Object fuzziness) {
        this.fuzziness = Fuzziness.build(fuzziness);
        return this;
    }

    public MultiMatchQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public MultiMatchQueryBuilder maxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    public MultiMatchQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public MultiMatchQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    @Deprecated
    public MultiMatchQueryBuilder useDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
        return this;
    }

    public MultiMatchQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = Float.valueOf(tieBreaker);
        return this;
    }

    public MultiMatchQueryBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public MultiMatchQueryBuilder cutoffFrequency(float cutoff) {
        this.cutoffFrequency = Float.valueOf(cutoff);
        return this;
    }

    public MultiMatchQueryBuilder zeroTermsQuery(MatchQueryBuilder.ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
        return this;
    }

    public MultiMatchQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("multi_match");
        builder.field("query", this.text);
        builder.startArray("fields");
        for (String field : this.fields) {
            int keySlot;
            if (this.fieldsBoosts != null && (keySlot = this.fieldsBoosts.indexOf((Object)field)) >= 0) {
                field = field + "^" + this.fieldsBoosts.indexGet(keySlot);
            }
            builder.value(field);
        }
        builder.endArray();
        if (this.type != null) {
            builder.field("type", this.type.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.operator != null) {
            builder.field("operator", this.operator.toString());
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.slop != null) {
            builder.field("slop", this.slop);
        }
        if (this.fuzziness != null) {
            this.fuzziness.toXContent(builder, params);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_length", this.prefixLength);
        }
        if (this.maxExpansions != null) {
            builder.field("max_expansions", this.maxExpansions);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.fuzzyRewrite != null) {
            builder.field("fuzzy_rewrite", this.fuzzyRewrite);
        }
        if (this.useDisMax != null) {
            builder.field("use_dis_max", (Object)this.useDisMax);
        }
        if (this.tieBreaker != null) {
            builder.field("tie_breaker", this.tieBreaker);
        }
        if (this.lenient != null) {
            builder.field("lenient", (Object)this.lenient);
        }
        if (this.cutoffFrequency != null) {
            builder.field("cutoff_frequency", this.cutoffFrequency);
        }
        if (this.zeroTermsQuery != null) {
            builder.field("zero_terms_query", this.zeroTermsQuery.toString());
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }

    public static enum Type {
        BEST_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, new ParseField("best_fields", "boolean")),
        MOST_FIELDS(MatchQuery.Type.BOOLEAN, 1.0f, new ParseField("most_fields", new String[0])),
        CROSS_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, new ParseField("cross_fields", new String[0])),
        PHRASE(MatchQuery.Type.PHRASE, 0.0f, new ParseField("phrase", new String[0])),
        PHRASE_PREFIX(MatchQuery.Type.PHRASE_PREFIX, 0.0f, new ParseField("phrase_prefix", new String[0]));

        private MatchQuery.Type matchQueryType;
        private final float tieBreaker;
        private final ParseField parseField;

        private Type(MatchQuery.Type matchQueryType, float tieBreaker, ParseField parseField) {
            this.matchQueryType = matchQueryType;
            this.tieBreaker = tieBreaker;
            this.parseField = parseField;
        }

        public float tieBreaker() {
            return this.tieBreaker;
        }

        public MatchQuery.Type matchQueryType() {
            return this.matchQueryType;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static Type parse(String value, ParseFieldMatcher parseFieldMatcher) {
            Type[] values = Type.values();
            Type type = null;
            for (Type t : values) {
                if (!parseFieldMatcher.match(value, t.parseField())) continue;
                type = t;
                break;
            }
            if (type == null) {
                throw new ElasticsearchParseException("failed to parse [{}] query type [{}]. unknown type.", "multi_match", value);
            }
            return type;
        }
    }
}

