/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;

public final class DocumentFieldMappers
implements Iterable<FieldMapper> {
    private final CopyOnWriteHashMap<String, FieldMapper> fieldMappers;
    private final FieldNameAnalyzer indexAnalyzer;
    private final FieldNameAnalyzer searchAnalyzer;
    private final FieldNameAnalyzer searchQuoteAnalyzer;

    public DocumentFieldMappers(AnalysisService analysisService) {
        this(new CopyOnWriteHashMap<String, FieldMapper>(), new FieldNameAnalyzer((Analyzer)analysisService.defaultIndexAnalyzer()), new FieldNameAnalyzer((Analyzer)analysisService.defaultSearchAnalyzer()), new FieldNameAnalyzer((Analyzer)analysisService.defaultSearchQuoteAnalyzer()));
    }

    private DocumentFieldMappers(CopyOnWriteHashMap<String, FieldMapper> fieldMappers, FieldNameAnalyzer indexAnalyzer, FieldNameAnalyzer searchAnalyzer, FieldNameAnalyzer searchQuoteAnalyzer) {
        this.fieldMappers = fieldMappers;
        this.indexAnalyzer = indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer;
        this.searchQuoteAnalyzer = searchQuoteAnalyzer;
    }

    public DocumentFieldMappers copyAndAllAll(Collection<FieldMapper> newMappers) {
        CopyOnWriteHashMap<String, FieldMapper> map = this.fieldMappers;
        for (FieldMapper fieldMapper : newMappers) {
            map = map.copyAndPut(fieldMapper.fieldType().names().fullName(), fieldMapper);
        }
        FieldNameAnalyzer indexAnalyzer = this.indexAnalyzer.copyAndAddAll(Collections2.transform(newMappers, (Function)new Function<FieldMapper, Map.Entry<String, Analyzer>>(){

            public Map.Entry<String, Analyzer> apply(FieldMapper input) {
                return Maps.immutableEntry((Object)input.fieldType().names().indexName(), (Object)((Object)input.fieldType().indexAnalyzer()));
            }
        }));
        FieldNameAnalyzer searchAnalyzer = this.searchAnalyzer.copyAndAddAll(Collections2.transform(newMappers, (Function)new Function<FieldMapper, Map.Entry<String, Analyzer>>(){

            public Map.Entry<String, Analyzer> apply(FieldMapper input) {
                return Maps.immutableEntry((Object)input.fieldType().names().indexName(), (Object)((Object)input.fieldType().searchAnalyzer()));
            }
        }));
        FieldNameAnalyzer searchQuoteAnalyzer = this.searchQuoteAnalyzer.copyAndAddAll(Collections2.transform(newMappers, (Function)new Function<FieldMapper, Map.Entry<String, Analyzer>>(){

            public Map.Entry<String, Analyzer> apply(FieldMapper input) {
                return Maps.immutableEntry((Object)input.fieldType().names().indexName(), (Object)((Object)input.fieldType().searchQuoteAnalyzer()));
            }
        }));
        return new DocumentFieldMappers(map, indexAnalyzer, searchAnalyzer, searchQuoteAnalyzer);
    }

    public FieldMapper getMapper(String field) {
        return this.fieldMappers.get(field);
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        HashSet fields = Sets.newHashSet();
        for (FieldMapper fieldMapper : this) {
            if (Regex.simpleMatch(pattern, fieldMapper.fieldType().names().fullName())) {
                fields.add(fieldMapper.fieldType().names().fullName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.fieldType().names().indexName())) continue;
            fields.add(fieldMapper.fieldType().names().fullName());
        }
        return fields;
    }

    public FieldMapper smartNameFieldMapper(String name) {
        FieldMapper fieldMapper = this.getMapper(name);
        if (fieldMapper != null) {
            return fieldMapper;
        }
        for (FieldMapper otherFieldMapper : this) {
            if (!otherFieldMapper.fieldType().names().indexName().equals(name)) continue;
            return otherFieldMapper;
        }
        return null;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer indexAnalyzer(Analyzer defaultAnalyzer) {
        return new FieldNameAnalyzer(this.indexAnalyzer.analyzers(), defaultAnalyzer);
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    @Override
    public Iterator<FieldMapper> iterator() {
        return this.fieldMappers.values().iterator();
    }
}

