/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.index.fielddata.AbstractRandomAccessOrds;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public class MultiOrdinals
extends Ordinals {
    private static final int OFFSETS_PAGE_SIZE = 1024;
    private static final int OFFSET_INIT_PAGE_COUNT = 16;
    private final boolean multiValued;
    private final long valueCount;
    private final PackedLongValues endOffsets;
    private final PackedLongValues ords;

    public static boolean significantlySmallerThanSinglePackedOrdinals(int maxDoc, int numDocsWithValue, long numOrds, float acceptableOverheadRatio) {
        int bitsPerOrd = PackedInts.bitsRequired((long)numOrds);
        bitsPerOrd = PackedInts.fastestFormatAndBits((int)numDocsWithValue, (int)bitsPerOrd, (float)acceptableOverheadRatio).bitsPerValue;
        float avgValuesPerDoc = (float)numDocsWithValue / (float)maxDoc;
        int maxDelta = (int)Math.ceil(1024.0f * (1.0f - avgValuesPerDoc) * avgValuesPerDoc);
        int bitsPerOffset = PackedInts.bitsRequired((long)maxDelta) + 1;
        bitsPerOffset = PackedInts.fastestFormatAndBits((int)maxDoc, (int)bitsPerOffset, (float)acceptableOverheadRatio).bitsPerValue;
        long expectedMultiSizeInBytes = (long)numDocsWithValue * (long)bitsPerOrd + (long)maxDoc * (long)bitsPerOffset;
        long expectedSingleSizeInBytes = (long)maxDoc * (long)bitsPerOrd;
        return (float)expectedMultiSizeInBytes < 0.8f * (float)expectedSingleSizeInBytes;
    }

    public MultiOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        this.multiValued = builder.getNumMultiValuesDocs() > 0;
        this.valueCount = builder.getValueCount();
        PackedLongValues.Builder endOffsetsBuilder = PackedLongValues.monotonicBuilder((int)1024, (float)acceptableOverheadRatio);
        PackedLongValues.Builder ordsBuilder = PackedLongValues.packedBuilder((int)1024, (float)acceptableOverheadRatio);
        long lastEndOffset = 0L;
        for (int i = 0; i < builder.maxDoc(); ++i) {
            LongsRef docOrds = builder.docOrds(i);
            long endOffset = lastEndOffset + (long)docOrds.length;
            endOffsetsBuilder.add(endOffset);
            for (int j = 0; j < docOrds.length; ++j) {
                ordsBuilder.add(docOrds.longs[docOrds.offset + j]);
            }
            lastEndOffset = endOffset;
        }
        this.endOffsets = endOffsetsBuilder.build();
        this.ords = ordsBuilder.build();
        assert (this.endOffsets.size() == (long)builder.maxDoc());
        assert (this.ords.size() == (long)builder.getTotalNumOrds()) : this.ords.size() + " != " + builder.getTotalNumOrds();
    }

    @Override
    public long ramBytesUsed() {
        return this.endOffsets.ramBytesUsed() + this.ords.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.add(Accountables.namedAccountable((String)"offsets", (Accountable)this.endOffsets));
        resources.add(Accountables.namedAccountable((String)"ordinals", (Accountable)this.ords));
        return Collections.unmodifiableCollection(resources);
    }

    @Override
    public RandomAccessOrds ordinals(Ordinals.ValuesHolder values) {
        if (this.multiValued) {
            return new MultiDocs(this, values);
        }
        return DocValues.singleton((SortedDocValues)new SingleDocs(this, values));
    }

    private static class MultiDocs
    extends AbstractRandomAccessOrds {
        private final long valueCount;
        private final PackedLongValues endOffsets;
        private final PackedLongValues ords;
        private long offset;
        private int cardinality;
        private final Ordinals.ValuesHolder values;

        MultiDocs(MultiOrdinals ordinals, Ordinals.ValuesHolder values) {
            this.valueCount = ordinals.valueCount;
            this.endOffsets = ordinals.endOffsets;
            this.ords = ordinals.ords;
            this.values = values;
        }

        public long getValueCount() {
            return this.valueCount;
        }

        @Override
        public void doSetDocument(int docId) {
            long startOffset = docId != 0 ? this.endOffsets.get(docId - 1) : 0L;
            long endOffset = this.endOffsets.get(docId);
            this.offset = startOffset;
            this.cardinality = (int)(endOffset - startOffset);
        }

        public int cardinality() {
            return this.cardinality;
        }

        public long ordAt(int index) {
            return this.ords.get(this.offset + (long)index);
        }

        public BytesRef lookupOrd(long ord) {
            return this.values.lookupOrd(ord);
        }
    }

    private static class SingleDocs
    extends SortedDocValues {
        private final int valueCount;
        private final PackedLongValues endOffsets;
        private final PackedLongValues ords;
        private final Ordinals.ValuesHolder values;

        SingleDocs(MultiOrdinals ordinals, Ordinals.ValuesHolder values) {
            this.valueCount = (int)ordinals.valueCount;
            this.endOffsets = ordinals.endOffsets;
            this.ords = ordinals.ords;
            this.values = values;
        }

        public int getOrd(int docId) {
            long startOffset = docId != 0 ? this.endOffsets.get(docId - 1) : 0L;
            long endOffset = this.endOffsets.get(docId);
            return startOffset == endOffset ? -1 : (int)this.ords.get(startOffset);
        }

        public BytesRef lookupOrd(int ord) {
            return this.values.lookupOrd(ord);
        }

        public int getValueCount() {
            return this.valueCount;
        }
    }
}

