/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.yaml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.BaseJsonGenerator;
import org.elasticsearch.common.xcontent.support.filtering.FilteringJsonGenerator;
import org.elasticsearch.common.xcontent.yaml.YamlXContentGenerator;
import org.elasticsearch.common.xcontent.yaml.YamlXContentParser;

public class YamlXContent
implements XContent {
    static final YAMLFactory yamlFactory = new YAMLFactory();
    public static final YamlXContent yamlXContent = new YamlXContent();

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(yamlXContent);
    }

    private YamlXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.YAML;
    }

    @Override
    public byte streamSeparator() {
        throw new ElasticsearchParseException("yaml does not support stream parsing...", new Object[0]);
    }

    private XContentGenerator newXContentGenerator(JsonGenerator jsonGenerator) {
        return new YamlXContentGenerator(new BaseJsonGenerator(jsonGenerator));
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os) throws IOException {
        return this.newXContentGenerator((JsonGenerator)yamlFactory.createGenerator(os, JsonEncoding.UTF8));
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, String[] filters) throws IOException {
        if (CollectionUtils.isEmpty(filters)) {
            return this.createGenerator(os);
        }
        FilteringJsonGenerator yamlGenerator = new FilteringJsonGenerator((JsonGenerator)yamlFactory.createGenerator(os, JsonEncoding.UTF8), filters);
        return new YamlXContentGenerator(yamlGenerator);
    }

    @Override
    public XContentGenerator createGenerator(Writer writer) throws IOException {
        return this.newXContentGenerator((JsonGenerator)yamlFactory.createGenerator(writer));
    }

    @Override
    public XContentParser createParser(String content) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser((Reader)new FastStringReader(content)));
    }

    @Override
    public XContentParser createParser(InputStream is) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(is));
    }

    @Override
    public XContentParser createParser(byte[] data) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(data));
    }

    @Override
    public XContentParser createParser(byte[] data, int offset, int length) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(data, offset, length));
    }

    @Override
    public XContentParser createParser(BytesReference bytes) throws IOException {
        if (bytes.hasArray()) {
            return this.createParser(bytes.array(), bytes.arrayOffset(), bytes.length());
        }
        return this.createParser(bytes.streamInput());
    }

    @Override
    public XContentParser createParser(Reader reader) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(reader));
    }
}

