/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionWriteResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportReplicationAction<Request extends ReplicationRequest, ReplicaRequest extends ReplicationRequest, Response extends ActionWriteResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndicesService indicesService;
    protected final ShardStateAction shardStateAction;
    protected final WriteConsistencyLevel defaultWriteConsistencyLevel;
    protected final TransportRequestOptions transportOptions;
    protected final MappingUpdatedAction mappingUpdatedAction;
    final String transportReplicaAction;
    final String executor;
    final boolean checkWriteConsistency;

    protected TransportReplicationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Class<Request> request, Class<ReplicaRequest> replicaRequest, String executor) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.transportReplicaAction = actionName + "[r]";
        this.executor = executor;
        this.checkWriteConsistency = this.checkWriteConsistency();
        transportService.registerRequestHandler(actionName, request, "same", new OperationTransportHandler());
        transportService.registerRequestHandler(this.transportReplicaAction, replicaRequest, executor, true, new ReplicaOperationTransportHandler());
        this.transportOptions = this.transportOptions();
        this.defaultWriteConsistencyLevel = WriteConsistencyLevel.fromString(settings.get("action.write_consistency", "quorum"));
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new PrimaryPhase(this, request, listener).run();
    }

    protected abstract Response newResponseInstance();

    protected abstract Tuple<Response, ReplicaRequest> shardOperationOnPrimary(ClusterState var1, PrimaryOperationRequest var2) throws Throwable;

    protected abstract void shardOperationOnReplica(ShardId var1, ReplicaRequest var2);

    protected abstract ShardIterator shards(ClusterState var1, InternalRequest var2);

    protected abstract boolean checkWriteConsistency();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.concreteIndex());
    }

    protected boolean resolveIndex() {
        return true;
    }

    protected void resolveRequest(ClusterState state, InternalRequest request, ActionListener<Response> listener) {
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected boolean retryPrimaryException(Throwable e) {
        return e.getClass() == RetryOnPrimaryException.class || TransportActions.isShardNotAvailableException(e);
    }

    protected boolean ignoreReplicaException(Throwable e) {
        if (TransportActions.isShardNotAvailableException(e)) {
            return true;
        }
        return this.isConflictException(e);
    }

    protected boolean isConflictException(Throwable e) {
        Throwable cause = ExceptionsHelper.unwrapCause(e);
        if (cause instanceof VersionConflictEngineException) {
            return true;
        }
        return cause instanceof DocumentAlreadyExistsException;
    }

    protected Releasable getIndexShardOperationsCounter(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.index().getName());
        IndexShard indexShard = indexService.shardSafe(shardId.id());
        return new IndexShardReference(indexShard);
    }

    private void failReplicaIfNeeded(String index, int shardId, Throwable t) {
        this.logger.trace("failure on replica [{}][{}]", t, index, shardId);
        if (!this.ignoreReplicaException(t)) {
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            IndexShard indexShard = indexService.shard(shardId);
            if (indexShard == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            indexShard.failShard(this.actionName + " failed on replica", t);
        }
    }

    protected boolean shouldExecuteReplication(Settings settings) {
        return !IndexMetaData.isIndexUsingShadowReplicas(settings);
    }

    private final Engine.IndexingOperation prepareIndexOperationOnPrimary(BulkShardRequest shardRequest, IndexRequest request, IndexShard indexShard) {
        SourceToParse sourceToParse = SourceToParse.source(SourceToParse.Origin.PRIMARY, request.source()).index(request.index()).type(request.type()).id(request.id()).routing(request.routing()).parent(request.parent()).timestamp(request.timestamp()).ttl(request.ttl());
        boolean canHaveDuplicates = request.canHaveDuplicates();
        if (shardRequest != null) {
            canHaveDuplicates |= shardRequest.canHaveDuplicates();
        }
        if (request.opType() == IndexRequest.OpType.INDEX) {
            return indexShard.prepareIndex(sourceToParse, request.version(), request.versionType(), Engine.Operation.Origin.PRIMARY, canHaveDuplicates);
        }
        assert (request.opType() == IndexRequest.OpType.CREATE) : request.opType();
        return indexShard.prepareCreate(sourceToParse, request.version(), request.versionType(), Engine.Operation.Origin.PRIMARY, canHaveDuplicates, canHaveDuplicates);
    }

    protected final WriteResult<IndexResponse> executeIndexRequestOnPrimary(BulkShardRequest shardRequest, IndexRequest request, IndexShard indexShard) throws Throwable {
        Engine.IndexingOperation operation = this.prepareIndexOperationOnPrimary(shardRequest, request, indexShard);
        Mapping update = operation.parsedDoc().dynamicMappingsUpdate();
        ShardId shardId = indexShard.shardId();
        if (update != null) {
            String indexName = shardId.getIndex();
            this.mappingUpdatedAction.updateMappingOnMasterSynchronously(indexName, request.type(), update);
            operation = this.prepareIndexOperationOnPrimary(shardRequest, request, indexShard);
            update = operation.parsedDoc().dynamicMappingsUpdate();
            if (update != null) {
                throw new RetryOnPrimaryException(shardId, "Dynamics mappings are not available on the node that holds the primary yet");
            }
        }
        boolean created = operation.execute(indexShard);
        long version = operation.version();
        request.version(version);
        request.versionType(request.versionType().versionTypeForReplicationAndRecovery());
        assert (request.versionType().validateVersionForWrites(request.version()));
        return new WriteResult<IndexResponse>(new IndexResponse(shardId.getIndex(), request.type(), request.id(), request.version(), created), operation.getTranslogLocation());
    }

    static class IndexShardReference
    implements Releasable {
        private final IndexShard counter;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        IndexShardReference(IndexShard counter) {
            counter.incrementOperationCounter();
            this.counter = counter;
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.counter.decrementOperationCounter();
            }
        }
    }

    protected static class InternalRequest {
        final Request request;
        String concreteIndex;
        final /* synthetic */ TransportReplicationAction this$0;

        InternalRequest(Request request) {
            this.this$0 = var1_1;
            this.request = request;
        }

        public Request request() {
            return this.request;
        }

        void concreteIndex(String concreteIndex) {
            this.concreteIndex = concreteIndex;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    static final class ReplicationPhase
    extends AbstractRunnable {
        private final ReplicaRequest replicaRequest;
        private final Response finalResponse;
        private final ShardIterator shardIt;
        private final ActionListener<Response> listener;
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final AtomicInteger success = new AtomicInteger(1);
        private final ConcurrentMap<String, Throwable> shardReplicaFailures = ConcurrentCollections.newConcurrentMap();
        private final IndexMetaData indexMetaData;
        private final ShardRouting originalPrimaryShard;
        private final AtomicInteger pending;
        private final int totalShards;
        private final ClusterStateObserver observer;
        private final Releasable indexShardReference;
        final /* synthetic */ TransportReplicationAction this$0;

        public ReplicationPhase(ShardIterator originalShardIt, ReplicaRequest replicaRequest, Response finalResponse, ClusterStateObserver observer, ShardRouting originalPrimaryShard, InternalRequest internalRequest, ActionListener<Response> listener, Releasable indexShardReference) {
            this.this$0 = var1_1;
            this.replicaRequest = replicaRequest;
            this.listener = listener;
            this.finalResponse = finalResponse;
            this.originalPrimaryShard = originalPrimaryShard;
            this.observer = observer;
            this.indexMetaData = observer.observedState().metaData().index(internalRequest.concreteIndex());
            this.indexShardReference = indexShardReference;
            ClusterState newState = var1_1.clusterService.state();
            int numberOfUnassignedOrIgnoredReplicas = 0;
            int numberOfPendingShardInstances = 0;
            if (observer.observedState() != newState) {
                ShardRouting shard;
                observer.reset(newState);
                this.shardIt = var1_1.shards(newState, internalRequest);
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (shard.primary()) {
                        if (!originalPrimaryShard.currentNodeId().equals(shard.currentNodeId())) {
                            ++numberOfPendingShardInstances;
                        }
                        if (!shard.relocating()) continue;
                        ++numberOfPendingShardInstances;
                        continue;
                    }
                    if (!var1_1.shouldExecuteReplication(this.indexMetaData.getSettings())) {
                        ++numberOfUnassignedOrIgnoredReplicas;
                        continue;
                    }
                    if (shard.unassigned()) {
                        ++numberOfUnassignedOrIgnoredReplicas;
                        continue;
                    }
                    if (shard.relocating()) {
                        numberOfPendingShardInstances += 2;
                        continue;
                    }
                    ++numberOfPendingShardInstances;
                }
                ((ReplicationRequest)internalRequest.request()).setCanHaveDuplicates();
            } else {
                ShardRouting shard;
                this.shardIt = originalShardIt;
                this.shardIt.reset();
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (shard.state() != ShardRoutingState.STARTED) {
                        ((ReplicationRequest)replicaRequest).setCanHaveDuplicates();
                    }
                    if (shard.unassigned()) {
                        ++numberOfUnassignedOrIgnoredReplicas;
                        continue;
                    }
                    if (shard.primary()) {
                        if (!shard.relocating()) continue;
                        ++numberOfPendingShardInstances;
                        continue;
                    }
                    if (!var1_1.shouldExecuteReplication(this.indexMetaData.getSettings())) {
                        ++numberOfUnassignedOrIgnoredReplicas;
                        continue;
                    }
                    if (shard.relocating()) {
                        numberOfPendingShardInstances += 2;
                        continue;
                    }
                    ++numberOfPendingShardInstances;
                }
            }
            this.totalShards = 1 + numberOfPendingShardInstances + numberOfUnassignedOrIgnoredReplicas;
            this.pending = new AtomicInteger(numberOfPendingShardInstances);
        }

        int totalShards() {
            return this.totalShards;
        }

        int successful() {
            return this.success.get();
        }

        int pending() {
            return this.pending.get();
        }

        @Override
        public void onFailure(Throwable t) {
            this.this$0.logger.error("unexpected error while replicating for action [{}]. shard [{}]. ", t, this.this$0.actionName, this.shardIt.shardId());
            this.forceFinishAsFailed(t);
        }

        @Override
        protected void doRun() {
            ShardRouting shard;
            if (this.pending.get() == 0) {
                this.doFinish();
                return;
            }
            this.shardIt.reset();
            while ((shard = this.shardIt.nextOrNull()) != null) {
                if (shard.unassigned()) continue;
                if (shard.primary()) {
                    if (!this.originalPrimaryShard.currentNodeId().equals(shard.currentNodeId())) {
                        this.performOnReplica(shard, shard.currentNodeId());
                    }
                    if (!shard.relocating()) continue;
                    this.performOnReplica(shard, shard.relocatingNodeId());
                    continue;
                }
                if (!this.this$0.shouldExecuteReplication(this.indexMetaData.getSettings())) continue;
                this.performOnReplica(shard, shard.currentNodeId());
                if (!shard.relocating()) continue;
                this.performOnReplica(shard, shard.relocatingNodeId());
            }
        }

        void performOnReplica(final ShardRouting shard, final String nodeId) {
            if (!this.observer.observedState().nodes().nodeExists(nodeId)) {
                this.onReplicaFailure(nodeId, null);
                return;
            }
            ((ReplicationRequest)this.replicaRequest).internalShardId = this.shardIt.shardId();
            if (!nodeId.equals(this.observer.observedState().nodes().localNodeId())) {
                final DiscoveryNode node = this.observer.observedState().nodes().get(nodeId);
                this.this$0.transportService.sendRequest(node, this.this$0.transportReplicaAction, (TransportRequest)this.replicaRequest, this.this$0.transportOptions, new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleResponse(TransportResponse.Empty vResponse) {
                        ReplicationPhase.this.onReplicaSuccess();
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        ReplicationPhase.this.onReplicaFailure(nodeId, exp);
                        ReplicationPhase.this.this$0.logger.trace("[{}] transport failure during replica request [{}] ", exp, node, ReplicationPhase.this.replicaRequest);
                        if (!ReplicationPhase.this.this$0.ignoreReplicaException(exp)) {
                            ReplicationPhase.this.this$0.logger.warn("{} failed to perform {} on node {}", exp, ReplicationPhase.this.shardIt.shardId(), ReplicationPhase.this.this$0.actionName, node);
                            ReplicationPhase.this.this$0.shardStateAction.shardFailed(shard, ReplicationPhase.this.indexMetaData.getIndexUUID(), "failed to perform " + ReplicationPhase.this.this$0.actionName + " on replica on node " + node, exp);
                        }
                    }
                });
            } else {
                try {
                    this.this$0.threadPool.executor(this.this$0.executor).execute(new AbstractRunnable(){

                        @Override
                        protected void doRun() {
                            try {
                                ReplicationPhase.this.this$0.shardOperationOnReplica(shard.shardId(), ReplicationPhase.this.replicaRequest);
                                ReplicationPhase.this.onReplicaSuccess();
                            }
                            catch (Throwable e) {
                                ReplicationPhase.this.onReplicaFailure(nodeId, e);
                                ReplicationPhase.this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                            }
                        }

                        @Override
                        public boolean isForceExecution() {
                            return true;
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            ReplicationPhase.this.onReplicaFailure(nodeId, t);
                        }
                    });
                }
                catch (Throwable e) {
                    this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                    this.onReplicaFailure(nodeId, e);
                }
            }
        }

        void onReplicaFailure(String nodeId, @Nullable Throwable e) {
            if (e != null && !this.this$0.ignoreReplicaException(e)) {
                this.shardReplicaFailures.put(nodeId, e);
            }
            this.decPendingAndFinishIfNeeded();
        }

        void onReplicaSuccess() {
            this.success.incrementAndGet();
            this.decPendingAndFinishIfNeeded();
        }

        private void decPendingAndFinishIfNeeded() {
            if (this.pending.decrementAndGet() <= 0) {
                this.doFinish();
            }
        }

        private void forceFinishAsFailed(Throwable t) {
            if (this.finished.compareAndSet(false, true)) {
                Releasables.close(this.indexShardReference);
                this.listener.onFailure(t);
            }
        }

        private void doFinish() {
            if (this.finished.compareAndSet(false, true)) {
                ActionWriteResponse.ShardInfo.Failure[] failuresArray;
                Releasables.close(this.indexShardReference);
                ShardId shardId = this.shardIt.shardId();
                if (!this.shardReplicaFailures.isEmpty()) {
                    int slot = 0;
                    failuresArray = new ActionWriteResponse.ShardInfo.Failure[this.shardReplicaFailures.size()];
                    for (Map.Entry entry : this.shardReplicaFailures.entrySet()) {
                        RestStatus restStatus = ExceptionsHelper.status((Throwable)entry.getValue());
                        failuresArray[slot++] = new ActionWriteResponse.ShardInfo.Failure(shardId.getIndex(), shardId.getId(), (String)entry.getKey(), (Throwable)entry.getValue(), restStatus, false);
                    }
                } else {
                    failuresArray = ActionWriteResponse.EMPTY;
                }
                ((ActionWriteResponse)this.finalResponse).setShardInfo(new ActionWriteResponse.ShardInfo(this.totalShards, this.success.get(), failuresArray));
                this.listener.onResponse(this.finalResponse);
            }
        }
    }

    static final class PrimaryPhase
    extends AbstractRunnable {
        private final ActionListener<Response> listener;
        private final InternalRequest internalRequest;
        private final ClusterStateObserver observer;
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private volatile Releasable indexShardReference;
        final /* synthetic */ TransportReplicationAction this$0;

        PrimaryPhase(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.internalRequest = new InternalRequest((TransportReplicationAction)var1_1, request);
            this.listener = listener;
            this.observer = new ClusterStateObserver(var1_1.clusterService, ((ReplicationRequest)this.internalRequest.request()).timeout(), ((TransportReplicationAction)var1_1).logger);
        }

        @Override
        public void onFailure(Throwable e) {
            this.finishWithUnexpectedFailure(e);
        }

        @Override
        protected void doRun() {
            if (!this.checkBlocks()) {
                return;
            }
            ShardIterator shardIt = this.this$0.shards(this.observer.observedState(), this.internalRequest);
            ShardRouting primary = this.resolvePrimary(shardIt);
            if (primary == null) {
                this.retryBecauseUnavailable(shardIt.shardId(), "No active shards.");
                return;
            }
            if (!primary.active()) {
                this.this$0.logger.trace("primary shard [{}] is not yet active, scheduling a retry.", primary.shardId());
                this.retryBecauseUnavailable(shardIt.shardId(), "Primary shard is not active or isn't assigned to a known node.");
                return;
            }
            if (!this.observer.observedState().nodes().nodeExists(primary.currentNodeId())) {
                this.this$0.logger.trace("primary shard [{}] is assigned to anode we do not know the node, scheduling a retry.", primary.shardId(), primary.currentNodeId());
                this.retryBecauseUnavailable(shardIt.shardId(), "Primary shard is not active or isn't assigned to a known node.");
                return;
            }
            this.routeRequestOrPerformLocally(primary, shardIt);
        }

        protected boolean checkBlocks() {
            ClusterBlockException blockException = this.this$0.checkGlobalBlock(this.observer.observedState());
            if (blockException != null) {
                if (blockException.retryable()) {
                    this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                    this.retry(blockException);
                } else {
                    this.finishAsFailed(blockException);
                }
                return false;
            }
            if (this.this$0.resolveIndex()) {
                this.internalRequest.concreteIndex(this.this$0.indexNameExpressionResolver.concreteSingleIndex(this.observer.observedState(), (IndicesRequest)this.internalRequest.request()));
            } else {
                this.internalRequest.concreteIndex(((ReplicationRequest)this.internalRequest.request()).index());
            }
            this.this$0.resolveRequest(this.observer.observedState(), this.internalRequest, this.listener);
            blockException = this.this$0.checkRequestBlock(this.observer.observedState(), this.internalRequest);
            if (blockException != null) {
                if (blockException.retryable()) {
                    this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                    this.retry(blockException);
                } else {
                    this.finishAsFailed(blockException);
                }
                return false;
            }
            return true;
        }

        protected ShardRouting resolvePrimary(ShardIterator shardIt) {
            ShardRouting shard;
            while ((shard = shardIt.nextOrNull()) != null) {
                if (!shard.primary()) continue;
                return shard;
            }
            return null;
        }

        protected void routeRequestOrPerformLocally(final ShardRouting primary, final ShardIterator shardsIt) {
            if (primary.currentNodeId().equals(this.observer.observedState().nodes().localNodeId())) {
                try {
                    this.this$0.threadPool.executor(this.this$0.executor).execute(new AbstractRunnable(){

                        @Override
                        public void onFailure(Throwable t) {
                            PrimaryPhase.this.finishAsFailed(t);
                        }

                        @Override
                        protected void doRun() throws Exception {
                            PrimaryPhase.this.performOnPrimary(primary, shardsIt);
                        }
                    });
                }
                catch (Throwable t) {
                    this.finishAsFailed(t);
                }
            } else {
                DiscoveryNode node = this.observer.observedState().nodes().get(primary.currentNodeId());
                this.this$0.transportService.sendRequest(node, this.this$0.actionName, (TransportRequest)this.internalRequest.request(), this.this$0.transportOptions, new BaseTransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return PrimaryPhase.this.this$0.newResponseInstance();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        PrimaryPhase.this.finishOnRemoteSuccess(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        try {
                            if (exp.unwrapCause() instanceof ConnectTransportException || exp.unwrapCause() instanceof NodeClosedException || PrimaryPhase.this.this$0.retryPrimaryException(exp)) {
                                ((ReplicationRequest)PrimaryPhase.this.internalRequest.request()).setCanHaveDuplicates();
                                PrimaryPhase.this.this$0.logger.trace("received an error from node the primary was assigned to ({}), scheduling a retry", exp.getMessage());
                                PrimaryPhase.this.retry(exp);
                            } else {
                                PrimaryPhase.this.finishAsFailed(exp);
                            }
                        }
                        catch (Throwable t) {
                            PrimaryPhase.this.finishWithUnexpectedFailure(t);
                        }
                    }
                });
            }
        }

        void retry(Throwable failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.finishAsFailed(failure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    PrimaryPhase.this.run();
                }

                @Override
                public void onClusterServiceClose() {
                    PrimaryPhase.this.finishAsFailed(new NodeClosedException(PrimaryPhase.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    PrimaryPhase.this.run();
                }
            });
        }

        void finishAndMoveToReplication(ReplicationPhase replicationPhase) {
            if (this.finished.compareAndSet(false, true)) {
                replicationPhase.run();
            } else assert (false) : "finishAndMoveToReplication called but operation is already finished";
        }

        void finishAsFailed(Throwable failure) {
            if (this.finished.compareAndSet(false, true)) {
                Releasables.close(this.indexShardReference);
                this.this$0.logger.trace("operation failed", failure, new Object[0]);
                this.listener.onFailure(failure);
            } else assert (false) : "finishAsFailed called but operation is already finished";
        }

        void finishWithUnexpectedFailure(Throwable failure) {
            this.this$0.logger.warn("unexpected error during the primary phase for action [{}]", failure, this.this$0.actionName);
            if (this.finished.compareAndSet(false, true)) {
                Releasables.close(this.indexShardReference);
                this.listener.onFailure(failure);
            } else assert (false) : "finishWithUnexpectedFailure called but operation is already finished";
        }

        void finishOnRemoteSuccess(Response response) {
            if (this.finished.compareAndSet(false, true)) {
                this.this$0.logger.trace("operation succeeded", new Object[0]);
                this.listener.onResponse(response);
            } else assert (false) : "finishOnRemoteSuccess called but operation is already finished";
        }

        void performOnPrimary(ShardRouting primary, ShardIterator shardsIt) {
            ReplicationPhase replicationPhase;
            String writeConsistencyFailure = this.checkWriteConsistency(primary);
            if (writeConsistencyFailure != null) {
                this.retryBecauseUnavailable(primary.shardId(), writeConsistencyFailure);
                return;
            }
            try {
                this.indexShardReference = this.this$0.getIndexShardOperationsCounter(primary.shardId());
                PrimaryOperationRequest por = new PrimaryOperationRequest(this.this$0, primary.id(), this.internalRequest.concreteIndex(), this.internalRequest.request());
                Tuple primaryResponse = this.this$0.shardOperationOnPrimary(this.observer.observedState(), por);
                this.this$0.logger.trace("operation completed on primary [{}]", primary);
                replicationPhase = new ReplicationPhase(this.this$0, shardsIt, (ReplicationRequest)primaryResponse.v2(), (ActionWriteResponse)primaryResponse.v1(), this.observer, primary, this.internalRequest, this.listener, this.indexShardReference);
            }
            catch (Throwable e) {
                ((ReplicationRequest)this.internalRequest.request).setCanHaveDuplicates();
                if (this.this$0.retryPrimaryException(e)) {
                    this.this$0.logger.trace("had an error while performing operation on primary ({}), scheduling a retry.", e.getMessage());
                    Releasables.close(this.indexShardReference);
                    this.indexShardReference = null;
                    this.retry(e);
                    return;
                }
                if (ExceptionsHelper.status(e) == RestStatus.CONFLICT) {
                    if (this.this$0.logger.isTraceEnabled()) {
                        this.this$0.logger.trace(primary.shortSummary() + ": Failed to execute [" + this.internalRequest.request() + "]", e, new Object[0]);
                    }
                } else if (this.this$0.logger.isDebugEnabled()) {
                    this.this$0.logger.debug(primary.shortSummary() + ": Failed to execute [" + this.internalRequest.request() + "]", e, new Object[0]);
                }
                this.finishAsFailed(e);
                return;
            }
            this.finishAndMoveToReplication(replicationPhase);
        }

        String checkWriteConsistency(ShardRouting shard) {
            int requiredNumber;
            int sizeActive;
            if (!this.this$0.checkWriteConsistency) {
                return null;
            }
            WriteConsistencyLevel consistencyLevel = ((ReplicationRequest)this.internalRequest.request()).consistencyLevel() != WriteConsistencyLevel.DEFAULT ? ((ReplicationRequest)this.internalRequest.request()).consistencyLevel() : this.this$0.defaultWriteConsistencyLevel;
            IndexRoutingTable indexRoutingTable = this.observer.observedState().getRoutingTable().index(shard.index());
            if (indexRoutingTable != null) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shard.getId());
                if (shardRoutingTable != null) {
                    sizeActive = shardRoutingTable.activeShards().size();
                    requiredNumber = consistencyLevel == WriteConsistencyLevel.QUORUM && shardRoutingTable.getSize() > 2 ? shardRoutingTable.getSize() / 2 + 1 : (consistencyLevel == WriteConsistencyLevel.ALL ? shardRoutingTable.getSize() : 1);
                } else {
                    sizeActive = 0;
                    requiredNumber = 1;
                }
            } else {
                sizeActive = 0;
                requiredNumber = 1;
            }
            if (sizeActive < requiredNumber) {
                this.this$0.logger.trace("not enough active copies of shard [{}] to meet write consistency of [{}] (have {}, needed {}), scheduling a retry.", new Object[]{shard.shardId(), consistencyLevel, sizeActive, requiredNumber});
                return "Not enough active copies to meet write consistency of [" + (Object)((Object)consistencyLevel) + "] (have " + sizeActive + ", needed " + requiredNumber + ").";
            }
            return null;
        }

        void retryBecauseUnavailable(ShardId shardId, String message) {
            this.retry(new UnavailableShardsException(shardId, message + " Timeout: [" + ((ReplicationRequest)this.internalRequest.request()).timeout() + "], request: " + this.internalRequest.request().toString(), new Object[0]));
        }
    }

    public static class RetryOnPrimaryException
    extends ElasticsearchException {
        public RetryOnPrimaryException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public RetryOnPrimaryException(StreamInput in) throws IOException {
            super(in);
        }
    }

    protected static class PrimaryOperationRequest {
        public final ShardId shardId;
        public final Request request;
        final /* synthetic */ TransportReplicationAction this$0;

        public PrimaryOperationRequest(int shardId, String index, Request request) {
            this.this$0 = var1_1;
            this.shardId = new ShardId(index, shardId);
            this.request = request;
        }
    }

    private static final class AsyncReplicaAction
    extends AbstractRunnable {
        private final ReplicaRequest request;
        private final TransportChannel channel;
        private final ClusterStateObserver observer;
        final /* synthetic */ TransportReplicationAction this$0;

        AsyncReplicaAction(ReplicaRequest request, TransportChannel channel) {
            this.this$0 = var1_1;
            this.observer = new ClusterStateObserver(this.this$0.clusterService, null, this.this$0.logger);
            this.request = request;
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Throwable t) {
            if (t instanceof RetryOnReplicaException) {
                this.this$0.logger.trace("Retrying operation on replica", t, new Object[0]);
                this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        AsyncReplicaAction.this.this$0.threadPool.executor(AsyncReplicaAction.this.this$0.executor).execute(AsyncReplicaAction.this);
                    }

                    @Override
                    public void onClusterServiceClose() {
                        AsyncReplicaAction.this.responseWithFailure(new NodeClosedException(AsyncReplicaAction.this.this$0.clusterService.localNode()));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        throw new AssertionError((Object)"Cannot happen: there is not timeout");
                    }
                });
            } else {
                try {
                    this.this$0.failReplicaIfNeeded(((ReplicationRequest)this.request).internalShardId.getIndex(), ((ReplicationRequest)this.request).internalShardId.id(), t);
                }
                catch (Throwable unexpected) {
                    this.this$0.logger.error("{} unexpected error while failing replica", ((ReplicationRequest)this.request).internalShardId.id(), unexpected);
                }
                finally {
                    this.responseWithFailure(t);
                }
            }
        }

        protected void responseWithFailure(Throwable t) {
            try {
                this.channel.sendResponse(t);
            }
            catch (IOException responseException) {
                this.this$0.logger.warn("failed to send error message back to client for action [" + this.this$0.transportReplicaAction + "]", responseException, new Object[0]);
                this.this$0.logger.warn("actual Exception", t, new Object[0]);
            }
        }

        @Override
        protected void doRun() throws Exception {
            try (Releasable shardReference = this.this$0.getIndexShardOperationsCounter(((ReplicationRequest)this.request).internalShardId);){
                this.this$0.shardOperationOnReplica(((ReplicationRequest)this.request).internalShardId, this.request);
            }
            this.channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class RetryOnReplicaException
    extends ElasticsearchException {
        public RetryOnReplicaException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public RetryOnReplicaException(StreamInput in) throws IOException {
            super(in);
        }
    }

    class ReplicaOperationTransportHandler
    implements TransportRequestHandler<ReplicaRequest> {
        ReplicaOperationTransportHandler() {
        }

        @Override
        public void messageReceived(ReplicaRequest request, TransportChannel channel) throws Exception {
            new AsyncReplicaAction(TransportReplicationAction.this, request, channel).run();
        }
    }

    class OperationTransportHandler
    implements TransportRequestHandler<Request> {
        OperationTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            TransportReplicationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Throwable e1) {
                        TransportReplicationAction.this.logger.warn("Failed to send response for " + TransportReplicationAction.this.actionName, e1, new Object[0]);
                    }
                }
            });
        }
    }

    protected static class WriteResult<T extends ActionWriteResponse> {
        public final T response;
        public final Translog.Location location;

        public WriteResult(T response, Translog.Location location) {
            this.response = response;
            this.location = location;
        }

        public <T extends ActionWriteResponse> T response() {
            ((ActionWriteResponse)this.response).setShardInfo(new ActionWriteResponse.ShardInfo());
            return this.response;
        }
    }
}

