/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class GetWarmersResponse
extends ActionResponse {
    private ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> warmers = ImmutableOpenMap.of();

    GetWarmersResponse(ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> warmers) {
        this.warmers = warmers;
    }

    GetWarmersResponse() {
    }

    public ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> warmers() {
        return this.warmers;
    }

    public ImmutableOpenMap<String, List<IndexWarmersMetaData.Entry>> getWarmers() {
        return this.warmers();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<IndexWarmersMetaData.Entry> warmerEntryBuilder = new ArrayList<IndexWarmersMetaData.Entry>();
            for (int j = 0; j < valueSize; ++j) {
                String name = in.readString();
                String[] types = in.readStringArray();
                BytesReference source = in.readBytesReference();
                Boolean queryCache = null;
                queryCache = in.readOptionalBoolean();
                warmerEntryBuilder.add(new IndexWarmersMetaData.Entry(name, types, queryCache, source));
            }
            indexMapBuilder.put(key, Collections.unmodifiableList(warmerEntryBuilder));
        }
        this.warmers = indexMapBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.warmers.size());
        for (ObjectObjectCursor<String, List<IndexWarmersMetaData.Entry>> objectObjectCursor : this.warmers) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (IndexWarmersMetaData.Entry warmerEntry : (List)objectObjectCursor.value) {
                out.writeString(warmerEntry.name());
                out.writeStringArray(warmerEntry.types());
                out.writeBytesReference(warmerEntry.source());
                out.writeOptionalBoolean(warmerEntry.requestCache());
            }
        }
    }
}

