/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> allExports = new ArrayList<ExportedPackageImpl>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            ExportPackageDescription[] allDescriptions = this.framework.adaptor.getState().getExportedPackages();
            int i = 0;
            while (i < allDescriptions.length) {
                ExportedPackageImpl exportedPackage;
                if (allDescriptions[i].isRoot() && (exportedPackage = this.createExportedPackage(allDescriptions[i])) != null && (bundle == null || exportedPackage.supplier.getBundle() == bundle)) {
                    allExports.add(exportedPackage);
                }
                ++i;
            }
        }
        return allExports.size() == 0 ? null : allExports.toArray(new ExportedPackage[allExports.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription description) {
        BundleDescription exporter = description.getExporter();
        if (exporter == null || exporter.getHost() != null) {
            return null;
        }
        BundleLoaderProxy proxy = (BundleLoaderProxy)exporter.getUserObject();
        if (proxy == null) {
            BundleHost bundle = (BundleHost)this.framework.getBundle(exporter.getBundleId());
            if (bundle == null) {
                return null;
            }
            proxy = bundle.getLoaderProxy();
        }
        return new ExportedPackageImpl(description, proxy);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ExportedPackage result = null;
        int i = 0;
        while (i < allExports.length) {
            if (name.equals(allExports[i].getName())) {
                if (result == null) {
                    result = allExports[i];
                } else {
                    Version curVersion = Version.parseVersion(result.getSpecificationVersion());
                    Version newVersion = Version.parseVersion(allExports[i].getSpecificationVersion());
                    if (newVersion.compareTo(curVersion) >= 0) {
                        result = allExports[i];
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>(1);
        int i = 0;
        while (i < allExports.length) {
            if (name.equals(allExports[i].getName())) {
                result.add(allExports[i]);
            }
            ++i;
        }
        return result.size() == 0 ? null : result.toArray(new ExportedPackage[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] input) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        AbstractBundle[] copy = null;
        if (input != null) {
            Bundle[] bundleArray = input;
            // MONITORENTER : input
            copy = new AbstractBundle[input.length];
            System.arraycopy(input, 0, copy, 0, input.length);
            // MONITOREXIT : bundleArray
        }
        final AbstractBundle[] bundles = copy;
        Thread refresh = this.framework.secureAction.createThread(new Runnable(){

            public void run() {
                PackageAdminImpl.this.doResolveBundles(bundles, true);
            }
        }, "Refresh Packages");
        refresh.start();
    }

    public boolean resolveBundles(Bundle[] bundles) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        this.doResolveBundles(null, false);
        if (bundles == null) {
            bundles = this.framework.getAllBundles();
        }
        int i = 0;
        while (i < bundles.length) {
            if (!((AbstractBundle)bundles[i]).isResolved()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doResolveBundles(AbstractBundle[] bundles, boolean refreshPackages) {
        try {
            try {
                if (Profile.STARTUP) {
                    Profile.logEnter("resolve bundles");
                }
                this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
                AbstractBundle[] refreshedBundles = null;
                BundleDescription[] descriptions = null;
                BundleRepository bundleRepository = this.framework.bundles;
                synchronized (bundleRepository) {
                    int numBundles;
                    int n = numBundles = bundles == null ? 0 : bundles.length;
                    if (!refreshPackages) {
                        descriptions = new BundleDescription[]{};
                    } else if (numBundles > 0) {
                        ArrayList<BundleDescription> results = new ArrayList<BundleDescription>(numBundles);
                        int i = 0;
                        while (i < numBundles) {
                            AbstractBundle[] sameNames;
                            BundleDescription description = bundles[i].getBundleDescription();
                            if (description != null && description.getBundleId() != 0L && !results.contains(description)) {
                                results.add(description);
                            }
                            if ((sameNames = this.framework.bundles.getBundles(bundles[i].getSymbolicName())) != null && sameNames.length > 1) {
                                int j = 0;
                                while (j < sameNames.length) {
                                    BundleDescription sameName;
                                    if (sameNames[j] != bundles[i] && (sameName = sameNames[j].getBundleDescription()) != null && sameName.getBundleId() != 0L && !results.contains(sameName)) {
                                        results.add(sameName);
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        descriptions = results.size() == 0 ? null : results.toArray(new BundleDescription[results.size()]);
                    }
                }
                StateDelta stateDelta = this.framework.adaptor.getState().resolve(descriptions);
                refreshedBundles = this.processDelta(stateDelta.getChanges(), refreshPackages);
                if (refreshPackages) {
                    AbstractBundle[] allBundles = this.framework.getAllBundles();
                    int i = 0;
                    while (i < allBundles.length) {
                        allBundles[i].unresolvePermissions();
                        ++i;
                    }
                    this.resumeBundles(refreshedBundles);
                }
            }
            catch (Throwable t) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                    Debug.printStackTrace(t);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
            }
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("resolve bundles");
            }
            this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
            if (refreshPackages) {
                this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            }
        }
    }

    private void resumeBundles(AbstractBundle[] bundles) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (bundles == null) {
            return;
        }
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].isResolved()) {
                this.framework.resumeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private void suspendBundle(AbstractBundle bundle) {
        if (bundle.isActive() && !bundle.isFragment()) {
            this.framework.suspendBundle(bundle, true);
        } else if (bundle.getStateChanging() != Thread.currentThread()) {
            try {
                bundle.beginStateChange();
            }
            catch (BundleException e) {
                this.framework.publishFrameworkEvent(2, bundle, e);
            }
        }
        if (Debug.DEBUG_PACKAGEADMIN && bundle.stateChanging == null) {
            Debug.println("Bundle state change lock is clear! " + bundle);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundle = bundleDelta.getBundle();
            if (bundle.getDependents() != null && bundle.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("Bundles still depend on removed bundle! " + bundle);
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw new BundleException(Msg.OSGI_INTERNAL_ERROR);
            }
            BundleLoaderProxy proxy = (BundleLoaderProxy)bundle.getUserObject();
            if (proxy != null) {
                BundleHost.closeBundleLoader(proxy);
                try {
                    proxy.getBundleHost().getBundleData().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle bundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (bundle == null) {
            BundleException be = new BundleException(NLS.bind(Msg.BUNDLE_NOT_IN_FRAMEWORK, bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
            return null;
        }
        boolean resolve = true;
        if (bundle.isFragment()) {
            BundleDescription[] hosts = bundleDescription.getHost().getHosts();
            int i = 0;
            while (i < hosts.length) {
                BundleHost host = (BundleHost)this.framework.getBundle(hosts[i].getBundleId());
                resolve = ((BundleFragment)bundle).addHost(host.getLoaderProxy());
                ++i;
            }
        }
        if (resolve) {
            bundle.resolve();
        }
        return bundle;
    }

    private AbstractBundle[] applyDeltas(BundleDelta[] bundleDeltas) throws BundleException {
        ArrayList<AbstractBundle> results = new ArrayList<AbstractBundle>(bundleDeltas.length);
        int i = 0;
        while (i < bundleDeltas.length) {
            AbstractBundle bundle;
            int type = bundleDeltas[i].getType();
            if ((type & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltas[i]);
            }
            if ((type & 8) != 0 && (bundle = this.setResolved(bundleDeltas[i].getBundle())) != null && bundle.isResolved()) {
                results.add(bundle);
            }
            ++i;
        }
        return results.size() == 0 ? null : results.toArray(new AbstractBundle[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private AbstractBundle[] processDelta(BundleDelta[] bundleDeltas, boolean refreshPackages) {
        Util.sort(bundleDeltas, 0, bundleDeltas.length);
        bundlesList = new ArrayList<AbstractBundle>(bundleDeltas.length);
        i = 0;
        while (i < bundleDeltas.length) {
            if (!((bundleDeltas[i].getType() & 256) != 0 && (bundleDeltas[i].getType() & 2) == 0 || (changedBundle = this.framework.getBundle(bundleDeltas[i].getBundle().getBundleId())) == null || bundlesList.contains(changedBundle))) {
                bundlesList.add(changedBundle);
            }
            ++i;
        }
        refresh = bundlesList.toArray(new AbstractBundle[bundlesList.size()]);
        previouslyResolved = new boolean[refresh.length];
        resolved = null;
        try {
            block40: {
                try {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                    }
                    restart = false;
                    i = refresh.length - 1;
                    while (i >= 0) {
                        previouslyResolved[i] = refresh[i].isResolved();
                        if (refresh[i] == this.framework.systemBundle) {
                            restart = true;
                        } else if ((refresh[i].bundledata.getType() & 2) != 0 && previouslyResolved[i]) {
                            restart = true;
                        } else if ((refresh[i].bundledata.getType() & 4) != 0) {
                            restart = true;
                        }
                        --i;
                    }
                    if (restart) {
                        FrameworkProperties.setProperty("osgi.forcedRestart", "true");
                        if (refreshPackages) {
                            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                        }
                        this.restartFramework();
                    }
                    if (refreshPackages) {
                        i = refresh.length - 1;
                        while (i >= 0) {
                            this.suspendBundle(refresh[i]);
                            --i;
                        }
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: refresh the bundles");
                    }
                    i = this.framework.bundles;
                    synchronized (i) {
                        i = 0;
                        while (i < refresh.length) {
                            refresh[i].refresh();
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < refresh.length) {
                        if (previouslyResolved[i]) {
                            this.framework.publishBundleEvent(64, refresh[i]);
                        }
                        ++i;
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: applying deltas to bundles");
                    }
                    var8_15 = this.framework.bundles;
                    synchronized (var8_15) {
                        resolved = this.applyDeltas(bundleDeltas);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 6] lbl70 : MonitorExitStatement: MONITOREXIT : var8_15
                    }
                }
                finally {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    if (!refreshPackages) break block40;
                    i = 0;
                    ** while (i < refresh.length)
                }
lbl-1000:
                // 1 sources

                {
                    var12_21 = refresh[i];
                    var12_21.completeStateChange();
                    ++i;
                    continue;
                }
            }
            if (refreshPackages) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException e) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages exception: " + e.getMessage());
                        Debug.printStackTrace(e);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, e));
                }
            }
        }
        catch (BundleException e) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + e.getMessage());
                Debug.printStackTrace(e.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, e));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        if (resolved != null) {
            i = 0;
            while (i < resolved.length) {
                this.framework.publishBundleEvent(32, resolved[i]);
                ++i;
            }
        }
        return refresh;
    }

    private void restartFramework() {
        this.framework.shutdown();
        System.exit(23);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        AbstractBundle[] bundles = symbolicName == null ? this.framework.getAllBundles() : this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null || bundles.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> result = new ArrayList<BundleLoaderProxy>(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            if (!bundles[i].isFragment() && bundles[i].isResolved() && bundles[i].getSymbolicName() != null) {
                result.add(((BundleHost)bundles[i]).getLoaderProxy());
            }
            ++i;
        }
        return result.size() == 0 ? null : result.toArray(new RequiredBundle[result.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] bundles = this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null) {
            return null;
        }
        if (versionRange == null) {
            Bundle[] result = new AbstractBundle[bundles.length];
            System.arraycopy(bundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>(bundles.length);
        VersionRange range = new VersionRange(versionRange);
        int i = 0;
        while (i < bundles.length) {
            if (range.isIncluded(bundles[i].getVersion())) {
                result.add(bundles[i]);
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new AbstractBundle[result.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleLoaderProxy[] hosts = ((AbstractBundle)bundle).getHosts();
        if (hosts == null) {
            return null;
        }
        Bundle[] result = new Bundle[hosts.length];
        int i = 0;
        while (i < hosts.length) {
            result[i] = hosts[i].getBundleHost();
            ++i;
        }
        return result;
    }

    Bundle getBundlePriv(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleClassLoader) {
            return ((BundleLoader)((BundleClassLoader)((Object)cl)).getDelegate()).bundle;
        }
        if (cl == this.getClass().getClassLoader()) {
            return this.framework.systemBundle;
        }
        return null;
    }

    public Bundle getBundle(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return (Bundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PackageAdminImpl.this.getBundlePriv(clazz);
            }
        });
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(SystemBundle systemBundle) {
        this.checkSystemBundle(systemBundle);
        State state = this.framework.adaptor.getState();
        BundleDescription[] descriptions = state.getBundles();
        int i = 0;
        while (i < descriptions.length) {
            if (descriptions[i].getBundleId() == 0L) {
                this.setFrameworkVersion(descriptions[i]);
            } else {
                this.setResolved(descriptions[i]);
            }
            ++i;
        }
    }

    private void checkSystemBundle(SystemBundle systemBundle) {
        try {
            State state = this.framework.adaptor.getState();
            BundleDescription oldSystemBundle = state.getBundle(0L);
            boolean different = false;
            if (oldSystemBundle == null || !systemBundle.getBundleData().getVersion().equals(oldSystemBundle.getVersion())) {
                different = true;
            }
            if (!different && FrameworkProperties.getProperty("osgi.dev") == null) {
                return;
            }
            BundleDescription newSystemBundle = state.getFactory().createBundleDescription(state, systemBundle.getHeaders(""), systemBundle.getLocation(), 0L);
            if (newSystemBundle == null) {
                throw new BundleException(Msg.OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR);
            }
            if (!different) {
                ExportPackageDescription[] newPackages;
                ExportPackageDescription[] oldPackages = oldSystemBundle.getExportPackages();
                if (oldPackages.length >= (newPackages = newSystemBundle.getExportPackages()).length) {
                    int i = 0;
                    while (i < newPackages.length && !different) {
                        if (oldPackages[i].getName().equals(newPackages[i].getName())) {
                            Version oldVersion = oldPackages[i].getVersion();
                            Version newVersion = newPackages[i].getVersion();
                            different = oldVersion == null ? newVersion != null : !((Object)oldVersion).equals(newVersion);
                        } else {
                            different = true;
                        }
                        ++i;
                    }
                } else {
                    different = true;
                }
            }
            if (different) {
                state.removeBundle(0L);
                state.addBundle(newSystemBundle);
                state.resolve(false);
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, e.getMessage()));
        }
    }

    private void setFrameworkVersion(BundleDescription systemBundle) {
        ExportPackageDescription[] packages = systemBundle.getExportPackages();
        int i = 0;
        while (i < packages.length) {
            if (packages[i].getName().equals("org.osgi.framework")) {
                FrameworkProperties.setProperty("org.osgi.framework.version", packages[i].getVersion().toString());
                break;
            }
            ++i;
        }
        FrameworkProperties.setProperty("osgi.framework.version", systemBundle.getVersion().toString());
    }
}

