/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ContentHandlerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleNativeCode;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.MessageResourceBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.PermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class Framework
implements EventDispatcher,
EventPublisher {
    protected FrameworkAdaptor adaptor;
    protected Properties properties;
    protected boolean active;
    protected BundleRepository bundles;
    protected PackageAdminImpl packageAdmin;
    protected PermissionAdminImpl permissionAdmin;
    protected StartLevelManager startLevelManager;
    protected ServiceRegistry serviceRegistry;
    protected long serviceid;
    protected EventListeners bundleEvent;
    protected static final int BUNDLEEVENT = 1;
    protected EventListeners bundleEventSync;
    protected static final int BUNDLEEVENTSYNC = 2;
    protected EventListeners serviceEvent;
    protected static final int SERVICEEVENT = 3;
    protected EventListeners frameworkEvent;
    protected static final int FRAMEWORKEVENT = 4;
    protected static final int BATCHEVENT_BEGIN = -2147483647;
    protected static final int BATCHEVENT_END = Integer.MIN_VALUE;
    protected EventManager eventManager;
    protected Hashtable installLock;
    protected SystemBundle systemBundle;
    String[] bootDelegation;
    String[] bootDelegationStems;
    boolean bootDelegateAll = false;
    boolean contextBootDelegation = "true".equals(FrameworkProperties.getProperty("osgi.context.bootdelegation", "true"));
    protected static AliasMapper aliasMapper = new AliasMapper();
    protected ConditionalPermissionAdminImpl condPermAdmin;
    SecureAction secureAction = new SecureAction();
    private HashMap adminPermissions = new HashMap();
    private StreamHandlerFactory streamHandlerFactory;
    private org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory;

    public Framework(FrameworkAdaptor adaptor) {
        this.initialize(adaptor);
    }

    protected void initialize(FrameworkAdaptor adaptor) {
        BundleData[] bundleDatas;
        if (Profile.STARTUP) {
            Profile.logEnter("Framework.initialze()", null);
        }
        long start = System.currentTimeMillis();
        this.adaptor = adaptor;
        this.active = false;
        this.installSecurityManager();
        if (Debug.DEBUG_SECURITY) {
            Debug.println("SecurityManager: " + System.getSecurityManager());
            Debug.println("ProtectionDomain of Framework.class: \n" + this.getClass().getProtectionDomain());
        }
        MessageResourceBundle.setAdaptor(adaptor);
        adaptor.initialize(this);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter initialized");
        }
        try {
            adaptor.initializeStorage();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter storage initialized");
        }
        this.initializeProperties(adaptor.getProperties());
        this.packageAdmin = new PackageAdminImpl(this);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                this.permissionAdmin = new PermissionAdminImpl(this, adaptor.getPermissionStorage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            try {
                this.condPermAdmin = new ConditionalPermissionAdminImpl(this, adaptor.getPermissionStorage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done init props & new PermissionAdminImpl");
        }
        this.startLevelManager = new StartLevelManager(this);
        this.eventManager = new EventManager("Framework Event Dispatcher");
        this.bundleEvent = new EventListeners();
        this.bundleEventSync = new EventListeners();
        this.serviceEvent = new EventListeners();
        this.frameworkEvent = new EventListeners();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new EventManager");
        }
        this.serviceid = 1L;
        this.serviceRegistry = adaptor.getServiceRegistry();
        this.installLock = new Hashtable(10);
        this.createSystemBundle();
        this.loadVMProfile();
        this.setBootDelegation();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done createSystemBundle");
        }
        this.installURLStreamHandlerFactory(this.systemBundle.context, adaptor);
        this.installContentHandlerFactory(this.systemBundle.context, adaptor);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new URLStream/Content HandlerFactory");
        }
        this.bundles = new BundleRepository((bundleDatas = adaptor.getInstalledBundles()) == null ? 10 : bundleDatas.length + 1, this.packageAdmin);
        this.bundles.add(this.systemBundle);
        if (bundleDatas != null) {
            int i = 0;
            while (i < bundleDatas.length) {
                try {
                    AbstractBundle bundle = AbstractBundle.createBundle(bundleDatas[i], this);
                    this.bundles.add(bundle);
                }
                catch (BundleException be) {
                    this.publishFrameworkEvent(2, this.systemBundle, be);
                }
                ++i;
            }
        }
        if (Debug.DEBUG_GENERAL) {
            System.out.println("Initialize the framework: " + (System.currentTimeMillis() - start));
        }
        if (Profile.STARTUP) {
            Profile.logExit("Framework.initialize()");
        }
    }

    private void createSystemBundle() {
        try {
            this.systemBundle = new SystemBundle(this);
        }
        catch (BundleException e) {
            e.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, e.getMessage()));
        }
    }

    protected void initializeProperties(Properties adaptorProperties) {
        this.properties = FrameworkProperties.getProperties();
        Enumeration<?> enumKeys = adaptorProperties.propertyNames();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            if (this.properties.getProperty(key) != null) continue;
            this.properties.put(key, adaptorProperties.getProperty(key));
        }
        this.properties.put("org.osgi.framework.vendor", "Eclipse");
        this.properties.put("org.osgi.framework.version", "1.3");
        String value = this.properties.getProperty("org.osgi.framework.processor");
        if (value == null && (value = this.properties.getProperty("os.arch")) != null) {
            this.properties.put("org.osgi.framework.processor", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.name")) == null) {
            value = this.properties.getProperty("os.name");
            try {
                String canonicalValue = (String)aliasMapper.aliasOSName(value);
                if (canonicalValue != null) {
                    value = canonicalValue;
                }
            }
            catch (ClassCastException classCastException) {}
            if (value != null) {
                this.properties.put("org.osgi.framework.os.name", value);
            }
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.version")) == null && (value = this.properties.getProperty("os.version")) != null) {
            int space = value.indexOf(32);
            if (space > 0) {
                value = value.substring(0, space);
            }
            this.properties.put("org.osgi.framework.os.version", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.language")) == null) {
            this.properties.put("org.osgi.framework.language", Locale.getDefault().getLanguage());
        }
    }

    private void setBootDelegation() {
        String bootDelegationProp = this.properties.getProperty("org.osgi.framework.bootdelegation");
        if (bootDelegationProp == null) {
            return;
        }
        if (bootDelegationProp.trim().length() == 0) {
            return;
        }
        String[] bootPackages = ManifestElement.getArrayFromList(bootDelegationProp);
        ArrayList<String> exactMatch = new ArrayList<String>(bootPackages.length);
        ArrayList<String> stemMatch = new ArrayList<String>(bootPackages.length);
        int i = 0;
        while (i < bootPackages.length) {
            if (bootPackages[i].equals("*")) {
                this.bootDelegateAll = true;
                return;
            }
            if (bootPackages[i].endsWith("*")) {
                if (bootPackages[i].length() > 2 && bootPackages[i].endsWith(".*")) {
                    stemMatch.add(bootPackages[i].substring(0, bootPackages[i].length() - 1));
                }
            } else {
                exactMatch.add(bootPackages[i]);
            }
            ++i;
        }
        if (exactMatch.size() > 0) {
            this.bootDelegation = exactMatch.toArray(new String[exactMatch.size()]);
        }
        if (stemMatch.size() > 0) {
            this.bootDelegationStems = stemMatch.toArray(new String[stemMatch.size()]);
        }
    }

    private void loadVMProfile() {
        String ee;
        Properties profileProps = this.findVMProfile();
        String systemExports = this.properties.getProperty("org.osgi.framework.system.packages");
        if (systemExports == null && (systemExports = profileProps.getProperty("org.osgi.framework.system.packages")) != null) {
            this.properties.put("org.osgi.framework.system.packages", systemExports);
        }
        String type = this.properties.getProperty("osgi.java.profile.bootdelegation");
        String profileBootDelegation = profileProps.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(type)) {
            if (profileBootDelegation == null) {
                this.properties.remove("org.osgi.framework.bootdelegation");
            } else {
                this.properties.put("org.osgi.framework.bootdelegation", profileBootDelegation);
            }
        } else if ("none".equals(type)) {
            this.properties.remove("org.osgi.framework.bootdelegation");
        }
        if (this.properties.getProperty("org.osgi.framework.executionenvironment") == null && (ee = profileProps.getProperty("org.osgi.framework.executionenvironment", profileProps.getProperty("osgi.java.profile.name"))) != null) {
            this.properties.put("org.osgi.framework.executionenvironment", ee);
        }
    }

    private Properties findVMProfile() {
        String vmProfile;
        Properties result;
        block33: {
            result = new Properties();
            String j2meConfig = this.properties.getProperty("microedition.configuration");
            String j2meProfiles = this.properties.getProperty("microedition.profiles");
            vmProfile = null;
            if (j2meConfig != null && j2meConfig.length() > 0 && j2meProfiles != null && j2meProfiles.length() > 0) {
                String[] j2meProfileList = ManifestElement.getArrayFromList(j2meProfiles, " ");
                if (j2meProfileList != null && j2meProfileList.length > 0) {
                    vmProfile = String.valueOf(j2meConfig) + '_' + j2meProfileList[j2meProfileList.length - 1];
                }
            } else {
                String javaSpecVersion = this.properties.getProperty("java.specification.version");
                if (javaSpecVersion != null) {
                    StringTokenizer st = new StringTokenizer(javaSpecVersion, " _-");
                    javaSpecVersion = st.nextToken();
                    String javaSpecName = this.properties.getProperty("java.specification.name");
                    if ("J2ME Foundation Specification".equals(javaSpecName)) {
                        vmProfile = "CDC-" + javaSpecVersion + "_Foundation-" + javaSpecVersion;
                    } else {
                        Version v16 = new Version("1.6");
                        String javaEdition = "J2SE-";
                        try {
                            Version vEdition = new Version(javaSpecVersion);
                            if (v16.compareTo(vEdition) <= 0) {
                                javaEdition = "JavaSE-";
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        vmProfile = String.valueOf(javaEdition) + javaSpecVersion;
                    }
                }
            }
            URL url = null;
            String propJavaProfile = FrameworkProperties.getProperty("osgi.java.profile");
            if (propJavaProfile != null) {
                try {
                    url = new URL(propJavaProfile);
                }
                catch (MalformedURLException malformedURLException) {
                    url = this.findInSystemBundle(propJavaProfile);
                }
            }
            if (url == null && vmProfile != null) {
                String javaProfile = String.valueOf(vmProfile) + ".profile";
                url = this.findInSystemBundle(javaProfile);
            }
            if (url == null) {
                url = this.findInSystemBundle("OSGi_Minimum-1.0.profile");
            }
            if (url != null) {
                InputStream in;
                block32: {
                    in = null;
                    try {
                        try {
                            in = url.openStream();
                            result.load(new BufferedInputStream(in));
                        }
                        catch (IOException iOException) {
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block33;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (result.getProperty("osgi.java.profile.name") == null) {
            if (vmProfile != null) {
                result.put("osgi.java.profile.name", vmProfile.replace('_', '/'));
            } else {
                result.put("osgi.java.profile.name", "OSGi/Minimum-1.0");
            }
        }
        return result;
    }

    private URL findInSystemBundle(String entry) {
        URL result = this.systemBundle.getEntry(entry);
        if (result == null) {
            ClassLoader loader = this.getClass().getClassLoader();
            result = loader == null ? ClassLoader.getSystemResource(entry) : loader.getResource(entry);
        }
        return result;
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.active) {
            this.shutdown();
        }
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                bundle.close();
                ++i;
            }
            this.bundles.removeAllBundles();
        }
        this.serviceRegistry = null;
        if (this.bundleEvent != null) {
            this.bundleEvent.removeAllListeners();
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.bundleEventSync.removeAllListeners();
            this.bundleEventSync = null;
        }
        if (this.serviceEvent != null) {
            this.serviceEvent.removeAllListeners();
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.frameworkEvent.removeAllListeners();
            this.frameworkEvent = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        this.permissionAdmin = null;
        this.condPermAdmin = null;
        this.packageAdmin = null;
        this.adaptor = null;
        this.uninstallURLStreamHandlerFactory();
        this.uninstallContentHandlerFactory();
    }

    public synchronized void launch() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to launch framework");
        }
        this.systemBundle.resume();
    }

    public synchronized void shutdown() {
        if (!this.active) {
            return;
        }
        this.systemBundle.state = 16;
        this.publishBundleEvent(256, this.systemBundle);
        try {
            this.adaptor.frameworkStopping(this.systemBundle.getContext());
        }
        catch (Throwable t) {
            this.publishFrameworkEvent(2, this.systemBundle, t);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to shutdown Framework");
        }
        this.systemBundle.suspend();
        try {
            this.adaptor.compactStorage();
        }
        catch (IOException e) {
            this.publishFrameworkEvent(2, this.systemBundle, e);
        }
        this.active = false;
    }

    AbstractBundle createAndVerifyBundle(BundleData bundledata) throws BundleException {
        AbstractBundle installedBundle;
        if (bundledata.getSymbolicName() != null && (installedBundle = this.getBundleBySymbolicName(bundledata.getSymbolicName(), bundledata.getVersion())) != null && installedBundle.getBundleId() != bundledata.getBundleID()) {
            throw new BundleException(NLS.bind(Msg.BUNDLE_INSTALL_SAME_UNIQUEID, new Object[]{installedBundle.getSymbolicName(), installedBundle.getVersion().toString(), installedBundle.getLocation()}));
        }
        this.verifyExecutionEnvironment(bundledata.getManifest());
        return AbstractBundle.createBundle(bundledata, this);
    }

    protected boolean verifyExecutionEnvironment(Dictionary manifest) throws BundleException {
        int i;
        if (!Boolean.valueOf(FrameworkProperties.getProperty(Constants.ECLIPSE_EE_INSTALL_VERIFY, Boolean.TRUE.toString())).booleanValue()) {
            return true;
        }
        String headerValue = (String)manifest.get("Bundle-RequiredExecutionEnvironment");
        if (headerValue == null) {
            return true;
        }
        ManifestElement[] bundleRequiredEE = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", headerValue);
        if (bundleRequiredEE.length == 0) {
            return true;
        }
        String systemEE = FrameworkProperties.getProperty("org.osgi.framework.executionenvironment");
        if (systemEE != null && !systemEE.equals("")) {
            ManifestElement[] systemEEs = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", systemEE);
            i = 0;
            while (i < systemEEs.length) {
                int j = 0;
                while (j < bundleRequiredEE.length) {
                    if (systemEEs[i].getValue().equals(bundleRequiredEE[j].getValue())) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        StringBuffer bundleEE = new StringBuffer(25);
        i = 0;
        while (i < bundleRequiredEE.length) {
            if (i > 0) {
                bundleEE.append(",");
            }
            bundleEE.append(bundleRequiredEE[i].getValue());
            ++i;
        }
        throw new BundleException(NLS.bind(Msg.BUNDLE_INSTALL_REQUIRED_EE_EXCEPTION, bundleEE.toString()));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    protected String getProperty(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    protected Object setProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    public AbstractBundle installBundle(final String location) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from location: " + location);
        }
        final AccessControlContext callerContext = AccessController.getContext();
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                URLConnection source = Framework.this.adaptor.mapLocationToURLConnection(location);
                return Framework.this.installWorkerPrivileged(location, source, callerContext);
            }
        });
    }

    protected AbstractBundle installBundle(final String location, final InputStream in) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from inputstream: " + location + ", " + in);
        }
        final AccessControlContext callerContext = AccessController.getContext();
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                BundleSource source = new BundleSource(in);
                return Framework.this.installWorkerPrivileged(location, source, callerContext);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorker(String location, PrivilegedExceptionAction action) throws BundleException {
        Hashtable hashtable;
        AbstractBundle abstractBundle;
        Hashtable hashtable2 = this.installLock;
        synchronized (hashtable2) {
            while (true) {
                AbstractBundle bundle;
                if ((bundle = this.getBundleByLocation(location)) != null) {
                    return bundle;
                }
                Thread current = Thread.currentThread();
                Thread reservation = this.installLock.put(location, current);
                if (reservation == null) break;
                if (current.equals(reservation)) {
                    throw new BundleException(Msg.BUNDLE_INSTALL_RECURSION_EXCEPTION);
                }
                try {
                    this.installLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            AbstractBundle bundle = (AbstractBundle)AccessController.doPrivileged(action);
            this.publishBundleEvent(1, bundle);
            abstractBundle = bundle;
            hashtable = this.installLock;
        }
        catch (PrivilegedActionException e) {
            try {
                if (e.getException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getException();
                }
                throw (BundleException)e.getException();
            }
            catch (Throwable throwable) {
                hashtable = this.installLock;
                synchronized (hashtable) {
                    this.installLock.remove(location);
                    this.installLock.notifyAll();
                }
                throw throwable;
            }
        }
        synchronized (hashtable) {
            this.installLock.remove(location);
            this.installLock.notifyAll();
        }
        return abstractBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorkerPrivileged(String location, URLConnection source, AccessControlContext callerContext) throws BundleException {
        AbstractBundle bundle;
        BundleOperation storage = this.adaptor.installBundle(location, source);
        try {
            BundleData bundledata = storage.begin();
            bundle = this.createAndVerifyBundle(bundledata);
            BundleWatcher bundleStats = this.adaptor.getBundleWatcher();
            if (bundleStats != null) {
                bundleStats.watchBundle(bundle, 1);
            }
            try {
                try {
                    String[] nativepaths = this.selectNativeCode(bundle);
                    if (nativepaths != null) {
                        bundledata.installNativeCode(nativepaths);
                    }
                    bundle.load();
                    if (System.getSecurityManager() != null) {
                        boolean extension;
                        boolean bl = extension = (bundledata.getType() & 6) != 0;
                        if (extension && !bundle.hasPermission(new AllPermission())) {
                            throw new BundleException(Msg.BUNDLE_EXTENSION_PERMISSION, new SecurityException(Msg.BUNDLE_EXTENSION_PERMISSION));
                        }
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    Framework.this.checkAdminPermission(bundle, "lifecycle");
                                    if (extension) {
                                        Framework.this.checkAdminPermission(bundle, "extensionLifecycle");
                                    }
                                    return null;
                                }
                            }, callerContext);
                        }
                        catch (PrivilegedActionException e) {
                            throw e.getException();
                        }
                    }
                    storage.commit(false);
                }
                catch (Throwable error) {
                    BundleRepository bundleRepository = this.bundles;
                    synchronized (bundleRepository) {
                        bundle.unload();
                    }
                    bundle.close();
                    throw error;
                }
            }
            finally {
                BundleWatcher bundleStats2 = this.adaptor.getBundleWatcher();
                if (bundleStats2 != null) {
                    bundleStats2.watchBundle(bundle, 2);
                }
            }
            this.bundles.add(bundle);
        }
        catch (Throwable t) {
            try {
                storage.undo();
            }
            catch (BundleException ee) {
                this.publishFrameworkEvent(2, this.systemBundle, ee);
            }
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof BundleException) {
                throw (BundleException)t;
            }
            throw new BundleException(t.getMessage(), t);
        }
        return bundle;
    }

    String[] selectNativeCode(Bundle bundle) throws BundleException {
        Version osversion;
        String headerValue = (String)((AbstractBundle)bundle).getBundleData().getManifest().get("Bundle-NativeCode");
        if (headerValue == null) {
            return null;
        }
        ManifestElement[] elements = ManifestElement.parseHeader("Bundle-NativeCode", headerValue);
        ArrayList<BundleNativeCode> bundleNativeCodes = new ArrayList<BundleNativeCode>(elements.length);
        int length = elements.length;
        boolean optional = false;
        if (elements[length - 1].getValue().equals("*")) {
            optional = true;
            --length;
        }
        String processor = this.getProperty("org.osgi.framework.processor");
        String osname = this.getProperty("org.osgi.framework.os.name");
        try {
            osversion = Version.parseVersion(this.getProperty("org.osgi.framework.os.version"));
        }
        catch (Exception exception) {
            osversion = Version.emptyVersion;
        }
        String language = this.getProperty("org.osgi.framework.language");
        int i = 0;
        while (i < length) {
            BundleNativeCode bnc = new BundleNativeCode(elements[i], (AbstractBundle)bundle);
            if (bnc.matchProcessorOSNameFilter(processor, osname) > 0 && bnc.matchOSVersion(osversion) != null && bnc.matchLanguage(language) > 0) {
                bundleNativeCodes.add(bnc);
            }
            ++i;
        }
        if (bundleNativeCodes.size() == 0) {
            return this.noMatches(optional);
        }
        Iterator iter = bundleNativeCodes.iterator();
        BundleNativeCode highestRanking = (BundleNativeCode)iter.next();
        while (iter.hasNext()) {
            BundleNativeCode bnc = (BundleNativeCode)iter.next();
            if (!this.isBncGreaterThan(bnc, highestRanking, osversion, language)) continue;
            highestRanking = bnc;
        }
        return highestRanking.getPaths();
    }

    private boolean isBncGreaterThan(BundleNativeCode candidate, BundleNativeCode highestRanking, Version version, String language) {
        Version candidateHigh;
        Version currentHigh = highestRanking.matchOSVersion(version);
        if (currentHigh.compareTo(candidateHigh = candidate.matchOSVersion(version)) < 0) {
            return true;
        }
        return highestRanking.matchLanguage(language) < candidate.matchLanguage(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundle(long id) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundleBySymbolicName(String symbolicName, Version version) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(symbolicName, version);
        }
    }

    protected BundleRepository getBundles() {
        return this.bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getAllBundles() {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            int size;
            List allBundles;
            block4: {
                allBundles = this.bundles.getBundles();
                size = allBundles.size();
                if (size != 0) break block4;
                return null;
            }
            AbstractBundle[] bundlelist = new AbstractBundle[size];
            allBundles.toArray(bundlelist);
            return bundlelist;
        }
    }

    protected void resumeBundle(AbstractBundle bundle) {
        if (bundle.isActive()) {
            return;
        }
        try {
            int status = bundle.getBundleData().getStatus();
            if ((status & 1) == 0) {
                return;
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to start bundle " + bundle);
            }
            bundle.resume();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle resume exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
    }

    protected boolean suspendBundle(AbstractBundle bundle, boolean lock) {
        boolean changed = false;
        if (!bundle.isActive() || bundle.isFragment()) {
            return changed;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to suspend bundle " + bundle);
            }
            bundle.suspend(lock);
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle suspend exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
        if (!bundle.isActive()) {
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundleByLocation(String location) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            final String finalLocation = location;
            return (AbstractBundle)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    List allBundles = Framework.this.bundles.getBundles();
                    int size = allBundles.size();
                    int i = 0;
                    while (i < size) {
                        AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                        if (finalLocation.equals(bundle.getLocation())) {
                            return bundle;
                        }
                        ++i;
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getBundleBySymbolicName(String symbolicName) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundles(symbolicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference[] getServiceReferences(String clazz, String filterstring, BundleContextImpl context, boolean allservices) throws InvalidSyntaxException {
        FilterImpl filter = filterstring == null ? null : new FilterImpl(filterstring);
        ServiceReference[] services = null;
        if (clazz != null) {
            try {
                this.checkGetServicePermission(clazz);
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        ServiceRegistry serviceRegistry = this.serviceRegistry;
        synchronized (serviceRegistry) {
            block17: {
                services = this.serviceRegistry.lookupServiceReferences(clazz, filter);
                if (services != null) break block17;
                return null;
            }
            int removed = 0;
            int i = services.length - 1;
            while (i >= 0) {
                ServiceReferenceImpl ref = (ServiceReferenceImpl)services[i];
                String[] classes = ref.getClasses();
                if (allservices || context.isAssignableTo((ServiceReferenceImpl)services[i])) {
                    if (clazz == null) {
                        try {
                            this.checkGetServicePermission(classes);
                        }
                        catch (SecurityException securityException) {
                            services[i] = null;
                            ++removed;
                        }
                    }
                } else {
                    services[i] = null;
                    ++removed;
                }
                --i;
            }
            if (removed > 0) {
                ServiceReference[] temp = services;
                services = new ServiceReference[temp.length - removed];
                int i2 = temp.length - 1;
                while (i2 >= 0) {
                    if (temp[i2] == null) {
                        --removed;
                    } else {
                        services[i2 - removed] = temp[i2];
                    }
                    --i2;
                }
            }
        }
        return services == null || services.length == 0 ? null : services;
    }

    protected long getNextServiceId() {
        long id = this.serviceid++;
        return id;
    }

    protected File getDataFile(final AbstractBundle bundle, final String filename) {
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundle.getBundleData().getDataFile(filename);
            }
        });
    }

    protected void checkAdminPermission(Bundle bundle, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.getAdminPermission(bundle, action));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminPermission getAdminPermission(Bundle bundle, String action) {
        HashMap hashMap = this.adminPermissions;
        synchronized (hashMap) {
            AdminPermission result;
            Long ID = new Long(bundle.getBundleId());
            HashMap<String, AdminPermission> bundlePermissions = (HashMap<String, AdminPermission>)this.adminPermissions.get(ID);
            if (bundlePermissions == null) {
                bundlePermissions = new HashMap<String, AdminPermission>();
                this.adminPermissions.put(ID, bundlePermissions);
            }
            if ((result = (AdminPermission)bundlePermissions.get(action)) == null) {
                result = new AdminPermission(bundle, action);
                bundlePermissions.put(action, result);
            }
            return result;
        }
    }

    protected void checkRegisterServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int len = names.length;
            int i = 0;
            while (i < len) {
                sm.checkPermission(new ServicePermission(names[i], "register"));
                ++i;
            }
        }
    }

    protected void checkGetServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SecurityException se = null;
            int len = names.length;
            int i = 0;
            while (i < len) {
                try {
                    sm.checkPermission(new ServicePermission(names[i], "get"));
                    return;
                }
                catch (SecurityException e) {
                    se = e;
                    ++i;
                }
            }
            throw se;
        }
    }

    protected void checkGetServicePermission(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServicePermission(name, "get"));
        }
    }

    protected void installSecurityManager() {
        SecurityManager sm;
        String securityManager = System.getProperty("java.security.manager");
        if (securityManager != null && (sm = System.getSecurityManager()) == null) {
            if (securityManager.length() < 1) {
                securityManager = "java.lang.SecurityManager";
            }
            try {
                Class<?> clazz = Class.forName(securityManager);
                sm = (SecurityManager)clazz.newInstance();
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("Setting SecurityManager to: " + sm);
                }
                System.setSecurityManager(sm);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            throw new NoClassDefFoundError(securityManager);
        }
    }

    public void publishFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        if (this.frameworkEvent != null) {
            if (bundle == null) {
                bundle = this.systemBundle;
            }
            final FrameworkEvent event = new FrameworkEvent(type, bundle, throwable);
            if (System.getSecurityManager() == null) {
                this.publishFrameworkEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishFrameworkEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent event) {
        FrameworkLog frameworkLog;
        if (event.getType() == 2 && (frameworkLog = this.adaptor.getFrameworkLog()) != null) {
            frameworkLog.log(event);
        }
        ListenerQueue listeners = new ListenerQueue(this.eventManager);
        ListenerQueue contexts = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.frameworkEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.frameworkEvent, this);
            contexts.dispatchEventSynchronous(4, listeners);
        }
        listeners.dispatchEventAsynchronous(4, event);
    }

    public void publishBundleEvent(int type, Bundle bundle) {
        if (this.bundleEventSync != null || this.bundleEvent != null) {
            final BundleEvent event = new BundleEvent(type, bundle);
            if (System.getSecurityManager() == null) {
                this.publishBundleEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishBundleEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBundleEventPrivileged(BundleEvent event) {
        ListenerQueue listenersSync = null;
        if (this.bundleEventSync != null) {
            listenersSync = new ListenerQueue(this.eventManager);
            ListenerQueue contexts = new ListenerQueue(this.eventManager);
            EventListeners eventListeners = this.bundleEventSync;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEventSync, this);
                contexts.dispatchEventSynchronous(2, listenersSync);
            }
        }
        ListenerQueue listenersAsync = null;
        if (this.bundleEvent != null && (event.getType() & 0x180) == 0) {
            listenersAsync = new ListenerQueue(this.eventManager);
            ListenerQueue contexts = new ListenerQueue(this.eventManager);
            EventListeners eventListeners = this.bundleEvent;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEvent, this);
                contexts.dispatchEventSynchronous(1, listenersAsync);
            }
        }
        if (listenersSync != null) {
            listenersSync.dispatchEventSynchronous(2, event);
        }
        if (listenersAsync != null) {
            listenersAsync.dispatchEventAsynchronous(1, event);
        }
    }

    public void publishServiceEvent(int type, ServiceReference reference) {
        if (this.serviceEvent != null) {
            final ServiceEvent event = new ServiceEvent(type, reference);
            if (System.getSecurityManager() == null) {
                this.publishServiceEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishServiceEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishServiceEventPrivileged(ServiceEvent event) {
        ListenerQueue listeners = new ListenerQueue(this.eventManager);
        ListenerQueue contexts = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.serviceEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.serviceEvent, this);
            contexts.dispatchEventSynchronous(3, listeners);
        }
        listeners.dispatchEventSynchronous(3, event);
    }

    public void dispatchEvent(Object l, Object lo, int action, Object object) {
        block10: {
            try {
                BundleContextImpl context = (BundleContextImpl)l;
                if (context.isValid()) {
                    ListenerQueue queue = (ListenerQueue)object;
                    switch (action) {
                        case 1: {
                            queue.queueListeners(context.bundleEvent, context);
                            break;
                        }
                        case 2: {
                            queue.queueListeners(context.bundleEventSync, context);
                            break;
                        }
                        case 3: {
                            queue.queueListeners(context.serviceEvent, context);
                            break;
                        }
                        case 4: {
                            queue.queueListeners(context.frameworkEvent, context);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (Throwable t) {
                FrameworkEvent event;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in Top level event dispatcher: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                this.adaptor.handleRuntimeError(t);
                if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) break block10;
                BundleContextImpl context = (BundleContextImpl)l;
                this.publishFrameworkEvent(2, context.bundle, t);
            }
        }
    }

    private String[] noMatches(boolean optional) throws BundleException {
        if (optional) {
            return null;
        }
        throw new BundleException(Msg.BUNDLE_NATIVECODE_MATCH_EXCEPTION);
    }

    private static Field getStaticField(Class clazz, Class type) {
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (Modifier.isStatic(fields[i].getModifiers()) && fields[i].getType().equals(type)) {
                fields[i].setAccessible(true);
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    private void installContentHandlerFactory(BundleContext context, FrameworkAdaptor frameworkAdaptor) {
        org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory chf = new org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory(context, frameworkAdaptor);
        try {
            URLConnection.setContentHandlerFactory(chf);
        }
        catch (Error err) {
            try {
                Framework.forceContentHandlerFactory(chf);
            }
            catch (Exception ex) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, context.getBundle(), ex));
                throw err;
            }
        }
        this.contentHandlerFactory = chf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceContentHandlerFactory(org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory chf) throws Exception {
        Field factoryField = Framework.getStaticField(URLConnection.class, ContentHandlerFactory.class);
        if (factoryField == null) {
            throw new Exception("Could not find ContentHandlerFactory field");
        }
        Class<URLConnection> clazz = URLConnection.class;
        synchronized (URLConnection.class) {
            ContentHandlerFactory factory = (ContentHandlerFactory)factoryField.get(null);
            if (factory != null) {
                try {
                    factory.getClass().getMethod("isMultiplexing", null);
                    Method register = factory.getClass().getMethod("register", Object.class);
                    register.invoke((Object)factory, chf);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    chf.setParentFactory(factory);
                    factory = chf;
                }
            }
            factoryField.set(null, null);
            Framework.resetContentHandlers();
            URLConnection.setContentHandlerFactory(factory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallContentHandlerFactory() {
        try {
            Field factoryField = Framework.getStaticField(URLConnection.class, ContentHandlerFactory.class);
            if (factoryField == null) {
                return;
            }
            Class<URLConnection> clazz = URLConnection.class;
            synchronized (URLConnection.class) {
                ContentHandlerFactory factory = (ContentHandlerFactory)factoryField.get(null);
                if (factory == this.contentHandlerFactory) {
                    factory = (ContentHandlerFactory)this.contentHandlerFactory.designateSuccessor();
                } else {
                    Method unregister = factory.getClass().getMethod("unregister", Object.class);
                    unregister.invoke((Object)factory, this.contentHandlerFactory);
                }
                factoryField.set(null, null);
                Framework.resetContentHandlers();
                if (factory != null) {
                    URLConnection.setContentHandlerFactory(factory);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception exception) {}
        {
            return;
        }
    }

    private static void resetContentHandlers() throws IllegalAccessException {
        Hashtable handlers;
        Field handlersField = Framework.getStaticField(URLConnection.class, Hashtable.class);
        if (handlersField != null && (handlers = (Hashtable)handlersField.get(null)) != null) {
            handlers.clear();
        }
    }

    private void installURLStreamHandlerFactory(BundleContext context, FrameworkAdaptor frameworkAdaptor) {
        StreamHandlerFactory shf = new StreamHandlerFactory(context, frameworkAdaptor);
        try {
            URL.setURLStreamHandlerFactory(shf);
        }
        catch (Error err) {
            try {
                Framework.forceURLStreamHandlerFactory(shf);
            }
            catch (Exception ex) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, context.getBundle(), ex));
                throw err;
            }
        }
        this.streamHandlerFactory = shf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceURLStreamHandlerFactory(StreamHandlerFactory shf) throws Exception {
        Object lock;
        Field factoryField = Framework.getStaticField(URL.class, URLStreamHandlerFactory.class);
        if (factoryField == null) {
            throw new Exception("Could not find URLStreamHandlerFactory field");
        }
        Object object = lock = Framework.getURLStreamHandlerFactoryLock();
        synchronized (object) {
            URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
            if (factory != null) {
                try {
                    factory.getClass().getMethod("isMultiplexing", null);
                    Method register = factory.getClass().getMethod("register", Object.class);
                    register.invoke((Object)factory, shf);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    shf.setParentFactory(factory);
                    factory = shf;
                }
            }
            factoryField.set(null, null);
            Framework.resetURLStreamHandlers();
            URL.setURLStreamHandlerFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallURLStreamHandlerFactory() {
        try {
            Object lock;
            Field factoryField = Framework.getStaticField(URL.class, URLStreamHandlerFactory.class);
            if (factoryField == null) {
                return;
            }
            Object object = lock = Framework.getURLStreamHandlerFactoryLock();
            synchronized (object) {
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory == this.streamHandlerFactory) {
                    factory = (URLStreamHandlerFactory)this.streamHandlerFactory.designateSuccessor();
                } else {
                    Method unregister = factory.getClass().getMethod("unregister", Object.class);
                    unregister.invoke((Object)factory, this.streamHandlerFactory);
                }
                factoryField.set(null, null);
                Framework.resetURLStreamHandlers();
                if (factory != null) {
                    URL.setURLStreamHandlerFactory(factory);
                }
            }
        }
        catch (Exception exception) {}
    }

    private static Object getURLStreamHandlerFactoryLock() throws IllegalAccessException {
        Object lock;
        try {
            Field streamHandlerLockField = URL.class.getDeclaredField("streamHandlerLock");
            streamHandlerLockField.setAccessible(true);
            lock = streamHandlerLockField.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            lock = URL.class;
        }
        return lock;
    }

    private static void resetURLStreamHandlers() throws IllegalAccessException {
        Hashtable handlers;
        Field handlersField = Framework.getStaticField(URL.class, Hashtable.class);
        if (handlersField != null && (handlers = (Hashtable)handlersField.get(null)) != null) {
            handlers.clear();
        }
    }
}

