/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;

public class DeltaProcessingState
implements IResourceChangeListener {
    public IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    public int[] elementChangedListenerMasks = new int[5];
    public int elementChangedListenerCount = 0;
    public IResourceChangeListener[] preResourceChangeListeners = new IResourceChangeListener[1];
    public int[] preResourceChangeEventMasks = new int[1];
    public int preResourceChangeListenerCount = 0;
    private ThreadLocal deltaProcessors = new ThreadLocal();
    public HashMap roots = new HashMap();
    public HashMap otherRoots = new HashMap();
    public HashMap oldRoots = new HashMap();
    public HashMap oldOtherRoots = new HashMap();
    public HashMap sourceAttachments = new HashMap();
    public HashMap projectDependencies = new HashMap();
    public boolean rootsAreStale = true;
    private Set initializingThreads = Collections.synchronizedSet(new HashSet());
    public Hashtable externalTimeStamps;
    public HashMap projectUpdates = new HashMap();
    private HashSet javaProjectNamesCache;

    public synchronized void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int cloneLength = this.elementChangedListenerMasks.length;
                this.elementChangedListenerMasks = new int[cloneLength];
                System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
                this.elementChangedListenerMasks[i] = eventMask;
                return;
            }
            ++i;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    public void addPreResourceChangedListener(IResourceChangeListener listener, int eventMask) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i].equals(listener)) {
                int n = i;
                this.preResourceChangeEventMasks[n] = this.preResourceChangeEventMasks[n] | eventMask;
                return;
            }
            ++i;
        }
        int length = this.preResourceChangeListeners.length;
        if (length == this.preResourceChangeListenerCount) {
            this.preResourceChangeListeners = new IResourceChangeListener[length * 2];
            System.arraycopy(this.preResourceChangeListeners, 0, this.preResourceChangeListeners, 0, length);
            this.preResourceChangeEventMasks = new int[length * 2];
            System.arraycopy(this.preResourceChangeEventMasks, 0, this.preResourceChangeEventMasks, 0, length);
        }
        this.preResourceChangeListeners[this.preResourceChangeListenerCount] = listener;
        this.preResourceChangeEventMasks[this.preResourceChangeListenerCount] = eventMask;
        ++this.preResourceChangeListenerCount;
    }

    public DeltaProcessor getDeltaProcessor() {
        DeltaProcessor deltaProcessor = (DeltaProcessor)this.deltaProcessors.get();
        if (deltaProcessor != null) {
            return deltaProcessor;
        }
        deltaProcessor = new DeltaProcessor(this, JavaModelManager.getJavaModelManager());
        this.deltaProcessors.set(deltaProcessor);
        return deltaProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectReferences(JavaProject project, IClasspathEntry[] oldResolvedPath, IClasspathEntry[] newResolvedPath, IClasspathEntry[] newRawPath, boolean canChangeResources) throws JavaModelException {
        ProjectUpdateInfo info;
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            info = (ProjectUpdateInfo)(canChangeResources ? this.projectUpdates.remove(project) : this.projectUpdates.get(project));
            if (info == null) {
                info = new ProjectUpdateInfo();
                info.project = project;
                info.oldResolvedPath = oldResolvedPath;
                if (!canChangeResources) {
                    this.projectUpdates.put(project, info);
                }
            }
            info.newResolvedPath = newResolvedPath;
            info.newRawPath = newRawPath;
        }
        if (canChangeResources) {
            info.updateProjectReferencesIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeRoots() {
        HashMap<IPath, DeltaProcessor.RootInfo> newRoots = null;
        HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>> newOtherRoots = null;
        HashMap<void, IPath> newSourceAttachments = null;
        HashMap<IJavaProject, IJavaProject[]> newProjectDependencies = null;
        if (this.rootsAreStale) {
            Thread currentThread = Thread.currentThread();
            boolean addedCurrentThread = false;
            try {
                IJavaProject[] projects;
                if (!this.initializingThreads.add(currentThread)) {
                    return;
                }
                addedCurrentThread = true;
                JavaModelManager.getJavaModelManager().batchContainerInitializations = true;
                newRoots = new HashMap<IPath, DeltaProcessor.RootInfo>();
                newOtherRoots = new HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>>();
                newSourceAttachments = new HashMap<void, IPath>();
                newProjectDependencies = new HashMap<IJavaProject, IJavaProject[]>();
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                try {
                    projects = model.getJavaProjects();
                }
                catch (JavaModelException javaModelException) {
                    return;
                }
                int i = 0;
                int length = projects.length;
                while (i < length) {
                    block31: {
                        IClasspathEntry[] classpath;
                        JavaProject project = (JavaProject)projects[i];
                        try {
                            classpath = project.getResolvedClasspath(true, false, false);
                        }
                        catch (JavaModelException javaModelException) {
                            break block31;
                        }
                        int j = 0;
                        int classpathLength = classpath.length;
                        while (j < classpathLength) {
                            block32: {
                                IClasspathEntry entry = classpath[j];
                                if (entry.getEntryKind() == 2) {
                                    IJavaProject key = model.getJavaProject(entry.getPath().segment(0));
                                    IJavaProject[] dependents = (IJavaProject[])newProjectDependencies.get(key);
                                    if (dependents == null) {
                                        dependents = new IJavaProject[]{project};
                                    } else {
                                        int dependentsLength = dependents.length;
                                        IJavaProject[] iJavaProjectArray = dependents;
                                        dependents = new IJavaProject[dependentsLength + 1];
                                        System.arraycopy(iJavaProjectArray, 0, dependents, 0, dependentsLength);
                                        dependents[dependentsLength] = project;
                                    }
                                    newProjectDependencies.put(key, dependents);
                                } else {
                                    IPath path = entry.getPath();
                                    if (newRoots.get(path) == null) {
                                        newRoots.put(path, new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                    } else {
                                        ArrayList<DeltaProcessor.RootInfo> rootList = (ArrayList<DeltaProcessor.RootInfo>)newOtherRoots.get(path);
                                        if (rootList == null) {
                                            rootList = new ArrayList<DeltaProcessor.RootInfo>();
                                            newOtherRoots.put(path, rootList);
                                        }
                                        rootList.add(new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                    }
                                    if (entry.getEntryKind() == 1) {
                                        void var19_20;
                                        QualifiedName qName = new QualifiedName("org.eclipse.jdt.core", "sourceattachment: " + path.toOSString());
                                        String propertyString = null;
                                        try {
                                            propertyString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
                                        }
                                        catch (CoreException coreException) {
                                            break block32;
                                        }
                                        if (propertyString != null) {
                                            int index = propertyString.lastIndexOf(42);
                                            Path path2 = index < 0 ? new Path(propertyString) : new Path(propertyString.substring(0, index));
                                        } else {
                                            IPath iPath = entry.getSourceAttachmentPath();
                                        }
                                        if (var19_20 != null) {
                                            newSourceAttachments.put(var19_20, path);
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (addedCurrentThread) {
                    this.initializingThreads.remove(currentThread);
                }
            }
        }
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            this.oldRoots = this.roots;
            this.oldOtherRoots = this.otherRoots;
            if (!this.rootsAreStale || newRoots == null) return;
            this.roots = newRoots;
            this.otherRoots = newOtherRoots;
            this.sourceAttachments = newSourceAttachments;
            this.projectDependencies = newProjectDependencies;
            this.rootsAreStale = false;
            return;
        }
    }

    public synchronized ProjectUpdateInfo[] removeAllProjectUpdates() {
        int length = this.projectUpdates.size();
        if (length == 0) {
            return null;
        }
        ProjectUpdateInfo[] updates = new ProjectUpdateInfo[length];
        this.projectUpdates.values().toArray(updates);
        this.projectUpdates.clear();
        return updates;
    }

    public synchronized void removeElementChangedListener(IElementChangedListener listener) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int length = this.elementChangedListeners.length;
                IElementChangedListener[] newListeners = new IElementChangedListener[length];
                System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
                int[] newMasks = new int[length];
                System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
                int trailingLength = this.elementChangedListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
                }
                this.elementChangedListeners = newListeners;
                this.elementChangedListenerMasks = newMasks;
                --this.elementChangedListenerCount;
                return;
            }
            ++i;
        }
    }

    public void removePreResourceChangedListener(IResourceChangeListener listener) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i].equals(listener)) {
                int length = this.preResourceChangeListeners.length;
                IResourceChangeListener[] newListeners = new IResourceChangeListener[length];
                int[] newEventMasks = new int[length];
                System.arraycopy(this.preResourceChangeListeners, 0, newListeners, 0, i);
                System.arraycopy(this.preResourceChangeEventMasks, 0, newEventMasks, 0, i);
                int trailingLength = this.preResourceChangeListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.preResourceChangeListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.preResourceChangeEventMasks, i + 1, newEventMasks, i, trailingLength);
                }
                this.preResourceChangeListeners = newListeners;
                this.preResourceChangeEventMasks = newEventMasks;
                --this.preResourceChangeListenerCount;
                return;
            }
            ++i;
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            final IResourceChangeListener listener = this.preResourceChangeListeners[i];
            if ((this.preResourceChangeEventMasks[i] & event.getType()) != 0) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of pre Java resource change notification");
                    }

                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }
                });
            }
            ++i;
        }
        try {
            this.getDeltaProcessor().resourceChanged(event);
        }
        finally {
            if (event.getType() == 1) {
                this.deltaProcessors.set(null);
            }
        }
    }

    public Hashtable getExternalLibTimeStamps() {
        block16: {
            Hashtable<IPath, Long> timeStamps;
            block17: {
                FilterInputStream in;
                block15: {
                    if (this.externalTimeStamps != null) break block16;
                    timeStamps = new Hashtable<IPath, Long>();
                    File timestampsFile = this.getTimeStampsFile();
                    in = null;
                    try {
                        try {
                            in = new DataInputStream(new BufferedInputStream(new FileInputStream(timestampsFile)));
                            int size = ((DataInputStream)in).readInt();
                            while (size-- > 0) {
                                String key = ((DataInputStream)in).readUTF();
                                long timestamp = ((DataInputStream)in).readLong();
                                timeStamps.put(Path.fromPortableString((String)key), new Long(timestamp));
                            }
                        }
                        catch (IOException e) {
                            if (!timestampsFile.exists()) break block15;
                            Util.log(e, "Unable to read external time stamps");
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.externalTimeStamps = timeStamps;
        }
        return this.externalTimeStamps;
    }

    public IJavaProject findJavaProject(String name) {
        if (this.getOldJavaProjecNames().contains(name)) {
            return JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(name);
        }
        return null;
    }

    public synchronized HashSet getOldJavaProjecNames() {
        if (this.javaProjectNamesCache == null) {
            IJavaProject[] projects;
            HashSet<String> result = new HashSet<String>();
            try {
                projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            }
            catch (JavaModelException javaModelException) {
                return this.javaProjectNamesCache;
            }
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject project = projects[i];
                result.add(project.getElementName());
                ++i;
            }
            this.javaProjectNamesCache = result;
            return this.javaProjectNamesCache;
        }
        return this.javaProjectNamesCache;
    }

    public synchronized void resetOldJavaProjectNames() {
        this.javaProjectNamesCache = null;
    }

    private File getTimeStampsFile() {
        return JavaCore.getPlugin().getStateLocation().append("externalLibsTimeStamps").toFile();
    }

    public void saveExternalLibTimeStamps() throws CoreException {
        if (this.externalTimeStamps == null) {
            return;
        }
        File timestamps = this.getTimeStampsFile();
        FilterOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(timestamps)));
                ((DataOutputStream)out).writeInt(this.externalTimeStamps.size());
                for (IPath key : this.externalTimeStamps.keySet()) {
                    ((DataOutputStream)out).writeUTF(key.toPortableString());
                    Long timestamp = (Long)this.externalTimeStamps.get(key);
                    ((DataOutputStream)out).writeLong(timestamp);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.jdt.core", 4, "Problems while saving timestamps", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void updateRoots(IPath containerPath, IResourceDelta containerDelta, DeltaProcessor deltaProcessor) {
        HashMap otherUpdatedRoots;
        HashMap updatedRoots;
        if (containerDelta.getKind() == 2) {
            updatedRoots = this.oldRoots;
            otherUpdatedRoots = this.oldOtherRoots;
        } else {
            updatedRoots = this.roots;
            otherUpdatedRoots = this.otherRoots;
        }
        for (IPath path : updatedRoots.keySet()) {
            ArrayList rootList;
            IResourceDelta rootDelta;
            if (!containerPath.isPrefixOf(path) || containerPath.equals((Object)path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(1))) == null) continue;
            DeltaProcessor.RootInfo rootInfo2 = (DeltaProcessor.RootInfo)updatedRoots.get(path);
            if (!rootInfo2.project.getPath().isPrefixOf(path)) {
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
            if ((rootList = (ArrayList)otherUpdatedRoots.get(path)) == null) continue;
            for (DeltaProcessor.RootInfo rootInfo2 : rootList) {
                if (rootInfo2.project.getPath().isPrefixOf(path)) continue;
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
        }
    }

    public static class ProjectUpdateInfo {
        JavaProject project;
        IClasspathEntry[] oldResolvedPath;
        IClasspathEntry[] newResolvedPath;
        IClasspathEntry[] newRawPath;

        public void updateProjectReferencesIfNecessary() throws JavaModelException {
            block13: {
                String[] oldRequired;
                String[] stringArray = oldRequired = this.oldResolvedPath == null ? CharOperation.NO_STRINGS : this.project.projectPrerequisites(this.oldResolvedPath);
                if (this.newResolvedPath == null) {
                    if (this.newRawPath == null) {
                        this.newRawPath = this.project.getRawClasspath(true, false);
                    }
                    this.newResolvedPath = this.project.getResolvedClasspath(this.newRawPath, null, true, true, null);
                }
                String[] newRequired = this.project.projectPrerequisites(this.newResolvedPath);
                try {
                    int newSize;
                    HashSet newReferences;
                    IProjectDescription description;
                    IProject projectResource;
                    block12: {
                        String projectName;
                        projectResource = this.project.getProject();
                        description = projectResource.getDescription();
                        IProject[] projectReferences = description.getDynamicReferences();
                        HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                        int i = 0;
                        while (i < projectReferences.length) {
                            String projectName2 = projectReferences[i].getName();
                            oldReferences.add(projectName2);
                            ++i;
                        }
                        newReferences = (HashSet)oldReferences.clone();
                        int i2 = 0;
                        while (i2 < oldRequired.length) {
                            projectName = oldRequired[i2];
                            newReferences.remove(projectName);
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < newRequired.length) {
                            projectName = newRequired[i2];
                            newReferences.add(projectName);
                            ++i2;
                        }
                        newSize = newReferences.size();
                        if (oldReferences.size() == newSize) {
                            Iterator iter = newReferences.iterator();
                            while (iter.hasNext()) {
                                if (oldReferences.contains(iter.next())) {
                                    continue;
                                }
                                break block12;
                            }
                            return;
                        }
                    }
                    String[] requiredProjectNames = new String[newSize];
                    int index = 0;
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        requiredProjectNames[index++] = (String)iter.next();
                    }
                    Util.sort(requiredProjectNames);
                    IProject[] requiredProjectArray = new IProject[newSize];
                    IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
                    int i = 0;
                    while (i < newSize) {
                        requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                        ++i;
                    }
                    description.setDynamicReferences(requiredProjectArray);
                    projectResource.setDescription(description, null);
                }
                catch (CoreException e) {
                    if (" ".equals(this.project.getElementName())) break block13;
                    throw new JavaModelException(e);
                }
            }
        }
    }
}

