/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;
import org.eclipse.team.internal.ui.dialogs.PromptingDialog;

public abstract class WorkspaceAction
extends CVSAction {
    protected boolean beginExecution(IAction action) throws TeamException {
        if (super.beginExecution(action)) {
            if (this.requiresLocalSyncInfo()) {
                this.handleOrphanedSubtrees();
                if (!this.isEnabled()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)CVSUIMessages.CVSAction_disabledTitle, (String)CVSUIMessages.CVSAction_disabledMessage);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean handleOrphanedSubtrees() {
        IResource[] resources = this.getSelectedResources();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.handleOrphanedSubtree(resource);
            ++i;
        }
        return false;
    }

    private void handleOrphanedSubtree(IResource resource) {
        try {
            if (!CVSWorkspaceRoot.isSharedWithCVS((IResource)resource)) {
                return;
            }
            ICVSFolder folder = resource.getType() == 1 ? CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource.getParent()) : CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)resource));
            this.handleOrphanedSubtree(folder);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    private void handleOrphanedSubtree(final ICVSFolder folder) throws CVSException {
        if (folder.getIResource().getType() == 4) {
            return;
        }
        if (CVSWorkspaceRoot.isOrphanedSubtree((IContainer)((IContainer)folder.getIResource()))) {
            try {
                this.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            folder.unmanage(null);
                        }
                        catch (CVSException e) {
                            CVSProviderPlugin.log((CoreException)((Object)e));
                        }
                    }
                }, true, 2);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        this.handleOrphanedSubtree(folder.getParent());
    }

    protected boolean isSyncInfoLoaded(IResource[] resources) throws CVSException {
        return EclipseSynchronizer.getInstance().isSyncInfoLoaded(resources, this.getEnablementDepth());
    }

    protected int getActionDepth() {
        return 2;
    }

    protected int getEnablementDepth() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean ensureSyncInfoLoaded(IResource[] resources) throws CVSException {
        keepTrying = true;
        while (keepTrying) {
            block8: {
                try {
                    EclipseSynchronizer.getInstance().ensureSyncInfoLoaded(resources, this.getActionDepth());
                    keepTrying = false;
                    continue;
                }
                catch (CVSException e) {
                    if (e.getStatus().getCode() != 274) break block8;
                    projects = new HashSet<IProject>();
                    i = 0;
                    ** while (i < resources.length)
                }
lbl-1000:
                // 1 sources

                {
                    resource = resources[i];
                    projects.add(resource.getProject());
                    ++i;
                    continue;
                }
lbl17:
                // 1 sources

                if (this.promptToRefresh(this.getShell(), projects.toArray(new IResource[projects.size()]), e.getStatus())) {
                    for (IProject project : projects) {
                        try {
                            project.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {
                            throw CVSException.wrapException((CoreException)coreException);
                        }
                    }
                    continue;
                }
                return false;
            }
            throw e;
        }
        return true;
    }

    protected void setActionEnablement(IAction action) {
        try {
            boolean requires = this.requiresLocalSyncInfo();
            if (!requires || requires && this.isSyncInfoLoaded(this.getSelectedResources())) {
                super.setActionEnablement(action);
            } else {
                action.setEnabled(true);
            }
        }
        catch (CVSException cVSException) {
            action.setEnabled(true);
        }
    }

    protected boolean requiresLocalSyncInfo() {
        return true;
    }

    protected boolean promptToRefresh(final Shell shell, final IResource[] resources, final IStatus status) {
        final boolean[] result = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                Shell shellToUse = shell;
                if (shell == null) {
                    shellToUse = new Shell(Display.getCurrent());
                }
                String question = resources.length == 1 ? NLS.bind((String)CVSUIMessages.CVSAction_refreshQuestion, (Object[])new String[]{status.getMessage(), resources[0].getFullPath().toString()}) : NLS.bind((String)CVSUIMessages.CVSAction_refreshMultipleQuestion, (Object[])new String[]{status.getMessage()});
                result[0] = MessageDialog.openQuestion((Shell)shellToUse, (String)CVSUIMessages.CVSAction_refreshTitle, (String)question);
            }
        };
        Display.getDefault().syncExec(runnable);
        return result[0];
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    protected boolean isEnabled() throws TeamException {
        boolean enabled = super.isEnabled();
        if (enabled) {
            return true;
        }
        IResource[] resources = this.getSelectedResourcesWithOverlap();
        if (resources.length == 0) {
            return false;
        }
        if (!this.isEnabledForMultipleResources() && resources.length != 1) {
            return false;
        }
        ArrayList<IPath> folderPaths = new ArrayList<IPath>();
        ArrayList<IPath> filePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 4 && !resource.isAccessible()) {
                return false;
            }
            if (CVSWorkspaceRoot.isLinkedResource((IResource)resource)) {
                return false;
            }
            if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) == null) {
                return false;
            }
            IPath resourceFullPath = resource.getFullPath();
            if (resource.getType() == 1) {
                filePaths.add(resourceFullPath);
            } else {
                folderPaths.add(resourceFullPath);
            }
            ICVSResource cvsResource = this.getCVSResourceFor(resource);
            if (!this.isEnabledForCVSResource(cvsResource)) {
                return false;
            }
            ++i;
        }
        if (!folderPaths.isEmpty()) {
            for (IPath resourcePath : filePaths) {
                for (IPath folderPath : folderPaths) {
                    if (!folderPath.isPrefixOf(resourcePath)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        boolean managed = false;
        boolean ignored = false;
        boolean added = false;
        if (cvsResource.isIgnored()) {
            ignored = true;
        } else if (cvsResource.isFolder()) {
            managed = ((ICVSFolder)cvsResource).isCVSFolder();
        } else {
            ResourceSyncInfo info = cvsResource.getSyncInfo();
            boolean bl = managed = info != null;
            if (managed) {
                added = info.isAdded();
            }
        }
        if (managed && !this.isEnabledForManagedResources()) {
            return false;
        }
        if (!managed && !this.isEnabledForUnmanagedResources()) {
            return false;
        }
        if (ignored && !this.isEnabledForIgnoredResources()) {
            return false;
        }
        if (added && !this.isEnabledForAddedResources()) {
            return false;
        }
        return cvsResource.exists() || this.isEnabledForNonExistantResources();
    }

    protected boolean isEnabledForIgnoredResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForAddedResources() {
        return true;
    }

    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    protected boolean isEnabledForNonExistantResources() {
        return false;
    }

    protected void executeProviderAction(IProviderAction action, IResource[] resources, IProgressMonitor monitor) throws InvocationTargetException {
        Hashtable table = this.getProviderMapping(resources);
        Set keySet = table.keySet();
        monitor.beginTask(null, keySet.size() * 1000);
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
            List list = (List)table.get(provider);
            IResource[] providerResources = list.toArray(new IResource[list.size()]);
            try {
                this.addStatus(action.execute(provider, providerResources, (IProgressMonitor)subMonitor));
            }
            catch (CVSException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    protected void executeProviderAction(IProviderAction action, IProgressMonitor monitor) throws InvocationTargetException {
        this.executeProviderAction(action, this.getSelectedResources(), monitor);
    }

    protected String calculateActionTagValue() {
        try {
            IResource[] resources = this.getSelectedResources();
            CVSTag commonTag = null;
            boolean sameTagType = true;
            boolean multipleSameNames = true;
            int i = 0;
            while (i < resources.length) {
                ICVSResource cvsResource = this.getCVSResourceFor(resources[i]);
                CVSTag tag = null;
                if (cvsResource.isFolder()) {
                    FolderSyncInfo info = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                    if (info != null) {
                        tag = info.getTag();
                    }
                    if (tag != null && tag.getType() == 1) {
                        tag = Util.getAccurateFolderTag((IResource)resources[i], (CVSTag)tag);
                    }
                } else {
                    tag = Util.getAccurateFileTag((ICVSResource)cvsResource);
                }
                if (tag == null) {
                    tag = new CVSTag();
                }
                if (commonTag == null) {
                    commonTag = tag;
                } else if (!commonTag.equals((Object)tag)) {
                    if (commonTag.getType() != tag.getType()) {
                        sameTagType = false;
                    }
                    if (!commonTag.getName().equals(tag.getName())) {
                        multipleSameNames = false;
                    }
                }
                ++i;
            }
            String actionText = CVSUIMessages.ReplaceWithLatestAction_multipleTags;
            if (commonTag != null) {
                int tagType = commonTag.getType();
                String tagName = commonTag.getName();
                if (sameTagType && !multipleSameNames) {
                    actionText = tagType == 1 ? CVSUIMessages.ReplaceWithLatestAction_multipleBranches : CVSUIMessages.ReplaceWithLatestAction_multipleVersions;
                } else if (sameTagType && multipleSameNames) {
                    if (tagType == 1) {
                        actionText = NLS.bind((String)CVSUIMessages.ReplaceWithLatestAction_singleBranch, (Object[])new String[]{tagName});
                    } else if (tagType == 2) {
                        actionText = NLS.bind((String)CVSUIMessages.ReplaceWithLatestAction_singleVersion, (Object[])new String[]{tagName});
                    } else if (tagType == 0) {
                        actionText = NLS.bind((String)CVSUIMessages.ReplaceWithLatestAction_singleHEAD, (Object[])new String[]{tagName});
                    }
                }
            }
            return actionText;
        }
        catch (CVSException cVSException) {
            return CVSUIMessages.ReplaceWithLatestAction_multipleTags;
        }
    }

    protected IResource[] checkOverwriteOfDirtyResources(IResource[] resources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        ArrayList<IResource> dirtyResources = new ArrayList<IResource>();
        IResource[] selectedResources = this.getSelectedResources();
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, selectedResources.length * 100);
            monitor.setTaskName(CVSUIMessages.ReplaceWithAction_calculatingDirtyResources);
            int i = 0;
            while (i < selectedResources.length) {
                IResource resource = selectedResources[i];
                ICVSResource cvsResource = this.getCVSResourceFor(resource);
                if (cvsResource.isModified(Policy.subMonitorFor(monitor, 100))) {
                    dirtyResources.add(resource);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        PromptingDialog dialog = new PromptingDialog(this.getShell(), selectedResources, this.getPromptCondition(dirtyResources.toArray(new IResource[dirtyResources.size()])), CVSUIMessages.ReplaceWithAction_confirmOverwrite);
        return dialog.promptForMultiple();
    }

    protected IPromptCondition getPromptCondition(IResource[] resources) {
        return WorkspaceAction.getOverwriteLocalChangesPrompt(resources);
    }

    public static interface IProviderAction {
        public IStatus execute(CVSTeamProvider var1, IResource[] var2, IProgressMonitor var3) throws CVSException;
    }
}

