/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.actions.FindReferencesAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class FindReferencesInHierarchyAction
extends FindReferencesAction {
    public FindReferencesInHierarchyAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReferencesInHierarchyAction(JavaEditor editor) {
        super(editor);
    }

    Class[] getValidTypes() {
        return new Class[]{ICompilationUnit.class, IType.class, IMethod.class, IField.class, ILocalVariable.class, ITypeParameter.class};
    }

    void init() {
        this.setText(SearchMessages.Search_FindHierarchyReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindHierarchyReferencesAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_references_in_hierarchy_action");
    }

    QuerySpecification createQuery(IJavaElement element) throws JavaModelException {
        IType type = this.getType(element);
        if (type == null) {
            return super.createQuery(element);
        }
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        String description = factory.getHierarchyScopeDescription(type);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

