/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckIterator;
import org.eclipse.jdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;

public class JavaSpellingEngine
extends SpellingEngine {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void check(IDocument document, IRegion[] regions, ISpellChecker checker, Locale locale, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        SpellingEngine.SpellEventListener listener = new SpellingEngine.SpellEventListener(collector);
        try {
            checker.addListener(listener);
            try {
                int i = 0;
                while (i < regions.length) {
                    IRegion region = regions[i];
                    ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)"___java_partitioning", (int)region.getOffset(), (int)region.getLength(), (boolean)false);
                    int index = 0;
                    while (index < partitions.length) {
                        if (monitor != null && monitor.isCanceled()) {
                            return;
                        }
                        ITypedRegion partition = partitions[index];
                        if (!partition.getType().equals("__dftl_partition_content_type")) {
                            checker.execute(new SpellCheckIterator(document, (IRegion)partition, locale));
                        }
                        ++index;
                    }
                    ++i;
                }
                return;
            }
            catch (BadLocationException x) {
                JavaPlugin.log(x);
                return;
            }
        }
        finally {
            checker.removeListener(listener);
        }
    }
}

