/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.NLSKeyHyperlink;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class NLSKeyHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public NLSKeyHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || this.fTextEditor == null || canShowMultipleHyperlinks) {
            return null;
        }
        IEditorSite site = this.fTextEditor.getEditorSite();
        if (site == null) {
            return null;
        }
        IJavaElement javaElement = this.getInputJavaElement(this.fTextEditor);
        if (javaElement == null) {
            return null;
        }
        CompilationUnit ast = JavaPlugin.getDefault().getASTProvider().getAST(javaElement, ASTProvider.WAIT_NO, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, region.getOffset(), 1);
        if (!(node instanceof StringLiteral) && !(node instanceof SimpleName)) {
            return null;
        }
        if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        Region nlsKeyRegion = new Region(node.getStartPosition(), node.getLength());
        AccessorClassReference ref = NLSHintHelper.getAccessorClassReference(ast, (IRegion)nlsKeyRegion);
        if (ref == null) {
            return null;
        }
        String keyName = null;
        keyName = node instanceof StringLiteral ? ((StringLiteral)node).getLiteralValue() : ((SimpleName)node).getIdentifier();
        if (keyName != null) {
            return new IHyperlink[]{new NLSKeyHyperlink((IRegion)nlsKeyRegion, keyName, ref, (IEditorPart)this.fTextEditor)};
        }
        return null;
    }

    private IJavaElement getInputJavaElement(ITextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)editorInput).getClassFile();
        }
        if (editor instanceof CompilationUnitEditor) {
            return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        }
        return null;
    }
}

