/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.jdt.internal.ui.compare.JavaTextBufferNode;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

class JavaCompareWithEditionActionImpl
extends JavaHistoryActionImpl {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.CompareWithEditionAction";

    JavaCompareWithEditionActionImpl() {
        super(false);
    }

    public void run(ISelection selection) {
        String errorTitle = CompareMessages.CompareWithHistory_title;
        String errorMessage = CompareMessages.CompareWithHistory_internalErrorMessage;
        IMember input = this.getEditionElement(selection);
        if (input == null) {
            String invalidSelectionMessage = CompareMessages.CompareWithHistory_invalidSelectionMessage;
            MessageDialog.openInformation((Shell)this.getShell(), (String)errorTitle, (String)invalidSelectionMessage);
            return;
        }
        IFile file = this.getFile(input);
        if (file == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)errorTitle, (String)errorMessage);
            return;
        }
        boolean inEditor = this.beingEdited(file);
        IPath path = file.getFullPath();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = null;
        try {
            try {
                bufferManager.connect(path, null);
                textFileBuffer = bufferManager.getTextFileBuffer(path);
                JavaTextBufferNode target = new JavaTextBufferNode(file, textFileBuffer.getDocument(), inEditor);
                ITypedElement[] editions = this.buildEditions(target, file);
                ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                EditionSelectionDialog d = new EditionSelectionDialog(this.getShell(), bundle);
                d.setHelpContextId("org.eclipse.jdt.ui.compare_element_with_history_dialog_context");
                d.setCompareMode(true);
                Image image = JavaCompareUtilities.getImage(input);
                d.setEditionTitleImage(image);
                d.selectEdition((ITypedElement)target, editions, (Object)input);
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, this.getShell(), errorTitle, errorMessage);
            }
        }
        finally {
            try {
                if (textFileBuffer != null) {
                    bufferManager.disconnect(path, null);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }
}

