/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.IConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.IContext;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.NullContext;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.RawBindingVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;

public class FullConstraintCreator
extends ConstraintCreator {
    private final IConstraintVariableFactory fConstraintVariableFactory;
    private final ITypeConstraintFactory fTypeConstraintFactory;
    private IContext fContext;

    public FullConstraintCreator() {
        this(new ConstraintVariableFactory(), new TypeConstraintFactory());
    }

    public FullConstraintCreator(IConstraintVariableFactory cFactory, ITypeConstraintFactory tFactory) {
        Assert.isTrue((cFactory != null ? 1 : 0) != 0);
        this.fConstraintVariableFactory = cFactory;
        this.fTypeConstraintFactory = tFactory;
        this.fContext = new NullContext();
    }

    public IContext getContext() {
        return this.fContext;
    }

    public void setContext(IContext context) {
        this.fContext = context;
    }

    public ITypeConstraintFactory getConstraintFactory() {
        return this.fTypeConstraintFactory;
    }

    public IConstraintVariableFactory getConstraintVariableFactory() {
        return this.fConstraintVariableFactory;
    }

    public ITypeConstraint[] create(ArrayInitializer arrayInitializer) {
        ITypeBinding arrayBinding = arrayInitializer.resolveTypeBinding();
        Assert.isTrue((boolean)arrayBinding.isArray());
        List expressions = arrayInitializer.expressions();
        ArrayList constraints = new ArrayList();
        Type type = FullConstraintCreator.getTypeParent(arrayInitializer);
        TypeVariable typeVariable = this.fConstraintVariableFactory.makeTypeVariable(type);
        int i = 0;
        while (i < expressions.size()) {
            Expression each = (Expression)expressions.get(i);
            ITypeConstraint[] c = this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(each, this.getContext()), typeVariable);
            constraints.addAll(Arrays.asList(c));
            ++i;
        }
        return constraints.toArray(new ITypeConstraint[constraints.size()]);
    }

    public ITypeConstraint[] create(Assignment assignment) {
        return this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(assignment.getRightHandSide(), this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable(assignment.getLeftHandSide(), this.getContext()));
    }

    public ITypeConstraint[] create(CastExpression castExpression) {
        Expression expression = castExpression.getExpression();
        Type type = castExpression.getType();
        ITypeConstraint[] definesConstraint = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)castExpression, this.getContext()), this.fConstraintVariableFactory.makeTypeVariable(castExpression.getType()));
        if (FullConstraintCreator.isClassBinding(expression.resolveTypeBinding()) && FullConstraintCreator.isClassBinding(type.resolveBinding())) {
            ConstraintVariable expressionVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext());
            ConstraintVariable castExpressionVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)castExpression, this.getContext());
            ITypeConstraint[] c2 = this.createOrOrSubtypeConstraint(expressionVariable, castExpressionVariable);
            if (definesConstraint.length == 0) {
                return c2;
            }
            ITypeConstraint c1 = definesConstraint[0];
            ArrayList<ITypeConstraint> constraints = new ArrayList<ITypeConstraint>();
            constraints.add(c1);
            constraints.addAll((Collection)Arrays.asList(c2));
            return constraints.toArray(new ITypeConstraint[constraints.size()]);
        }
        return definesConstraint;
    }

    public ITypeConstraint[] create(CatchClause node) {
        SingleVariableDeclaration exception = node.getException();
        ConstraintVariable nameVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)exception.getName(), this.getContext());
        ITypeConstraint[] defines = this.fTypeConstraintFactory.createDefinesConstraint(nameVariable, this.fConstraintVariableFactory.makeTypeVariable(exception.getType()));
        ITypeBinding throwable = node.getAST().resolveWellKnownType("java.lang.Throwable");
        ITypeConstraint[] catchBound = this.fTypeConstraintFactory.createSubtypeConstraint(nameVariable, this.fConstraintVariableFactory.makeRawBindingVariable(throwable));
        ArrayList result = new ArrayList();
        result.addAll(Arrays.asList(defines));
        result.addAll(Arrays.asList(catchBound));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(ClassInstanceCreation instanceCreation) {
        List arguments = instanceCreation.arguments();
        ArrayList result = new ArrayList(arguments.size());
        IMethodBinding methodBinding = instanceCreation.resolveConstructorBinding();
        result.addAll(Arrays.asList(this.getArgumentConstraints(arguments, methodBinding)));
        if (instanceCreation.getAnonymousClassDeclaration() == null) {
            ConstraintVariable constructorVar = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)instanceCreation, this.getContext());
            RawBindingVariable typeVar = this.fConstraintVariableFactory.makeRawBindingVariable(instanceCreation.resolveTypeBinding());
            result.addAll(Arrays.asList(this.fTypeConstraintFactory.createDefinesConstraint(constructorVar, typeVar)));
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(ConstructorInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList result = new ArrayList(arguments.size());
        IMethodBinding methodBinding = invocation.resolveConstructorBinding();
        result.addAll(Arrays.asList(this.getArgumentConstraints(arguments, methodBinding)));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(FieldAccess access) {
        Expression expression = access.getExpression();
        SimpleName name = access.getName();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return new ITypeConstraint[0];
        }
        IVariableBinding vb = (IVariableBinding)binding;
        return this.createConstraintsForAccessToField(vb, expression, (Expression)access);
    }

    public ITypeConstraint[] create(FieldDeclaration fd) {
        ArrayList result = new ArrayList();
        result.addAll(Arrays.asList(this.getConstraintsFromFragmentList(fd.fragments(), fd.getType())));
        result.addAll(this.getConstraintsForHiding(fd));
        result.addAll(this.getConstraintsForFieldDeclaringTypes(fd));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(InstanceofExpression instanceofExpression) {
        Expression expression = instanceofExpression.getLeftOperand();
        Type type = instanceofExpression.getRightOperand();
        if (FullConstraintCreator.isClassBinding(expression.resolveTypeBinding()) && FullConstraintCreator.isClassBinding(type.resolveBinding())) {
            ConstraintVariable expressionVar = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext());
            TypeVariable typeVariable = this.fConstraintVariableFactory.makeTypeVariable(type);
            return this.createOrOrSubtypeConstraint(expressionVar, typeVariable);
        }
        return new ITypeConstraint[0];
    }

    public ITypeConstraint[] create(ConditionalExpression node) {
        ArrayList result = new ArrayList();
        Expression thenExpression = node.getThenExpression();
        Expression elseExpression = node.getElseExpression();
        ConstraintVariable whole = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)node, this.getContext());
        ConstraintVariable ev1 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(thenExpression, this.getContext());
        ConstraintVariable ev2 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(elseExpression, this.getContext());
        ITypeConstraint[] constraints1 = this.fTypeConstraintFactory.createEqualsConstraint(ev1, ev2);
        ITypeConstraint[] constraints2 = this.fTypeConstraintFactory.createSubtypeConstraint(ev1, whole);
        ITypeConstraint[] constraints3 = this.fTypeConstraintFactory.createSubtypeConstraint(ev2, whole);
        result.addAll(Arrays.asList(constraints1));
        result.addAll(Arrays.asList(constraints2));
        result.addAll(Arrays.asList(constraints3));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(MethodDeclaration declaration) {
        ArrayList result = new ArrayList();
        IMethodBinding methodBinding = declaration.resolveBinding();
        if (methodBinding == null) {
            return new ITypeConstraint[0];
        }
        ITypeConstraint[] constraints = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeDeclaringTypeVariable(methodBinding), this.fConstraintVariableFactory.makeRawBindingVariable(methodBinding.getDeclaringClass()));
        result.addAll(Arrays.asList(constraints));
        if (!methodBinding.isConstructor() && !methodBinding.getReturnType().isPrimitive()) {
            ReturnTypeVariable returnTypeBindingVariable = this.fConstraintVariableFactory.makeReturnTypeVariable(methodBinding);
            TypeVariable returnTypeVariable = this.fConstraintVariableFactory.makeTypeVariable(declaration.getReturnType2());
            ITypeConstraint[] defines = this.fTypeConstraintFactory.createDefinesConstraint(returnTypeBindingVariable, returnTypeVariable);
            result.addAll(Arrays.asList(defines));
        }
        int i = 0;
        int n = declaration.parameters().size();
        while (i < n) {
            SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)declaration.parameters().get(i);
            ParameterTypeVariable parameterTypeVariable = this.fConstraintVariableFactory.makeParameterTypeVariable(methodBinding, i);
            ConstraintVariable parameterNameVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)paramDecl.getName(), this.getContext());
            ITypeConstraint[] constraint = this.fTypeConstraintFactory.createDefinesConstraint(parameterTypeVariable, parameterNameVariable);
            result.addAll(Arrays.asList(constraint));
            ++i;
        }
        if (MethodChecks.isVirtual(methodBinding)) {
            Collection constraintsForOverriding = this.getConstraintsForOverriding(methodBinding);
            result.addAll(constraintsForOverriding);
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(ParenthesizedExpression node) {
        ConstraintVariable v1 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)node, this.getContext());
        ConstraintVariable v2 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(node.getExpression(), this.getContext());
        ITypeConstraint[] equal = this.fTypeConstraintFactory.createEqualsConstraint(v1, v2);
        return equal;
    }

    public ITypeConstraint[] create(MethodInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList<CompositeOrTypeConstraint> result = new ArrayList<CompositeOrTypeConstraint>(arguments.size());
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        if (methodBinding == null) {
            return new ITypeConstraint[0];
        }
        ITypeConstraint[] returnTypeConstraint = this.getReturnTypeConstraint((Expression)invocation, methodBinding);
        result.addAll((Collection)Arrays.asList(returnTypeConstraint));
        result.addAll((Collection)Arrays.asList(this.getArgumentConstraints(arguments, methodBinding)));
        if (invocation.getExpression() != null) {
            if (MethodChecks.isVirtual(methodBinding)) {
                IMethodBinding[] rootDefs = FullConstraintCreator.getRootDefs(methodBinding);
                Assert.isTrue((rootDefs.length > 0 ? 1 : 0) != 0);
                ConstraintVariable expressionVar = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(invocation.getExpression(), this.getContext());
                if (rootDefs.length == 1) {
                    result.addAll((Collection)Arrays.asList(this.fTypeConstraintFactory.createSubtypeConstraint(expressionVar, this.fConstraintVariableFactory.makeDeclaringTypeVariable(rootDefs[0]))));
                } else {
                    ArrayList constraints = new ArrayList();
                    int i = 0;
                    while (i < rootDefs.length) {
                        DeclaringTypeVariable rootDefTypeVar = this.fConstraintVariableFactory.makeDeclaringTypeVariable(rootDefs[i]);
                        ITypeConstraint[] tc = this.fTypeConstraintFactory.createSubtypeConstraint(expressionVar, rootDefTypeVar);
                        constraints.addAll(Arrays.asList(tc));
                        ++i;
                    }
                    ITypeConstraint[] constraintsArray = constraints.toArray(new ITypeConstraint[constraints.size()]);
                    if (constraintsArray.length > 0) {
                        result.add(this.fTypeConstraintFactory.createCompositeOrTypeConstraint(constraintsArray));
                    }
                }
            } else {
                DeclaringTypeVariable typeVar = this.fConstraintVariableFactory.makeDeclaringTypeVariable(methodBinding);
                ConstraintVariable expressionVar = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(invocation.getExpression(), this.getContext());
                result.addAll((Collection)Arrays.asList(this.fTypeConstraintFactory.createSubtypeConstraint(expressionVar, typeVar)));
            }
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(QualifiedName qualifiedName) {
        IVariableBinding vb;
        SimpleName name = qualifiedName.getName();
        Name qualifier = qualifiedName.getQualifier();
        IBinding nameBinding = name.resolveBinding();
        if (nameBinding instanceof IVariableBinding && (vb = (IVariableBinding)nameBinding).isField()) {
            return this.createConstraintsForAccessToField(vb, (Expression)qualifier, (Expression)qualifiedName);
        }
        return new ITypeConstraint[0];
    }

    public ITypeConstraint[] create(ReturnStatement returnStatement) {
        if (returnStatement.getExpression() == null) {
            return new ITypeConstraint[0];
        }
        ReturnTypeVariable returnTypeVariable = this.fConstraintVariableFactory.makeReturnTypeVariable(returnStatement);
        return this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(returnStatement.getExpression(), this.getContext()), returnTypeVariable);
    }

    public ITypeConstraint[] create(SingleVariableDeclaration svd) {
        ITypeConstraint[] defines = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)svd.getName(), this.getContext()), this.fConstraintVariableFactory.makeTypeVariable(svd.getType()));
        if (svd.getInitializer() == null) {
            return defines;
        }
        ITypeConstraint[] constraints = this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(svd.getInitializer(), this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)svd.getName(), this.getContext()));
        if (defines.length == 0 && constraints.length == 0) {
            return new ITypeConstraint[0];
        }
        if (defines.length == 0) {
            return constraints;
        }
        if (constraints.length == 0) {
            return defines;
        }
        ArrayList all = new ArrayList();
        all.addAll(Arrays.asList(defines));
        all.addAll(Arrays.asList(constraints));
        return (ITypeConstraint[])all.toArray();
    }

    public ITypeConstraint[] create(SuperConstructorInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList result = new ArrayList(arguments.size());
        IMethodBinding methodBinding = invocation.resolveConstructorBinding();
        result.addAll(Arrays.asList(this.getArgumentConstraints(arguments, methodBinding)));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(SuperFieldAccess access) {
        SimpleName name = access.getName();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return new ITypeConstraint[0];
        }
        IVariableBinding vb = (IVariableBinding)binding;
        return this.createConstraintsForAccessToField(vb, null, (Expression)access);
    }

    public ITypeConstraint[] create(SuperMethodInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList result = new ArrayList(arguments.size());
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        ITypeConstraint[] returnTypeConstraint = this.getReturnTypeConstraint((Expression)invocation, methodBinding);
        result.addAll(Arrays.asList(returnTypeConstraint));
        result.addAll(Arrays.asList(this.getArgumentConstraints(arguments, methodBinding)));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(ThisExpression expression) {
        ConstraintVariable thisExpression = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)expression, this.getContext());
        RawBindingVariable declaringType = this.fConstraintVariableFactory.makeRawBindingVariable(expression.resolveTypeBinding());
        return this.fTypeConstraintFactory.createDefinesConstraint(thisExpression, declaringType);
    }

    public ITypeConstraint[] create(VariableDeclarationExpression vde) {
        return this.getConstraintsFromFragmentList(vde.fragments(), vde.getType());
    }

    public ITypeConstraint[] create(VariableDeclarationFragment vdf) {
        if (vdf.getInitializer() == null) {
            return new ITypeConstraint[0];
        }
        return this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(vdf.getInitializer(), this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)vdf.getName(), this.getContext()));
    }

    public ITypeConstraint[] create(VariableDeclarationStatement vds) {
        return this.getConstraintsFromFragmentList(vds.fragments(), vds.getType());
    }

    private Collection getConstraintsForFieldDeclaringTypes(FieldDeclaration fd) {
        ArrayList result = new ArrayList(fd.fragments().size());
        for (VariableDeclarationFragment varDecl : fd.fragments()) {
            IVariableBinding binding = varDecl.resolveBinding();
            Assert.isTrue((boolean)binding.isField());
            result.addAll(Arrays.asList(this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeDeclaringTypeVariable(binding), this.fConstraintVariableFactory.makeRawBindingVariable(binding.getDeclaringClass()))));
        }
        return result;
    }

    private Collection getConstraintsForHiding(FieldDeclaration fd) {
        ArrayList result = new ArrayList();
        Iterator iter = fd.fragments().iterator();
        while (iter.hasNext()) {
            result.addAll(this.getConstraintsForHiding((VariableDeclarationFragment)iter.next()));
        }
        return result;
    }

    private Collection getConstraintsForHiding(VariableDeclarationFragment fragment) {
        ArrayList result = new ArrayList();
        IVariableBinding fieldBinding = fragment.resolveBinding();
        Assert.isTrue((boolean)fieldBinding.isField());
        Set declaringTypes = FullConstraintCreator.getDeclaringSuperTypes(fieldBinding);
        DeclaringTypeVariable hiddingFieldVar = this.fConstraintVariableFactory.makeDeclaringTypeVariable(fieldBinding);
        for (ITypeBinding declaringSuperType : declaringTypes) {
            IVariableBinding hiddenField = FullConstraintCreator.findField(fieldBinding, declaringSuperType);
            Assert.isTrue((boolean)hiddenField.isField());
            DeclaringTypeVariable hiddenFieldVar = this.fConstraintVariableFactory.makeDeclaringTypeVariable(hiddenField);
            result.addAll(Arrays.asList(this.fTypeConstraintFactory.createStrictSubtypeConstraint(hiddingFieldVar, hiddenFieldVar)));
        }
        return result;
    }

    private ITypeConstraint[] getConstraintsFromFragmentList(List fragments, Type type) {
        int size = fragments.size();
        TypeVariable typeVariable = this.fConstraintVariableFactory.makeTypeVariable(type);
        ArrayList result = new ArrayList(size * (size - 1) / 2);
        int i = 0;
        while (i < size) {
            VariableDeclarationFragment fragment1 = (VariableDeclarationFragment)fragments.get(i);
            SimpleName fragment1Name = fragment1.getName();
            result.addAll(Arrays.asList(this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)fragment1Name, this.getContext()), typeVariable)));
            int j = i + 1;
            while (j < size) {
                VariableDeclarationFragment fragment2 = (VariableDeclarationFragment)fragments.get(j);
                result.addAll(Arrays.asList(this.fTypeConstraintFactory.createEqualsConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)fragment1Name, this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)fragment2.getName(), this.getContext()))));
                ++j;
            }
            ++i;
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    private Collection getConstraintsForOverriding(IMethodBinding overriddingMethod) {
        ArrayList result = new ArrayList();
        Set declaringSupertypes = FullConstraintCreator.getDeclaringSuperTypes(overriddingMethod);
        for (ITypeBinding superType : declaringSupertypes) {
            IMethodBinding overriddenMethod = FullConstraintCreator.findMethod(overriddingMethod, superType);
            Assert.isNotNull((Object)overriddenMethod);
            if (Bindings.equals((IBinding)overriddingMethod, (IBinding)overriddenMethod)) continue;
            ITypeConstraint[] returnTypeConstraint = this.fTypeConstraintFactory.createEqualsConstraint(this.fConstraintVariableFactory.makeReturnTypeVariable(overriddenMethod), this.fConstraintVariableFactory.makeReturnTypeVariable(overriddingMethod));
            result.addAll(Arrays.asList(returnTypeConstraint));
            Assert.isTrue((overriddenMethod.getParameterTypes().length == overriddingMethod.getParameterTypes().length ? 1 : 0) != 0);
            int i = 0;
            int n = overriddenMethod.getParameterTypes().length;
            while (i < n) {
                ITypeConstraint[] parameterTypeConstraint = this.fTypeConstraintFactory.createEqualsConstraint(this.fConstraintVariableFactory.makeParameterTypeVariable(overriddenMethod, i), this.fConstraintVariableFactory.makeParameterTypeVariable(overriddingMethod, i));
                result.addAll(Arrays.asList(parameterTypeConstraint));
                ++i;
            }
            ITypeConstraint[] declaringTypeConstraint = this.fTypeConstraintFactory.createStrictSubtypeConstraint(this.fConstraintVariableFactory.makeDeclaringTypeVariable(overriddingMethod), this.fConstraintVariableFactory.makeDeclaringTypeVariable(overriddenMethod));
            result.addAll(Arrays.asList(declaringTypeConstraint));
        }
        return result;
    }

    private ITypeConstraint[] getReturnTypeConstraint(Expression invocation, IMethodBinding methodBinding) {
        if (methodBinding == null || methodBinding.isConstructor() || methodBinding.getReturnType().isPrimitive()) {
            return new ITypeConstraint[0];
        }
        ReturnTypeVariable returnTypeVariable = this.fConstraintVariableFactory.makeReturnTypeVariable(methodBinding);
        ConstraintVariable invocationVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(invocation, this.getContext());
        return this.fTypeConstraintFactory.createDefinesConstraint(invocationVariable, returnTypeVariable);
    }

    private ITypeConstraint[] getArgumentConstraints(List arguments, IMethodBinding methodBinding) {
        ArrayList result = new ArrayList(arguments.size());
        int i = 0;
        int n = arguments.size();
        while (i < n) {
            Expression argument = (Expression)arguments.get(i);
            ConstraintVariable expressionVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(argument, this.getContext());
            ParameterTypeVariable parameterTypeVariable = this.fConstraintVariableFactory.makeParameterTypeVariable(methodBinding, i);
            ITypeConstraint[] argConstraint = this.fTypeConstraintFactory.createSubtypeConstraint(expressionVariable, parameterTypeVariable);
            result.addAll(Arrays.asList(argConstraint));
            ++i;
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    private static Type getTypeParent(ArrayInitializer arrayInitializer) {
        if (arrayInitializer.getParent() instanceof ArrayCreation) {
            return ((ArrayCreation)arrayInitializer.getParent()).getType().getElementType();
        }
        if (arrayInitializer.getParent() instanceof ArrayInitializer) {
            return FullConstraintCreator.getTypeParent((ArrayInitializer)arrayInitializer.getParent());
        }
        if (arrayInitializer.getParent() instanceof VariableDeclaration) {
            VariableDeclaration parent = (VariableDeclaration)arrayInitializer.getParent();
            if (parent.getParent() instanceof VariableDeclarationStatement) {
                Type type = ((VariableDeclarationStatement)parent.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
            if (parent.getParent() instanceof VariableDeclarationExpression) {
                Type type = ((VariableDeclarationExpression)parent.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
            if (parent.getParent() instanceof FieldDeclaration) {
                Type type = ((FieldDeclaration)parent.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private ITypeConstraint[] createOrOrSubtypeConstraint(ConstraintVariable var1, ConstraintVariable var2) {
        ITypeConstraint[] c1 = this.fTypeConstraintFactory.createSubtypeConstraint(var1, var2);
        ITypeConstraint[] c2 = this.fTypeConstraintFactory.createSubtypeConstraint(var2, var1);
        if (c1.length == 0 && c2.length == 0) {
            return new ITypeConstraint[0];
        }
        return new ITypeConstraint[]{this.fTypeConstraintFactory.createCompositeOrTypeConstraint(new ITypeConstraint[]{c1[0], c2[0]})};
    }

    private ITypeConstraint[] createConstraintsForAccessToField(IVariableBinding fieldBinding, Expression qualifier, Expression accessExpression) {
        Assert.isTrue((boolean)fieldBinding.isField());
        ITypeConstraint[] defines = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(accessExpression, this.getContext()), this.fConstraintVariableFactory.makeRawBindingVariable(fieldBinding.getType()));
        if (qualifier == null) {
            return defines;
        }
        ITypeConstraint[] subType = this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(qualifier, this.getContext()), this.fConstraintVariableFactory.makeDeclaringTypeVariable(fieldBinding));
        if (defines.length == 0) {
            return subType;
        }
        if (subType.length == 0) {
            return defines;
        }
        return new ITypeConstraint[]{defines[0], subType[0]};
    }

    private static IVariableBinding findField(IVariableBinding fieldBinding, ITypeBinding type) {
        if (fieldBinding.getDeclaringClass().equals((Object)type)) {
            return fieldBinding;
        }
        return Bindings.findFieldInType(type, fieldBinding.getName());
    }

    private static Set getDeclaringSuperTypes(IVariableBinding fieldBinding) {
        ITypeBinding[] allSuperTypes = Bindings.getAllSuperTypes(fieldBinding.getDeclaringClass());
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        int i = 0;
        while (i < allSuperTypes.length) {
            ITypeBinding type = allSuperTypes[i];
            if (FullConstraintCreator.findField(fieldBinding, type) != null) {
                result.add(type);
            }
            ++i;
        }
        return result;
    }

    protected static IMethodBinding[] getRootDefs(IMethodBinding methodBinding) {
        Set declaringSuperTypes = FullConstraintCreator.getDeclaringSuperTypes(methodBinding);
        LinkedHashSet<IMethodBinding> result = new LinkedHashSet<IMethodBinding>();
        for (ITypeBinding type : declaringSuperTypes) {
            if (FullConstraintCreator.containsASuperType(type, declaringSuperTypes)) continue;
            result.add(FullConstraintCreator.findMethod(methodBinding, type));
        }
        if (result.size() == 0) {
            result.add(methodBinding);
        }
        return result.toArray(new IMethodBinding[result.size()]);
    }

    private static boolean containsASuperType(ITypeBinding type, Set declaringSuperTypes) {
        for (ITypeBinding maybeSuperType : declaringSuperTypes) {
            if (Bindings.equals((IBinding)maybeSuperType, (IBinding)type) || !Bindings.isSuperType(maybeSuperType, type)) continue;
            return true;
        }
        return false;
    }

    protected static Set getDeclaringSuperTypes(IMethodBinding methodBinding) {
        ITypeBinding superClass = methodBinding.getDeclaringClass();
        LinkedHashSet<ITypeBinding> allSuperTypes = new LinkedHashSet<ITypeBinding>();
        allSuperTypes.addAll((Collection)Arrays.asList(Bindings.getAllSuperTypes(superClass)));
        if (allSuperTypes.isEmpty()) {
            allSuperTypes.add(methodBinding.getDeclaringClass());
        }
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        for (ITypeBinding type : allSuperTypes) {
            if (FullConstraintCreator.findMethod(methodBinding, type) == null) continue;
            result.add(type);
        }
        return result;
    }

    protected static IMethodBinding findMethod(IMethodBinding methodBinding, ITypeBinding type) {
        if (methodBinding.getDeclaringClass().equals((Object)type)) {
            return methodBinding;
        }
        return Bindings.findOverriddenMethodInType(type, methodBinding);
    }

    private static boolean isClassBinding(ITypeBinding typeBinding) {
        return typeBinding != null && typeBinding.isClass();
    }
}

