/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractConstantRefactoring
extends ScriptableRefactoring {
    private static final String ID_EXTRACT_CONSTANT = "org.eclipse.jdt.ui.extract.constant";
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_QUALIFY = "qualify";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String MODIFIER = "static final";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private CompilationUnitRewrite fCuRewrite;
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private IExpressionFragment fSelectedExpression;
    private Type fConstantTypeCache;
    private boolean fReplaceAllOccurrences = true;
    private boolean fQualifyReferencesWithDeclaringClassName = false;
    private String fVisibility = "private";
    private boolean fTargetIsInterface = false;
    private String fConstantName = "";
    private String[] fExcludedVariableNames;
    private boolean fSelectionAllStaticFinal;
    private boolean fAllStaticFinalCheckPerformed = false;
    private List fBodyDeclarations;
    private BodyDeclaration fToInsertAfter;
    private boolean fInsertFirst;
    private CompilationUnitChange fChange;

    public ExtractConstantRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractConstantRefactoring_name;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setVisibility(String am) {
        Assert.isTrue((am == "private" || am == "protected" || am == "" || am == "public" ? 1 : 0) != 0);
        this.fVisibility = am;
    }

    public String getVisibility() {
        return this.fVisibility;
    }

    public boolean getTargetIsInterface() {
        return this.fTargetIsInterface;
    }

    public boolean qualifyReferencesWithDeclaringClassName() {
        return this.fQualifyReferencesWithDeclaringClassName;
    }

    public void setQualifyReferencesWithDeclaringClassName(boolean qualify) {
        this.fQualifyReferencesWithDeclaringClassName = qualify;
    }

    public String guessConstantName() throws JavaModelException {
        String[] proposals = this.guessConstantNames();
        if (proposals.length > 0) {
            return proposals[0];
        }
        return "";
    }

    public String[] guessConstantNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        try {
            Expression expression;
            String[] excludedVariableNames = this.getExcludedVariableNames();
            ASTNode associatedNode = this.getSelectedExpression().getAssociatedNode();
            if (associatedNode instanceof StringLiteral) {
                String[] stringArray;
                String literal = ((StringLiteral)associatedNode).getLiteralValue();
                String guess = ExtractConstantRefactoring.guessConstantNameFromString(literal, excludedVariableNames);
                if (guess.length() == 0) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = guess;
                }
                return stringArray;
            }
            if (associatedNode instanceof NumberLiteral) {
                String[] stringArray;
                String literal = ((NumberLiteral)associatedNode).getToken();
                String guess = ExtractConstantRefactoring.guessConstantNameFromString(literal, excludedVariableNames);
                if (guess.length() == 0) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = guess;
                }
                return stringArray;
            }
            if (associatedNode instanceof MethodInvocation) {
                proposals.addAll(this.guessConstNamesFromMethodInvocation((MethodInvocation)associatedNode, excludedVariableNames));
            } else if (associatedNode instanceof CastExpression && (expression = ((CastExpression)associatedNode).getExpression()) instanceof MethodInvocation) {
                proposals.addAll(this.guessConstNamesFromMethodInvocation((MethodInvocation)expression, excludedVariableNames));
            }
            if (associatedNode instanceof Expression) {
                proposals.addAll(this.guessConstNamesFromExpression((Expression)associatedNode, excludedVariableNames));
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new String[0];
        }
        return proposals.toArray(new String[proposals.size()]);
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCuRewrite.getRoot()).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 2);
                this.fExcludedVariableNames = new String[bindings.length];
                int i = 0;
                while (i < bindings.length) {
                    this.fExcludedVariableNames[i] = bindings[i].getName();
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private static String guessConstantNameFromString(String string, String[] excludedNames) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        char ch = '_';
        while (i < string.length()) {
            ch = string.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                result.append(Character.toUpperCase(ch));
                ++i;
                break;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                result.append('_').append(Character.toUpperCase(ch));
                ++i;
                break;
            }
            ++i;
        }
        boolean wasLastCharLowerCase = Character.isLowerCase(ch);
        boolean wasJavaIdentifierPart = Character.isJavaIdentifierPart(ch);
        while (i < string.length()) {
            ch = string.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                if (wasLastCharLowerCase && Character.isUpperCase(ch)) {
                    result.append('_').append(Character.toUpperCase(ch));
                } else {
                    result.append(Character.toUpperCase(ch));
                }
                wasLastCharLowerCase = Character.isLowerCase(ch);
                wasJavaIdentifierPart = true;
            } else {
                if (wasLastCharLowerCase || wasJavaIdentifierPart) {
                    result.append('_');
                }
                wasLastCharLowerCase = false;
                wasJavaIdentifierPart = false;
            }
            ++i;
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == '_') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private List guessConstNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        int i = 0;
        while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
            String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
            if (methodName.startsWith(prefix)) {
                if (methodName.length() == prefix.length()) {
                    return Collections.EMPTY_LIST;
                }
                char firstAfterPrefix = methodName.charAt(prefix.length());
                if (Character.isUpperCase(firstAfterPrefix)) {
                    String proposal;
                    methodName = proposal = String.valueOf(Character.toLowerCase(firstAfterPrefix)) + methodName.substring(prefix.length() + 1);
                    break;
                }
            }
            ++i;
        }
        return this.getConstantNameSuggestions(methodName, 0, excludedVariableNames);
    }

    private List guessConstNamesFromExpression(Expression selectedExpression, String[] excludedVariableNames) {
        ITypeBinding expressionBinding = selectedExpression.resolveTypeBinding();
        ITypeBinding normalizedBinding = Bindings.normalizeTypeBinding(expressionBinding).getTypeDeclaration();
        if (normalizedBinding.isArray()) {
            normalizedBinding = normalizedBinding.getElementType();
        }
        if (normalizedBinding.isPrimitive()) {
            return Collections.EMPTY_LIST;
        }
        String typeName = normalizedBinding.getName();
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        int typeParamStart = typeName.indexOf("<");
        if (typeParamStart != -1) {
            typeName = typeName.substring(0, typeParamStart);
        }
        return this.getConstantNameSuggestions(typeName, expressionBinding.getDimensions(), excludedVariableNames);
    }

    private List getConstantNameSuggestions(String baseName, int dimensions, String[] excludedVariableNames) {
        int staticFinal = 24;
        String[] proposals = StubUtility.getFieldNameSuggestions(this.fCu.getJavaProject(), baseName, dimensions, staticFinal, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            ITypeBinding targetType;
            pm.beginTask("", 7);
            RefactoringStatus result = Checks.validateEdit(this.fCu, this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            CompilationUnit cuNode = RefactoringASTParser.parseWithASTProvider(this.fCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            this.fCuRewrite = new CompilationUnitRewrite(this.fCu, cuNode);
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            if ((targetType = this.getContainingTypeBinding()).isAnnotation() || targetType.isInterface()) {
                this.fTargetIsInterface = true;
                this.fVisibility = "public";
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean selectionAllStaticFinal() {
        Assert.isTrue((boolean)this.fAllStaticFinalCheckPerformed);
        return this.fSelectionAllStaticFinal;
    }

    private void checkAllStaticFinal() throws JavaModelException {
        this.fSelectionAllStaticFinal = ConstantChecks.isStaticFinalConstant(this.getSelectedExpression());
        this.fAllStaticFinalCheckPerformed = true;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask("", 2);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractConstantRefactoring_select_expression;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCuRewrite.getRoot(), message);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkExpressionBinding() throws JavaModelException {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractConstantRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractConstantRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkExpressionBinding());
        if (result.hasFatalError()) {
            return result;
        }
        this.checkAllStaticFinal();
        IExpressionFragment selectedExpression = this.getSelectedExpression();
        Expression associatedExpression = selectedExpression.getAssociatedExpression();
        if (associatedExpression instanceof NullLiteral) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_null_literals));
        } else if (!ConstantChecks.isLoadTimeConstant(selectedExpression)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_not_load_time_constant));
        } else if (associatedExpression instanceof SimpleName && (associatedExpression.getParent() instanceof QualifiedName && associatedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || associatedExpression.getParent() instanceof FieldAccess && associatedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_select_expression);
        }
        return result;
    }

    public void setConstantName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fConstantName = newName;
    }

    public String getConstantName() {
        return this.fConstantName;
    }

    public RefactoringStatus checkConstantNameOnChange() throws JavaModelException {
        if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fConstantName)) {
            return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_another_variable, this.getConstantName()));
        }
        return Checks.checkConstantName(this.getConstantName());
    }

    public String getConstantSignaturePreview() throws JavaModelException {
        String space = " ";
        return String.valueOf(this.getVisibility()) + space + MODIFIER + space + this.getConstantTypeName() + space + this.fConstantName;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ExtractConstantRefactoring_checking_preconditions, 4);
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.createConstantDeclaration();
            this.fChange = this.fCuRewrite.createChange();
            pm.worked(1);
            TextEdit[] replaceEdits = this.createReplaceExpressionWithConstantEdits();
            int i = 0;
            while (i < replaceEdits.length) {
                TextChangeCompatibility.addTextEdit((TextChange)this.fChange, RefactoringCoreMessages.ExtractConstantRefactoring_replace, replaceEdits[i]);
                ++i;
            }
            pm.worked(1);
            String newCuSource = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
            CompilationUnit newCUNode = new RefactoringASTParser(3).parse(newCuSource, this.fCu, true, true, null);
            IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCuRewrite.getRoot());
            int i2 = 0;
            while (i2 < newProblems.length) {
                IProblem problem = newProblems[i2];
                if (problem.isError()) {
                    result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, new SourceRange(problem))));
                }
                ++i2;
            }
            this.fConstantTypeCache = null;
            this.fCuRewrite.clearASTAndImportRewrites();
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void createConstantDeclaration() throws CoreException {
        String comment;
        Type type = this.getConstantType();
        IExpressionFragment fragment = this.getSelectedExpression();
        String initializerSource = this.fCu.getBuffer().getText(fragment.getStartPosition(), fragment.getLength());
        AST ast = this.fCuRewrite.getAST();
        VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(ast.newSimpleName(this.fConstantName));
        variableDeclarationFragment.setInitializer((Expression)this.fCuRewrite.getASTRewrite().createStringPlaceholder(initializerSource, 42));
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType(type);
        Modifier.ModifierKeyword accessModifier = Modifier.ModifierKeyword.toKeyword((String)this.fVisibility);
        if (accessModifier != null) {
            fieldDeclaration.modifiers().add(ast.newModifier(accessModifier));
        }
        fieldDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        fieldDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        boolean createComments = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.fCu.getJavaProject()).createComments;
        if (createComments && (comment = CodeGeneration.getFieldComment(this.fCu, this.getConstantTypeName(), this.fConstantName, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu))) != null && comment.length() > 0) {
            Javadoc doc = (Javadoc)this.fCuRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            fieldDeclaration.setJavadoc(doc);
        }
        AbstractTypeDeclaration parent = this.getContainingTypeDeclarationNode();
        ListRewrite listRewrite = this.fCuRewrite.getASTRewrite().getListRewrite((ASTNode)parent, parent.getBodyDeclarationsProperty());
        TextEditGroup msg = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.ExtractConstantRefactoring_declare_constant);
        if (this.insertFirst()) {
            listRewrite.insertFirst((ASTNode)fieldDeclaration, msg);
        } else {
            listRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)this.getNodeToInsertConstantDeclarationAfter(), msg);
        }
    }

    private Type getConstantType() throws JavaModelException {
        if (this.fConstantTypeCache == null) {
            IExpressionFragment fragment = this.getSelectedExpression();
            ITypeBinding typeBinding = fragment.getAssociatedExpression().resolveTypeBinding();
            AST ast = this.fCuRewrite.getAST();
            typeBinding = Bindings.normalizeForDeclarationUse(typeBinding, ast);
            this.fConstantTypeCache = this.fCuRewrite.getImportRewrite().addImport(typeBinding, ast);
        }
        return this.fConstantTypeCache;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 786432;
        if (JdtFlags.getVisibilityCode(this.fVisibility) != 2) {
            flags |= 2;
        }
        String pattern = "";
        try {
            pattern = String.valueOf(BindingLabelProvider.getBindingLabel((IBinding)this.getContainingTypeBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED)) + ".";
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        String expression = ASTNodes.asString((ASTNode)this.fSelectedExpression.getAssociatedExpression());
        String description = Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description_short, this.fConstantName);
        String header = Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description, new String[]{String.valueOf(pattern) + this.fConstantName, expression});
        JavaRefactoringDescriptorComment comment = new JavaRefactoringDescriptorComment(this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_constant_name_pattern, this.fConstantName));
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_constant_expression_pattern, expression));
        String visibility = this.fVisibility;
        if ("".equals(visibility)) {
            visibility = RefactoringCoreMessages.ExtractConstantRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractConstantRefactoring_visibility_pattern, visibility));
        if (this.fReplaceAllOccurrences) {
            comment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_replace_occurrences);
        }
        if (this.fQualifyReferencesWithDeclaringClassName) {
            comment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_qualify_references);
        }
        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_EXTRACT_CONSTANT, project, description, comment.asString(), arguments, flags);
        arguments.put("input", descriptor.elementToHandle((IJavaElement)this.fCu));
        arguments.put("name", this.fConstantName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllOccurrences).toString());
        arguments.put(ATTRIBUTE_QUALIFY, Boolean.valueOf(this.fQualifyReferencesWithDeclaringClassName).toString());
        arguments.put(ATTRIBUTE_VISIBILITY, new Integer(JdtFlags.getVisibilityCode(this.fVisibility)).toString());
        return new RefactoringDescriptorChange(descriptor, RefactoringCoreMessages.ExtractConstantRefactoring_name, new Change[]{this.fChange});
    }

    private TextEdit[] createReplaceExpressionWithConstantEdits() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = this.getFragmentsToReplace();
        TextEdit[] result = new TextEdit[fragmentsToReplace.length];
        int i = 0;
        while (i < fragmentsToReplace.length) {
            result[i] = this.createReplaceEdit(fragmentsToReplace[i]);
            ++i;
        }
        return result;
    }

    private ReplaceEdit createReplaceEdit(IASTFragment fragment) throws JavaModelException {
        int offset = fragment.getStartPosition();
        int length = fragment.getLength();
        String constantReference = this.getNewConstantReference();
        ReplaceEdit replaceEdit = new ReplaceEdit(offset, length, constantReference);
        return replaceEdit;
    }

    private String getNewConstantReference() throws JavaModelException {
        if (this.qualifyReferencesWithDeclaringClassName()) {
            return String.valueOf(this.getContainingTypeBinding().getName()) + "." + this.fConstantName;
        }
        return this.fConstantName;
    }

    private void computeConstantDeclarationLocation() throws JavaModelException {
        if (this.isDeclarationLocationComputed()) {
            return;
        }
        BodyDeclaration lastStaticDependency = null;
        Iterator decls = this.getBodyDeclarations();
        Assert.isTrue((boolean)decls.hasNext());
        while (decls.hasNext()) {
            int modifiers;
            BodyDeclaration decl = (BodyDeclaration)decls.next();
            if (decl instanceof FieldDeclaration) {
                modifiers = ((FieldDeclaration)decl).getModifiers();
            } else {
                if (!(decl instanceof Initializer)) continue;
                modifiers = ((Initializer)decl).getModifiers();
            }
            if (!Modifier.isStatic((int)modifiers) || !ExtractConstantRefactoring.depends(this.getSelectedExpression(), decl)) continue;
            lastStaticDependency = decl;
        }
        if (lastStaticDependency == null) {
            this.fInsertFirst = true;
        } else {
            this.fToInsertAfter = lastStaticDependency;
        }
    }

    private static boolean depends(IExpressionFragment selected, BodyDeclaration bd) {
        if (bd instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)bd;
            for (VariableDeclarationFragment fragment : fieldDecl.fragments()) {
                SimpleName staticFieldName = fragment.getName();
                if (selected.getSubFragmentsMatching(ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)staticFieldName)).length == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeclarationLocationComputed() {
        return this.fInsertFirst || this.fToInsertAfter != null;
    }

    private boolean insertFirst() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fInsertFirst;
    }

    private BodyDeclaration getNodeToInsertConstantDeclarationAfter() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fToInsertAfter;
    }

    private Iterator getBodyDeclarations() throws JavaModelException {
        if (this.fBodyDeclarations == null) {
            this.fBodyDeclarations = this.getContainingTypeDeclarationNode().bodyDeclarations();
        }
        return this.fBodyDeclarations.iterator();
    }

    private String getConstantTypeName() throws JavaModelException {
        return ASTNodes.asString((ASTNode)this.getConstantType());
    }

    private static boolean isStaticFieldOrStaticInitializer(BodyDeclaration node) {
        int modifiers;
        if (node instanceof MethodDeclaration || node instanceof AbstractTypeDeclaration) {
            return false;
        }
        if (node instanceof FieldDeclaration) {
            modifiers = ((FieldDeclaration)node).getModifiers();
        } else if (node instanceof Initializer) {
            modifiers = ((Initializer)node).getModifiers();
        } else {
            Assert.isTrue((boolean)false);
            return false;
        }
        return Modifier.isStatic((int)modifiers);
    }

    private Iterator getReplacementScope() throws JavaModelException {
        boolean declPredecessorReached = false;
        ArrayList<BodyDeclaration> scope = new ArrayList<BodyDeclaration>();
        Iterator bodyDeclarations = this.getBodyDeclarations();
        while (bodyDeclarations.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.next();
            if (bodyDeclaration == this.getNodeToInsertConstantDeclarationAfter()) {
                declPredecessorReached = true;
            }
            if (!this.insertFirst() && !declPredecessorReached && ExtractConstantRefactoring.isStaticFieldOrStaticInitializer(bodyDeclaration)) continue;
            scope.add(bodyDeclaration);
        }
        return scope.iterator();
    }

    private IASTFragment[] getFragmentsToReplace() throws JavaModelException {
        ArrayList<IASTFragment> toReplace = new ArrayList<IASTFragment>();
        if (this.fReplaceAllOccurrences) {
            Iterator replacementScope = this.getReplacementScope();
            while (replacementScope.hasNext()) {
                BodyDeclaration bodyDecl = (BodyDeclaration)replacementScope.next();
                IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)bodyDecl).getSubFragmentsMatching(this.getSelectedExpression());
                IASTFragment[] replaceableMatches = ExtractConstantRefactoring.retainOnlyReplacableMatches(allMatches);
                int i = 0;
                while (i < replaceableMatches.length) {
                    toReplace.add(replaceableMatches[i]);
                    ++i;
                }
            }
        } else if (ExtractConstantRefactoring.canReplace(this.getSelectedExpression())) {
            toReplace.add(this.getSelectedExpression());
        }
        return toReplace.toArray(new IASTFragment[toReplace.size()]);
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (ExtractConstantRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCuRewrite.getRoot(), this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private AbstractTypeDeclaration getContainingTypeDeclarationNode() throws JavaModelException {
        AbstractTypeDeclaration result = (AbstractTypeDeclaration)ASTNodes.getParent(this.getSelectedExpression().getAssociatedNode(), AbstractTypeDeclaration.class);
        Assert.isNotNull((Object)result);
        return result;
    }

    private ITypeBinding getContainingTypeBinding() throws JavaModelException {
        ITypeBinding result = this.getContainingTypeDeclarationNode().resolveBinding();
        Assert.isNotNull((Object)result);
        return result;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String declareFinal;
        if (arguments instanceof JavaRefactoringArguments) {
            String name;
            IJavaElement element;
            int length;
            int offset;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, ID_EXTRACT_CONSTANT);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)element;
            String visibility = extended.getAttribute(ATTRIBUTE_VISIBILITY);
            if (visibility != null && !"".equals(visibility)) {
                int flag = 0;
                try {
                    flag = Integer.parseInt(visibility);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = JdtFlags.getVisibilityString(flag);
            }
            if ((name = extended.getAttribute("name")) == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fConstantName = name;
            String replace = extended.getAttribute(ATTRIBUTE_REPLACE);
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceAllOccurrences = Boolean.valueOf(replace);
            declareFinal = extended.getAttribute(ATTRIBUTE_QUALIFY);
            if (declareFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFY));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fQualifyReferencesWithDeclaringClassName = Boolean.valueOf(declareFinal);
        return new RefactoringStatus();
    }
}

