/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search2.internal.ui.SearchMessages;

public class SearchPageRegistry {
    public static final String ID_EXTENSION_POINT = "org.eclipse.search.searchResultViewPages";
    public static final String ATTRIB_SEARCH_RESULT_CLASS = "searchResultClass";
    public static final String ATTRIB_ID = "id";
    public static final String ATTRIB_LABEL = "label";
    public static final String ATTRIB_ICON = "icon";
    private final Map fResultClassNameToExtension;
    private final Map fExtensionToInstance = new HashMap();
    private final IConfigurationElement[] fExtensions;

    public SearchPageRegistry() {
        this.fResultClassNameToExtension = new HashMap();
        this.fExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(ID_EXTENSION_POINT);
        int i = 0;
        while (i < this.fExtensions.length) {
            this.fResultClassNameToExtension.put(this.fExtensions[i].getAttribute(ATTRIB_SEARCH_RESULT_CLASS), this.fExtensions[i]);
            ++i;
        }
    }

    public ISearchResultPage findPageForSearchResult(ISearchResult result, boolean create) {
        Class<?> resultClass = result.getClass();
        IConfigurationElement configElement = this.findConfigurationElement(resultClass);
        if (configElement != null) {
            return this.getSearchResultPage(configElement, create);
        }
        return null;
    }

    public ISearchResultPage findPageForPageId(String pageId, boolean create) {
        IConfigurationElement configElement = this.findConfigurationElement(pageId);
        if (configElement != null) {
            return this.getSearchResultPage(configElement, create);
        }
        return null;
    }

    public String findLabelForPageId(String pageId) {
        IConfigurationElement configElement = this.findConfigurationElement(pageId);
        if (configElement != null) {
            return configElement.getAttribute(ATTRIB_LABEL);
        }
        return null;
    }

    private ISearchResultPage getSearchResultPage(final IConfigurationElement configElement, boolean create) {
        ISearchResultPage instance = (ISearchResultPage)this.fExtensionToInstance.get(configElement);
        if (instance == null && create) {
            final Object[] result = new Object[1];
            SafeRunnable safeRunnable = new SafeRunnable(SearchMessages.SearchPageRegistry_error_creating_extensionpoint){

                public void run() throws Exception {
                    result[0] = configElement.createExecutableExtension("class");
                }

                public void handleException(Throwable e) {
                    SearchPlugin.log(e);
                }
            };
            SafeRunner.run((ISafeRunnable)safeRunnable);
            if (result[0] instanceof ISearchResultPage) {
                instance = (ISearchResultPage)result[0];
                instance.setID(configElement.getAttribute(ATTRIB_ID));
                this.fExtensionToInstance.put(configElement, instance);
            }
        }
        return instance;
    }

    private IConfigurationElement findConfigurationElement(String pageId) {
        int i = 0;
        while (i < this.fExtensions.length) {
            IConfigurationElement curr = this.fExtensions[i];
            if (pageId.equals(curr.getAttribute(ATTRIB_ID))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private IConfigurationElement findConfigurationElement(Class resultClass) {
        IConfigurationElement foundExtension;
        String className = resultClass.getName();
        IConfigurationElement configElement = (IConfigurationElement)this.fResultClassNameToExtension.get(className);
        if (configElement != null) {
            return configElement;
        }
        Class superclass = resultClass.getSuperclass();
        if (superclass != null && (foundExtension = this.findConfigurationElement(superclass)) != null) {
            this.fResultClassNameToExtension.put(className, configElement);
            return foundExtension;
        }
        Class<?>[] interfaces = resultClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            IConfigurationElement foundExtension2 = this.findConfigurationElement(interfaces[i]);
            if (foundExtension2 != null) {
                this.fResultClassNameToExtension.put(className, configElement);
                return foundExtension2;
            }
            ++i;
        }
        return null;
    }
}

