/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.ui.refactoring.model.ModelMessages;
import org.eclipse.ltk.internal.ui.refactoring.util.HTMLPrinter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RefactoringDescriptorViewer
extends Viewer {
    protected final Browser fBrowser;
    private RefactoringDescriptorProxy fDescriptor = null;

    public RefactoringDescriptorViewer(Composite parent, int style) {
        Assert.isNotNull((Object)parent);
        this.fBrowser = new Browser(parent, style);
        Display display = parent.getDisplay();
        this.fBrowser.setForeground(display.getSystemColor(24));
        this.fBrowser.setBackground(display.getSystemColor(25));
    }

    public Control getControl() {
        return this.fBrowser;
    }

    public Object getInput() {
        return this.fDescriptor;
    }

    protected String getInputText(RefactoringDescriptorProxy proxy) {
        StringBuffer buffer = new StringBuffer();
        Font font = JFaceResources.getDialogFont();
        FontData[] data = font.getFontData();
        String face = data[0].getName();
        int index = face.indexOf(45);
        if (index >= 0 && index < face.length() - 1) {
            face = face.substring(index + 1);
        }
        int size = data[0].getHeight();
        HTMLPrinter.insertPageProlog(buffer, face, size, 0, this.fBrowser.getBackground().getRGB());
        if (proxy != null) {
            HTMLPrinter.addSmallHeader(buffer, face, size, HTMLPrinter.convertToHTMLContent(proxy.getDescription()));
            RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)new NullProgressMonitor());
            if (descriptor != null) {
                String comment = descriptor.getComment();
                if (comment != null && !"".equals(comment)) {
                    HTMLPrinter.addParagraph(buffer, face, size, HTMLPrinter.convertToHTMLContent(comment));
                }
                HTMLPrinter.startBulletList(buffer);
                int flags = descriptor.getFlags();
                if ((flags & 1) > 0) {
                    HTMLPrinter.addBullet(buffer, face, size, ModelMessages.RefactoringDescriptorViewer_breaking_change_message);
                }
                if ((flags & 2) > 0) {
                    HTMLPrinter.addBullet(buffer, face, size, ModelMessages.RefactoringDescriptorViewer_structural_change_message);
                }
                if ((flags & 4) > 0) {
                    HTMLPrinter.addBullet(buffer, face, size, ModelMessages.RefactoringDescriptorViewer_closure_change_message);
                }
                HTMLPrinter.endBulletList(buffer);
            }
        }
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public ISelection getSelection() {
        return new TextSelection(0, 0);
    }

    public void refresh() {
        String text = this.getInputText(this.fDescriptor);
        if (text != null && text.length() > 0 && (this.fBrowser.getShell().getStyle() & 0x4000000) != 0) {
            StringBuffer buffer = new StringBuffer(text);
            HTMLPrinter.insertStyles(buffer, new String[]{"direction:rtl", "overflow:hidden"});
            text = buffer.toString();
        }
        this.fBrowser.setText(text);
    }

    public void setInput(Object input) {
        if (input instanceof RefactoringDescriptorProxy) {
            this.fDescriptor = (RefactoringDescriptorProxy)input;
            this.refresh();
        } else {
            this.fDescriptor = null;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }
}

