/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaElementPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_APPLET = "isApplet";
    private static final String PROPERTY_HAS_MAIN_TYPE = "hasMainType";
    private final String APPLET_TYPE = "java.applet.Applet";

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IJavaElement javaElement = null;
        if (receiver instanceof IAdaptable) {
            javaElement = (IJavaElement)((IAdaptable)receiver).getAdapter(IJavaElement.class);
        }
        if (javaElement != null && !javaElement.exists()) {
            return false;
        }
        if (javaElement instanceof IJavaProject || javaElement instanceof IPackageFragmentRoot || javaElement instanceof IPackageFragment) {
            return true;
        }
        if (javaElement != null) {
            if (PROPERTY_IS_APPLET.equals(method)) {
                return this.isApplet(javaElement);
            }
            if (PROPERTY_HAS_MAIN_TYPE.equals(method)) {
                return this.hasMain(javaElement);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isApplet(IJavaElement element) {
        try {
            IType type = this.getType(element);
            if (type == null) return false;
            IType[] stypes = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).getAllSuperclasses(type);
            int i = 0;
            while (true) {
                if (i >= stypes.length) {
                    return false;
                }
                if (stypes[i].getFullyQualifiedName().equals("java.applet.Applet")) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMain(IJavaElement element) {
        try {
            IType mainType = this.getType(element);
            if (mainType == null) return false;
            if (!mainType.exists()) return false;
            IMethod[] methods = mainType.getMethods();
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    return false;
                }
                if (methods[i].isMainMethod()) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private IType getType(IJavaElement element) throws JavaModelException {
        IType type = null;
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            type = cu.getType(Signature.getQualifier((String)cu.getElementName()));
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        } else if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        return type;
    }
}

