/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.BreakpointTypeCategory;
import org.eclipse.debug.ui.IBreakpointTypeCategory;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodEntryBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jface.resource.ImageDescriptor;

public class JavaBreakpointTypeAdapterFactory
implements IAdapterFactory {
    private Map fStratumTypes = new HashMap();
    private Map fOtherTypes = new HashMap();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType.equals(IBreakpointTypeCategory.class)) {
            if (adaptableObject instanceof IJavaStratumLineBreakpoint) {
                IJavaStratumLineBreakpoint stratumBreakpoint = (IJavaStratumLineBreakpoint)adaptableObject;
                try {
                    String suffix;
                    int index;
                    String sourceName;
                    String stratum = stratumBreakpoint.getStratum();
                    if (stratum == null && (sourceName = stratumBreakpoint.getSourceName()) != null && (index = sourceName.lastIndexOf(46)) >= 0 && index < sourceName.length() - 1 && !(suffix = sourceName.substring(index + 1)).equalsIgnoreCase("java")) {
                        stratum = suffix.toUpperCase();
                    }
                    if (stratum != null) {
                        Object type = this.fStratumTypes.get(stratum);
                        if (type == null) {
                            String label = MessageFormat.format((String)BreakpointMessages.JavaBreakpointTypeAdapterFactory_0, (Object[])new String[]{stratum});
                            type = stratum.equalsIgnoreCase("jsp") ? new BreakpointTypeCategory(label, this.getImageDescriptor("IMG_OBJS_JSP_BRKPT_TYPE")) : new BreakpointTypeCategory(label);
                            this.fStratumTypes.put(stratum, type);
                        }
                        return type;
                    }
                }
                catch (CoreException coreException) {}
            }
            if (adaptableObject instanceof IBreakpoint) {
                IBreakpoint breakpoint = (IBreakpoint)adaptableObject;
                String type = DebugPlugin.getDefault().getBreakpointManager().getTypeName(breakpoint);
                IBreakpointTypeCategory category = (IBreakpointTypeCategory)this.fOtherTypes.get(type);
                if (category == null) {
                    if (breakpoint instanceof IJavaExceptionBreakpoint) {
                        category = new BreakpointTypeCategory(type, this.getImageDescriptor("IMG_OBJS_EXCEPTION_BRKPT_TYPE"));
                    } else if (breakpoint instanceof IJavaClassPrepareBreakpoint) {
                        category = new BreakpointTypeCategory(type, this.getImageDescriptor("IMG_OBJS_CLASSLOAD_BRKPT_TYPE"));
                    } else if (breakpoint instanceof IJavaMethodBreakpoint || breakpoint instanceof IJavaMethodEntryBreakpoint) {
                        category = new BreakpointTypeCategory(type, this.getImageDescriptor("IMG_OBJS_METHOD_BRKPT_TYPE"));
                    } else if (breakpoint instanceof IJavaWatchpoint) {
                        category = new BreakpointTypeCategory(type, this.getImageDescriptor("IMG_OBJS_WATCHPOINT_TYPE"));
                    } else if (breakpoint instanceof IJavaLineBreakpoint) {
                        category = new BreakpointTypeCategory(type, this.getImageDescriptor("IMG_OBJS_LINE_BRKPT_TYPE"));
                    }
                    if (category != null) {
                        this.fOtherTypes.put(type, category);
                    }
                }
                return category;
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IBreakpointTypeCategory.class};
    }

    private ImageDescriptor getImageDescriptor(String key) {
        return JavaDebugImages.getImageDescriptor(key);
    }
}

