/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.Hashtable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetCompletionProcessor;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class JDIContentAssistPreference {
    private static final String VISIBILITY = "org.eclipse.jdt.core.codeComplete.visibilityCheck";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    private static Color getColor(IPreferenceStore store, String key) {
        JavaTextTools textTools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        return JDIContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    private static JavaDebugContentAssistProcessor getDisplayProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof JavaDebugContentAssistProcessor) {
            return (JavaDebugContentAssistProcessor)p;
        }
        return null;
    }

    private static JavaSnippetCompletionProcessor getJavaSnippetProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof JavaSnippetCompletionProcessor) {
            return (JavaSnippetCompletionProcessor)p;
        }
        return null;
    }

    private static void configureDisplayProcessor(ContentAssistant assistant, IPreferenceStore store) {
        JavaDebugContentAssistProcessor dcp = JDIContentAssistPreference.getDisplayProcessor(assistant);
        if (dcp == null) {
            return;
        }
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            dcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean("content_assist_show_visible_proposals");
        JDIContentAssistPreference.restrictProposalsToVisibility(enabled);
        enabled = store.getBoolean("content_assist_case_sensitivity");
        JDIContentAssistPreference.restrictProposalsToMatchingCases(enabled);
        enabled = store.getBoolean("content_assist_order_proposals");
        dcp.orderProposalsAlphabetically(enabled);
    }

    private static void configureJavaSnippetProcessor(ContentAssistant assistant, IPreferenceStore store) {
        JavaSnippetCompletionProcessor cp = JDIContentAssistPreference.getJavaSnippetProcessor(assistant);
        if (cp == null) {
            return;
        }
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean("content_assist_show_visible_proposals");
        JDIContentAssistPreference.restrictProposalsToVisibility(enabled);
        enabled = store.getBoolean("content_assist_case_sensitivity");
        JDIContentAssistPreference.restrictProposalsToMatchingCases(enabled);
        enabled = store.getBoolean("content_assist_order_proposals");
        cp.orderProposalsAlphabetically(enabled);
    }

    public static void configure(ContentAssistant assistant, IColorManager manager) {
        IPreferenceStore store = JDIContentAssistPreference.getPreferenceStore();
        boolean enabled = store.getBoolean("content_assist_autoactivation");
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt("content_assist_autoactivation_delay");
        assistant.setAutoActivationDelay(delay);
        Color c = JDIContentAssistPreference.getColor(store, "content_assist_proposals_foreground", manager);
        assistant.setProposalSelectorForeground(c);
        c = JDIContentAssistPreference.getColor(store, "content_assist_proposals_background", manager);
        assistant.setProposalSelectorBackground(c);
        c = JDIContentAssistPreference.getColor(store, "content_assist_parameters_foreground", manager);
        assistant.setContextInformationPopupForeground(c);
        assistant.setContextSelectorForeground(c);
        c = JDIContentAssistPreference.getColor(store, "content_assist_parameters_background", manager);
        assistant.setContextInformationPopupBackground(c);
        assistant.setContextSelectorBackground(c);
        enabled = store.getBoolean("content_assist_autoinsert");
        assistant.enableAutoInsert(enabled);
        JDIContentAssistPreference.configureDisplayProcessor(assistant, store);
        JDIContentAssistPreference.configureJavaSnippetProcessor(assistant, store);
    }

    private static void changeDisplayProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        JavaDebugContentAssistProcessor dcp = JDIContentAssistPreference.getDisplayProcessor(assistant);
        if (dcp == null) {
            return;
        }
        if ("content_assist_autoactivation_triggers_java".equals(key)) {
            String triggers = store.getString("content_assist_autoactivation_triggers_java");
            if (triggers != null) {
                dcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if ("content_assist_order_proposals".equals(key)) {
            boolean enable = store.getBoolean("content_assist_order_proposals");
            dcp.orderProposalsAlphabetically(enable);
        }
    }

    private static void changeJavaSnippetProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        JavaSnippetCompletionProcessor cp = JDIContentAssistPreference.getJavaSnippetProcessor(assistant);
        if (cp == null) {
            return;
        }
        if ("content_assist_autoactivation_triggers_java".equals(key)) {
            String triggers = store.getString("content_assist_autoactivation_triggers_java");
            if (triggers != null) {
                cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if ("content_assist_order_proposals".equals(key)) {
            boolean enable = store.getBoolean("content_assist_order_proposals");
            cp.orderProposalsAlphabetically(enable);
        }
    }

    public static void changeConfiguration(ContentAssistant assistant, PropertyChangeEvent event) {
        IPreferenceStore store = JDIContentAssistPreference.getPreferenceStore();
        String p = event.getProperty();
        if ("content_assist_autoactivation".equals(p)) {
            boolean enabled = store.getBoolean("content_assist_autoactivation");
            assistant.enableAutoActivation(enabled);
        } else if ("content_assist_autoactivation_delay".equals(p)) {
            int delay = store.getInt("content_assist_autoactivation_delay");
            assistant.setAutoActivationDelay(delay);
        } else if ("content_assist_proposals_foreground".equals(p)) {
            Color c = JDIContentAssistPreference.getColor(store, "content_assist_proposals_foreground");
            assistant.setProposalSelectorForeground(c);
        } else if ("content_assist_proposals_background".equals(p)) {
            Color c = JDIContentAssistPreference.getColor(store, "content_assist_proposals_background");
            assistant.setProposalSelectorBackground(c);
        } else if ("content_assist_parameters_foreground".equals(p)) {
            Color c = JDIContentAssistPreference.getColor(store, "content_assist_parameters_foreground");
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if ("content_assist_parameters_background".equals(p)) {
            Color c = JDIContentAssistPreference.getColor(store, "content_assist_parameters_background");
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if ("content_assist_autoinsert".equals(p)) {
            boolean enabled = store.getBoolean("content_assist_autoinsert");
            assistant.enableAutoInsert(enabled);
        }
        JDIContentAssistPreference.changeDisplayProcessor(assistant, store, p);
        JDIContentAssistPreference.changeJavaSnippetProcessor(assistant, store, p);
    }

    private static void restrictProposalsToVisibility(boolean restrict) {
        Hashtable options = JavaCore.getOptions();
        Object value = options.get(VISIBILITY);
        if (value instanceof String) {
            String newValue;
            String string = newValue = restrict ? ENABLED : DISABLED;
            if (!newValue.equals(value)) {
                options.put(VISIBILITY, newValue);
                JavaCore.setOptions((Hashtable)options);
            }
        }
    }

    private static void restrictProposalsToMatchingCases(boolean restrict) {
    }

    private static IPreferenceStore getPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }
}

