/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroIdElement;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class IntroTheme
extends AbstractIntroIdElement {
    private static final String ATT_PATH = "path";
    private String name;
    private String path;
    private Hashtable properties;

    public IntroTheme(IConfigurationElement element) {
        super(element);
        this.name = element.getAttribute(this.name);
        this.path = element.getAttribute(ATT_PATH);
        this.path = BundleUtil.getResolvedResourceLocation(this.path, this.getBundle());
        this.loadProperties(element);
    }

    public IntroTheme(Element element, Bundle bundle) {
        super(element, bundle);
    }

    public IntroTheme(Element element, Bundle bundle, String base) {
        super(element, bundle, base);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public int getType() {
        return 262144;
    }

    public Map getProperties() {
        return this.properties;
    }

    private void loadProperties(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren("property");
        if (children.length == 0) {
            return;
        }
        this.properties = new Hashtable();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement property = children[i];
            String name = property.getAttribute("name");
            String value = property.getAttribute("value");
            if (name != null && value != null) {
                this.properties.put(name, value);
            }
            ++i;
        }
    }
}

