/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.help.internal.xhtml.ASCIIReader;

public class XHTMLCharsetParser {
    public static final int MAX_OFFSET = 2048;
    private static final String ELEMENT_META = "META";
    private static final String ELEMENT_BODY = "body";
    private static final String ELEMENT_HEAD = "head";
    private static final String ATTRIBUTE_HTTP = "http-equiv";
    private static final String ATTRIBUTE_HTTP_VALUE = "content-type";
    private static final String ATTRIBUTE_CONTENT = "content";
    private static final int STATE_ELEMENT_START = 0;
    private static final int STATE_ELEMENT_AFTER_LT = 1;
    private static final int STATE_ELEMENT_AFTER_LT_SLASH = 2;
    private static final int STATE_ELEMENT_META = 3;
    private static final int STATE_HTTP_START = 0;
    private static final int STATE_HTTP_AFTER_NAME = 1;
    private static final int STATE_HTTP_AFTER_EQ = 2;
    private static final int STATE_HTTP_DONE = 3;
    private static final int STATE_CONTENT_START = 0;
    private static final int STATE_CONTENT_AFTER_NAME = 1;
    private static final int STATE_CONTENT_AFTER_EQ = 2;
    private static final int STATE_CONTENT_DONE = 3;

    public static String getCharsetFromHTML(InputStream is) {
        ASCIIReader asciiReader = new ASCIIReader(is, 2048);
        StreamTokenizer tokenizer = new StreamTokenizer(asciiReader);
        tokenizer.lowerCaseMode(false);
        tokenizer.ordinaryChar(39);
        tokenizer.ordinaryChar(47);
        String charset = XHTMLCharsetParser.getCharsetFromHTMLTokens(tokenizer);
        if (asciiReader != null) {
            try {
                ((Reader)asciiReader).close();
            }
            catch (IOException iOException) {}
        }
        return charset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCharsetFromHTMLTokens(StreamTokenizer tokenizer) {
        String contentValue = null;
        int stateContent = 0;
        int stateElement = 0;
        int stateHttp = 0;
        try {
            int token = tokenizer.nextToken();
            while (true) {
                if (token == -1) {
                    return null;
                }
                block1 : switch (stateElement) {
                    case 0: {
                        if (token != 60) break;
                        stateElement = 1;
                        break;
                    }
                    case 1: {
                        if (token == -3) {
                            if (ELEMENT_META.equalsIgnoreCase(tokenizer.sval)) {
                                stateElement = 3;
                                stateHttp = 0;
                                stateContent = 0;
                                contentValue = null;
                                break;
                            }
                            if (ELEMENT_BODY.equalsIgnoreCase(tokenizer.sval)) {
                                return null;
                            }
                            stateElement = 0;
                            break;
                        }
                        if (token == 47) {
                            stateElement = 2;
                            break;
                        }
                        stateElement = 0;
                        break;
                    }
                    case 2: {
                        if (token == -3 && ELEMENT_HEAD.equalsIgnoreCase(tokenizer.sval)) {
                            return null;
                        }
                        stateElement = 0;
                        break;
                    }
                    default: {
                        switch (token) {
                            case 62: {
                                stateElement = 0;
                                break block1;
                            }
                            case -3: {
                                if (ATTRIBUTE_HTTP.equalsIgnoreCase(tokenizer.sval)) {
                                    stateHttp = 1;
                                    break block1;
                                }
                                if (ATTRIBUTE_CONTENT.equalsIgnoreCase(tokenizer.sval)) {
                                    stateContent = 1;
                                    break block1;
                                }
                                if (stateHttp == 2 && ATTRIBUTE_HTTP_VALUE.equalsIgnoreCase(tokenizer.sval)) {
                                    stateHttp = 3;
                                    break block1;
                                }
                                if (stateHttp != 3) {
                                    stateHttp = 0;
                                }
                                if (stateContent == 3) break block1;
                                stateContent = 0;
                                break block1;
                            }
                            case 61: {
                                if (stateHttp == 1) {
                                    stateHttp = 2;
                                    break block1;
                                }
                                if (stateContent == 1) {
                                    stateContent = 2;
                                    break block1;
                                }
                                if (stateHttp != 3) {
                                    stateHttp = 0;
                                }
                                if (stateContent == 3) break block1;
                                stateContent = 0;
                                break block1;
                            }
                            case 34: {
                                if (stateHttp == 2) {
                                    if (!ATTRIBUTE_HTTP_VALUE.equalsIgnoreCase(tokenizer.sval)) break block1;
                                    stateHttp = 3;
                                    break block1;
                                }
                                if (stateContent == 2) {
                                    stateContent = 3;
                                    contentValue = tokenizer.sval;
                                    break block1;
                                }
                                stateHttp = 0;
                                stateContent = 0;
                                break block1;
                            }
                            default: {
                                if (stateHttp != 3) {
                                    stateHttp = 0;
                                }
                                if (stateContent == 3) break block1;
                                stateContent = 0;
                            }
                        }
                    }
                }
                if (contentValue != null && stateHttp == 3 && stateContent == 3) {
                    return XHTMLCharsetParser.getCharsetFromHTTP(contentValue);
                }
                token = tokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getCharsetFromHTTP(String contentValue) {
        StringTokenizer t = new StringTokenizer(contentValue, ";");
        while (t.hasMoreTokens()) {
            String charset;
            String parameter = t.nextToken().trim();
            if (!parameter.toLowerCase(Locale.ENGLISH).startsWith("charset=") || (charset = parameter.substring("charset=".length()).trim()).length() <= 0) continue;
            return charset;
        }
        return null;
    }
}

