/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UACharsetProcessor {
    private static final String ELEMENT_HTML = "html";
    private static final String ELEMENT_HEAD = "head";
    private static final String ELEMENT_META = "meta";
    private static final String ATTRIBUTE_CONTENT = "content";
    private static final String PREFIX_CHARSET = "text/html; charset=";
    private static final String ENCODING_UTF8 = "UTF-8";

    public void processCharset(Document document) {
        Element html = document.getDocumentElement();
        if (ELEMENT_HTML.equalsIgnoreCase(html.getNodeName())) {
            Node head = html.getFirstChild();
            while (head != null) {
                if (head.getNodeType() == 1 && ELEMENT_HEAD.equalsIgnoreCase(head.getNodeName())) {
                    Node meta = head.getFirstChild();
                    while (meta != null) {
                        Element element;
                        String content;
                        if (meta.getNodeType() == 1 && ELEMENT_META.equalsIgnoreCase(meta.getNodeName()) && (content = (element = (Element)meta).getAttribute(ATTRIBUTE_CONTENT)).startsWith(PREFIX_CHARSET)) {
                            element.setAttribute(ATTRIBUTE_CONTENT, "text/html; charset=UTF-8");
                            return;
                        }
                        meta = meta.getNextSibling();
                    }
                    return;
                }
                head = head.getNextSibling();
            }
        }
    }
}

