/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionReader;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionTransformer;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringContributionManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RefactoringHistoryManager {
    public static final char DELIMITER_COMPONENT = '\t';
    public static final char DELIMITER_ENTRY = '\n';
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getTimeZone("GMT+00:00");
    private RefactoringSessionDescriptor fCachedDescriptor = null;
    private Document fCachedDocument = null;
    private IPath fCachedPath = null;
    private IFileStore fCachedStore = null;
    private final IFileStore fHistoryStore;
    private final String fProjectName;

    private static void addIndexEntry(IFileStore file, RefactoringDescriptor descriptor, IProgressMonitor monitor) throws CoreException, IOException {
        BufferedReader reader;
        block19: {
            reader = null;
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 5);
                if (!file.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) break block19;
                StringBuffer temp = new StringBuffer(64);
                temp.append(descriptor.getTimeStamp());
                temp.append('\t');
                temp.append(RefactoringHistoryManager.escapeString(descriptor.getDescription()));
                String value = temp.toString();
                reader = new BufferedReader(new InputStreamReader((InputStream)new DataInputStream(new BufferedInputStream(file.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)))), "utf-8"));
                StringBuffer buffer = new StringBuffer();
                boolean inserted = false;
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null) continue;
                    buffer.append(line);
                    buffer.append('\n');
                    if (inserted || value.compareTo(line) <= 0) continue;
                    buffer.append(value);
                    buffer.append('\n');
                    inserted = true;
                }
                monitor.worked(1);
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException iOException) {}
                OutputStream stream = null;
                try {
                    file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                    stream = new BufferedOutputStream(file.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                    stream.write(buffer.toString().getBytes("utf-8"));
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        monitor.done();
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static void appendIndexEntry(IFileStore file, RefactoringDescriptor descriptor, IProgressMonitor monitor) throws CoreException, IOException {
        OutputStream output = null;
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 2);
            file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            output = new BufferedOutputStream(file.openOutputStream(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
            StringBuffer buffer = new StringBuffer(256);
            buffer.append(descriptor.getTimeStamp());
            buffer.append('\t');
            buffer.append(RefactoringHistoryManager.escapeString(descriptor.getDescription()));
            buffer.append('\n');
            output.write(buffer.toString().getBytes("utf-8"));
        }
        catch (Throwable throwable) {
            monitor.done();
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        monitor.done();
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void checkArgument(Object argument) throws CoreException {
        if (argument instanceof String) {
            String string = (String)argument;
            if ("".equals(string)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, RefactoringCoreMessages.RefactoringHistoryManager_empty_argument, null));
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, RefactoringCoreMessages.RefactoringHistoryManager_non_string_argument, null));
        }
    }

    private static void checkArgumentMap(Map arguments) throws CoreException {
        Assert.isNotNull((Object)arguments);
        for (Map.Entry entry : arguments.entrySet()) {
            RefactoringHistoryManager.checkArgument(entry.getKey());
            RefactoringHistoryManager.checkArgument(entry.getValue());
        }
    }

    public static String escapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuffer buffer = new StringBuffer(length + 4);
            int index = 0;
            while (index < length) {
                char character = string.charAt(index);
                if ('\t' == character) {
                    buffer.append('\t');
                }
                buffer.append(character);
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    private static void readRefactoringDescriptorProxies(IFileStore store, String project, Collection collection, long start, long end, int flags, IProgressMonitor monitor) throws CoreException {
        try {
            int index;
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 22);
            IFileInfo info = store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
            if (!info.isDirectory() && info.exists() && store.getName().equalsIgnoreCase("refactorings.index")) {
                InputStream stream = null;
                try {
                    try {
                        stream = store.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                        RefactoringDescriptorProxy[] proxies = RefactoringHistoryManager.readRefactoringDescriptorProxies(stream, project, start, end, flags);
                        index = 0;
                        while (index < proxies.length) {
                            collection.add(proxies[index]);
                            ++index;
                        }
                        monitor.worked(1);
                    }
                    catch (IOException exception) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                    }
                }
                catch (Throwable throwable) {
                    monitor.worked(1);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.worked(1);
                    throw throwable;
                }
                monitor.worked(1);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.worked(1);
            } else {
                monitor.worked(4);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IFileStore[] stores = store.childStores(0, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 12);
            try {
                subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, stores.length);
                index = 0;
                while (index < stores.length) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(stores[index], project, collection, start, end, flags, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                    ++index;
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static RefactoringDescriptorProxy[] readRefactoringDescriptorProxies(InputStream stream, String project, long start, long end, int flags) throws IOException {
        ArrayList<DefaultRefactoringDescriptorProxy> list = new ArrayList<DefaultRefactoringDescriptorProxy>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
        while (reader.ready()) {
            int index;
            String line = reader.readLine();
            if (line == null || (index = line.indexOf(9)) <= 0) continue;
            try {
                long stamp = new Long(line.substring(0, index));
                if (stamp < start || stamp > end) continue;
                list.add(new DefaultRefactoringDescriptorProxy(RefactoringHistoryManager.unescapeString(line.substring(index + 1)), project, stamp));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return list.toArray(new RefactoringDescriptorProxy[list.size()]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readRefactoringDescriptors(InputStream stream, Collection collection, int count, IProgressMonitor monitor) throws CoreException {
        try {
            block6: {
                int index;
                int size;
                RefactoringDescriptor[] results;
                block5: {
                    monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 1);
                    results = new RefactoringSessionReader(true).readSession(new InputSource(new BufferedInputStream(stream))).getRefactorings();
                    Arrays.sort(results, new Comparator(){

                        public final int compare(Object first, Object second) {
                            RefactoringDescriptor predecessor = (RefactoringDescriptor)first;
                            RefactoringDescriptor successor = (RefactoringDescriptor)second;
                            long delta = predecessor.getTimeStamp() - successor.getTimeStamp();
                            if (delta > 0L) {
                                return 1;
                            }
                            if (delta < 0L) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    monitor.worked(1);
                    size = count - collection.size();
                    index = 0;
                    if (!true) break block5;
                    if (index >= results.length) return;
                    if (index >= size) break block6;
                }
                do {
                    collection.add(results[index]);
                    ++index;
                    if (index >= results.length) return;
                } while (index < size);
            }
            return;
        }
        finally {
            monitor.done();
        }
    }

    public static RefactoringDescriptor[] readRefactoringDescriptors(InputStream stream, long start, long end) throws CoreException {
        ArrayList list = new ArrayList();
        RefactoringHistoryManager.readRefactoringDescriptors(stream, list, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        RefactoringDescriptor[] descriptors = new RefactoringDescriptor[list.size()];
        list.toArray(descriptors);
        return descriptors;
    }

    private static void removeIndexEntry(IFileStore file, long stamp, IProgressMonitor monitor) throws CoreException, IOException {
        BufferedReader reader;
        block19: {
            reader = null;
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 5);
                if (!file.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) break block19;
                String value = new Long(stamp).toString();
                reader = new BufferedReader(new InputStreamReader((InputStream)new DataInputStream(new BufferedInputStream(file.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)))), "utf-8"));
                StringBuffer buffer = new StringBuffer();
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null || line.startsWith(value)) continue;
                    buffer.append(line);
                    buffer.append('\n');
                }
                monitor.worked(1);
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException iOException) {}
                OutputStream stream = null;
                try {
                    file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                    stream = new BufferedOutputStream(file.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                    stream.write(buffer.toString().getBytes("utf-8"));
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        monitor.done();
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void removeIndexTree(IFileStore store, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 16);
            IFileInfo info = store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            if (info.isDirectory()) {
                if (info.getName().equalsIgnoreCase(".refactorings")) {
                    return;
                }
                IFileStore[] stores = store.childStores(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1, 2);
                try {
                    subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, stores.length);
                    int index = 0;
                    while (index < stores.length) {
                        IFileInfo current = stores[index].fetchInfo(0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1, 2));
                        if (current.isDirectory()) {
                            char[] characters = stores[index].getName().toCharArray();
                            int offset = 0;
                            while (offset < characters.length) {
                                if (Character.isDigit(characters[offset])) {
                                    return;
                                }
                                ++offset;
                            }
                        }
                        ++index;
                    }
                }
                finally {
                    subMonitor.done();
                    return;
                }
            }
            IFileStore parent = store.getParent();
            store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            RefactoringHistoryManager.removeIndexTree(parent, (IProgressMonitor)new SubProgressMonitor(monitor, 12, 2));
            return;
        }
        finally {
            monitor.done();
        }
    }

    public static IPath stampToPath(long stamp) {
        Calendar calendar = Calendar.getInstance(LOCAL_TIME_ZONE);
        calendar.setTimeInMillis(stamp);
        Path path = new Path(String.valueOf(calendar.get(1)));
        path = path.append(String.valueOf(calendar.get(2) + 1));
        path = path.append(String.valueOf(calendar.get(3)));
        return path;
    }

    private static Object transformDescriptor(RefactoringDescriptor descriptor, boolean projects) throws CoreException {
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer(projects);
        try {
            transformer.beginSession(null);
            try {
                String id = descriptor.getID();
                transformer.beginRefactoring(id, descriptor.getTimeStamp(), descriptor.getProject(), descriptor.getDescription(), descriptor.getComment(), descriptor.getFlags());
                Map arguments = null;
                RefactoringContribution contribution = RefactoringContributionManager.getInstance().getRefactoringContribution(id);
                if (contribution != null) {
                    arguments = contribution.retrieveArgumentMap(descriptor);
                } else if (descriptor instanceof DefaultRefactoringDescriptor) {
                    arguments = ((DefaultRefactoringDescriptor)descriptor).getArguments();
                }
                if (arguments != null) {
                    RefactoringHistoryManager.checkArgumentMap(arguments);
                    for (Map.Entry entry : arguments.entrySet()) {
                        transformer.createArgument((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            finally {
                transformer.endRefactoring();
            }
        }
        finally {
            transformer.endSession();
        }
        return transformer.getResult();
    }

    public static String unescapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuffer buffer = new StringBuffer(length);
            int index = 0;
            while (index < length) {
                char escape;
                char character = string.charAt(index);
                if ('\t' != character || index >= length - 1 || '\t' != (escape = string.charAt(index + 1))) {
                    buffer.append(character);
                }
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    public static void writeRefactoringDescriptors(OutputStream stream, RefactoringDescriptor[] descriptors, boolean stamps) throws CoreException {
        RefactoringHistoryManager.writeRefactoringSession(stream, new RefactoringSessionDescriptor(descriptors, "1.0", null), stamps);
    }

    public static void writeRefactoringSession(OutputStream stream, RefactoringSessionDescriptor descriptor, boolean stamps) throws CoreException {
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer(true);
        RefactoringDescriptor[] descriptors = descriptor.getRefactorings();
        try {
            transformer.beginSession(descriptor.getComment());
            int index = 0;
            while (index < descriptors.length) {
                RefactoringDescriptor current = descriptors[index];
                if (current != null) {
                    try {
                        long stamp = stamps ? current.getTimeStamp() : -1L;
                        String id = current.getID();
                        transformer.beginRefactoring(id, stamp, current.getProject(), current.getDescription(), current.getComment(), current.getFlags());
                        Map arguments = null;
                        RefactoringContribution contribution = RefactoringContributionManager.getInstance().getRefactoringContribution(id);
                        if (contribution != null) {
                            arguments = contribution.retrieveArgumentMap(current);
                        } else if (current instanceof DefaultRefactoringDescriptor) {
                            arguments = ((DefaultRefactoringDescriptor)current).getArguments();
                        }
                        if (arguments != null) {
                            RefactoringHistoryManager.checkArgumentMap(arguments);
                            for (Map.Entry entry : arguments.entrySet()) {
                                transformer.createArgument((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                    }
                    finally {
                        transformer.endRefactoring();
                    }
                }
                ++index;
            }
        }
        finally {
            transformer.endSession();
        }
        Object result = transformer.getResult();
        if (result instanceof Node) {
            try {
                Transformer transform = TransformerFactory.newInstance().newTransformer();
                transform.setOutputProperty("indent", "yes");
                transform.setOutputProperty("method", "xml");
                transform.setOutputProperty("encoding", "utf-8");
                transform.transform(new DOMSource((Node)result), new StreamResult(stream));
            }
            catch (TransformerConfigurationException exception) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, exception.getLocalizedMessage(), (Throwable)exception));
            }
            catch (TransformerFactoryConfigurationError exception) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, exception.getLocalizedMessage(), (Throwable)exception));
            }
            catch (TransformerException exception) {
                Throwable throwable = exception.getException();
                if (throwable instanceof IOException) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, throwable.getLocalizedMessage(), throwable));
                }
                RefactoringCorePlugin.log(exception);
            }
        }
    }

    RefactoringHistoryManager(IFileStore store, String name) {
        Assert.isNotNull((Object)store);
        Assert.isTrue((name == null || !"".equals(name) ? 1 : 0) != 0);
        this.fHistoryStore = store;
        this.fProjectName = name;
    }

    void addRefactoringDescriptor(RefactoringDescriptor descriptor, boolean sort, IProgressMonitor monitor) throws CoreException {
        block26: {
            try {
                IPath path;
                IFileStore folder;
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 5);
                long stamp = descriptor.getTimeStamp();
                if (stamp < 0L || (folder = this.fHistoryStore.getChild(path = RefactoringHistoryManager.stampToPath(stamp))) == null) break block26;
                IFileStore history = folder.getChild("refactorings.history");
                IFileStore index = folder.getChild("refactorings.index");
                if (history == null || index == null) break block26;
                if (history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) {
                    InputStream input = null;
                    try {
                        try {
                            input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                            Document document = this.getCachedDocument(path, input);
                            try {
                                input.close();
                                input = null;
                            }
                            catch (IOException iOException) {}
                            monitor.worked(1);
                            Object result = RefactoringHistoryManager.transformDescriptor(descriptor, false);
                            if (result instanceof Document) {
                                boolean found = false;
                                NodeList list = ((Document)result).getElementsByTagName("refactoring");
                                Element root = document.getDocumentElement();
                                if (sort) {
                                    String string = Long.toString(stamp);
                                    int offset = 0;
                                    while (offset < list.getLength()) {
                                        Element element = (Element)list.item(offset);
                                        String attribute = element.getAttribute("stamp");
                                        if (attribute != null && string.compareTo(attribute) > 0) {
                                            root.insertBefore(document.importNode(element, true), element);
                                            found = true;
                                            break;
                                        }
                                        ++offset;
                                    }
                                }
                                if (!found) {
                                    root.appendChild(document.importNode(list.item(0), true));
                                }
                                this.writeHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                RefactoringHistoryManager.addIndexEntry(index, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                            }
                        }
                        catch (ParserConfigurationException exception) {
                            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                        catch (IOException exception) {
                            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                        catch (SAXException exception) {
                            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block26;
                }
                try {
                    Object result = RefactoringHistoryManager.transformDescriptor(descriptor, false);
                    if (result instanceof Node) {
                        this.writeHistoryEntry(history, (Node)result, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                        RefactoringHistoryManager.appendIndexEntry(index, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                    }
                }
                catch (IOException exception) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private Document getCachedDocument(IPath path, InputStream input) throws SAXException, IOException, ParserConfigurationException {
        Document document;
        if (path.equals((Object)this.fCachedPath) && this.fCachedDocument != null) {
            return this.fCachedDocument;
        }
        this.fCachedDocument = document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(input));
        this.fCachedPath = path;
        return document;
    }

    private RefactoringSessionDescriptor getCachedSession(IFileStore store, InputStream input) throws CoreException {
        RefactoringSessionDescriptor descriptor;
        if (store.equals(this.fCachedStore) && this.fCachedDescriptor != null) {
            return this.fCachedDescriptor;
        }
        this.fCachedDescriptor = descriptor = new RefactoringSessionReader(true).readSession(new InputSource(input));
        this.fCachedStore = store;
        return descriptor;
    }

    RefactoringHistory readRefactoringHistory(long start, long end, int flags, IProgressMonitor monitor) {
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 200);
            HashSet set = new HashSet();
            try {
                IFileStore store;
                if (this.fHistoryStore.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(this.fHistoryStore, this.fProjectName, set, start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
                if ((store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(".refactorings").getChild(".workspace")).fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(store, null, set, start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
            }
            catch (CoreException exception) {
                RefactoringCorePlugin.log(exception);
            }
            RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[set.size()];
            set.toArray(proxies);
            RefactoringHistoryImplementation refactoringHistoryImplementation = new RefactoringHistoryImplementation(proxies);
            return refactoringHistoryImplementation;
        }
        finally {
            monitor.done();
        }
    }

    void removeRefactoringDescriptor(long stamp, IProgressMonitor monitor) throws CoreException {
        block22: {
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 6);
                IPath path = RefactoringHistoryManager.stampToPath(stamp);
                IFileStore folder = this.fHistoryStore.getChild(path);
                if (folder == null) break block22;
                IFileStore history = folder.getChild("refactorings.history");
                IFileStore index = folder.getChild("refactorings.index");
                if (history == null || index == null || !history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists() || !index.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) break block22;
                InputStream input = null;
                try {
                    try {
                        input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                        Document document = this.getCachedDocument(path, input);
                        NodeList list = document.getElementsByTagName("refactoring");
                        int length = list.getLength();
                        int offset = 0;
                        while (offset < length) {
                            Node item;
                            Node node = list.item(offset);
                            NamedNodeMap attributes = node.getAttributes();
                            if (attributes != null && (item = attributes.getNamedItem("stamp")) != null) {
                                String value = item.getNodeValue();
                                if (String.valueOf(stamp).equals(value)) {
                                    try {
                                        input.close();
                                        input = null;
                                    }
                                    catch (IOException iOException) {}
                                    if (length == 1) {
                                        RefactoringHistoryManager.removeIndexTree(folder, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                    } else {
                                        node.getParentNode().removeChild(node);
                                        this.writeHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                        RefactoringHistoryManager.removeIndexEntry(index, stamp, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                    }
                                    break;
                                }
                            }
                            ++offset;
                        }
                    }
                    catch (ParserConfigurationException exception) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                    }
                    catch (IOException exception) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                    }
                    catch (SAXException exception) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
        block19: {
            try {
                IFileStore history;
                IPath path;
                IFileStore folder;
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 100);
                long stamp = proxy.getTimeStamp();
                if (stamp < 0L || (folder = this.fHistoryStore.getChild(path = RefactoringHistoryManager.stampToPath(stamp))) == null || (history = folder.getChild("refactorings.history")) == null || !history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) break block19;
                InputStream input = null;
                try {
                    try {
                        input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 40, 2)));
                        Document document = this.getCachedDocument(path, input);
                        try {
                            input.close();
                            input = null;
                        }
                        catch (IOException iOException) {}
                        String time = String.valueOf(stamp);
                        NodeList list = document.getElementsByTagName("refactoring");
                        int index = 0;
                        while (index < list.getLength()) {
                            Element element = (Element)list.item(index);
                            if (time.equals(element.getAttribute("stamp"))) {
                                element.setAttribute("comment", comment);
                            }
                            ++index;
                        }
                        this.writeHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 40, 2));
                    }
                    catch (ParserConfigurationException exception) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                    }
                    catch (IOException exception) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                    }
                    catch (SAXException exception) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void writeHistoryEntry(IFileStore file, Node node, IProgressMonitor monitor) throws CoreException, IOException {
        block24: {
            OutputStream output = null;
            try {
                block23: {
                    monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 2);
                    try {
                        try {
                            file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                            output = new BufferedOutputStream(file.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                            Transformer transformer = TransformerFactory.newInstance().newTransformer();
                            transformer.setOutputProperty("indent", "yes");
                            transformer.setOutputProperty("method", "xml");
                            transformer.setOutputProperty("encoding", "utf-8");
                            try {
                                transformer.transform(new DOMSource(node), new StreamResult(output));
                            }
                            finally {
                                this.fCachedDocument = null;
                                this.fCachedPath = null;
                                this.fCachedDescriptor = null;
                                this.fCachedStore = null;
                            }
                        }
                        catch (TransformerConfigurationException exception) {
                            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                        catch (TransformerFactoryConfigurationError exception) {
                            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                        catch (TransformerException exception) {
                            Throwable throwable = exception.getException();
                            if (throwable instanceof IOException) {
                                throw (IOException)throwable;
                            }
                            RefactoringCorePlugin.log(exception);
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

