/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.DirtyBufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.ModificationStampValidationState;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public abstract class BufferValidationState {
    protected IFile fFile;
    protected boolean fExisted;
    protected String fEncoding;

    public static BufferValidationState create(IFile file) {
        ITextFileBuffer buffer = BufferValidationState.getBuffer(file);
        if (buffer == null) {
            return new ModificationStampValidationState(file);
        }
        IDocument document = buffer.getDocument();
        if (document instanceof IDocumentExtension4) {
            return new ModificationStampValidationState(file);
        }
        if (buffer.isDirty()) {
            return new DirtyBufferValidationState(file);
        }
        return new ModificationStampValidationState(file);
    }

    public RefactoringStatus isValid(boolean needsSaving) throws CoreException {
        if (!this.fExisted) {
            if (this.fFile.exists()) {
                return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.TextChanges_error_existing, this.fFile.getFullPath().toString()));
            }
        } else if (!this.fFile.exists()) {
            return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.TextChanges_error_not_existing, this.fFile.getFullPath().toString()));
        }
        if (needsSaving) {
            if (this.fFile.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.TextChanges_error_read_only, this.fFile.getFullPath().toString()));
            }
            if (!this.fFile.isSynchronized(0)) {
                return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.TextChanges_error_outOfSync, this.fFile.getFullPath().toString()));
            }
        }
        if (this.fEncoding == null) {
            return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.BufferValidationState_no_character_encoding, this.fFile.getFullPath().toString()));
        }
        if (!this.fEncoding.equals(this.fFile.getCharset(true))) {
            return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.BufferValidationState_character_encoding_changed, this.fFile.getFullPath().toString()));
        }
        return new RefactoringStatus();
    }

    public void dispose() {
    }

    protected BufferValidationState(IFile file) {
        this.fFile = file;
        this.fExisted = file.exists();
        try {
            this.fEncoding = file.getCharset(true);
        }
        catch (CoreException coreException) {
            this.fEncoding = null;
        }
    }

    protected IDocument getDocument() {
        ITextFileBuffer buffer = BufferValidationState.getBuffer(this.fFile);
        if (buffer == null) {
            return null;
        }
        return buffer.getDocument();
    }

    protected static boolean isDirty(IFile file) {
        ITextFileBuffer buffer = BufferValidationState.getBuffer(file);
        if (buffer == null) {
            return false;
        }
        return buffer.isDirty();
    }

    protected static ITextFileBuffer getBuffer(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        ITextFileBuffer buffer = manager.getTextFileBuffer(path);
        return buffer;
    }

    protected ModificationStamp getModificationStamp() {
        ITextFileBuffer buffer = BufferValidationState.getBuffer(this.fFile);
        if (buffer == null) {
            return ModificationStamp.createFile(this.fFile.getModificationStamp());
        }
        IDocument document = buffer.getDocument();
        if (document instanceof IDocumentExtension4) {
            return ModificationStamp.createDocument(((IDocumentExtension4)document).getModificationStamp());
        }
        return ModificationStamp.createFile(this.fFile.getModificationStamp());
    }

    protected static class ModificationStamp {
        private int fKind;
        private long fValue;
        public static final int FILE = 1;
        public static final int DOCUMENT = 2;

        public static ModificationStamp createFile(long value) {
            return new ModificationStamp(1, value);
        }

        public static ModificationStamp createDocument(long value) {
            return new ModificationStamp(2, value);
        }

        private ModificationStamp(int kind, long value) {
            this.fKind = kind;
            this.fValue = value;
        }

        public boolean isFileStamp() {
            return this.fKind == 1;
        }

        public boolean isDocumentStamp() {
            return this.fKind == 2;
        }

        public int getKind() {
            return this.fKind;
        }

        public long getValue() {
            return this.fValue;
        }
    }
}

