/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.markers.internal.AttributeMarkerGrouping;
import org.eclipse.ui.views.markers.internal.FieldMarkerGroup;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.TableSorter;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerSupportRegistry
implements IExtensionChangeHandler {
    private static final String DESCRIPTION = "onDescription";
    private static final String ENABLED = "enabled";
    private static final Object ERROR = "ERROR";
    static final String ID = "id";
    private static final Object INFO = "INFO";
    private static final Object WARNING = "WARNING";
    private static final String MARKER_ID = "markerId";
    public static final String MARKER_SUPPORT = "markerSupport";
    private static final String NAME = "name";
    private static final Object ON_ANY = "ON_ANY";
    private static final Object ON_ANY_IN_SAME_CONTAINER = "ON_ANY_IN_SAME_CONTAINER";
    private static final Object ON_SELECTED_AND_CHILDREN = "ON_SELECTED_AND_CHILDREN";
    private static final Object ON_SELECTED_ONLY = "ON_SELECTED_ONLY";
    private static final Object PROBLEM_FILTER = "problemFilter";
    private static final String SCOPE = "scope";
    private static final String SELECTED_TYPE = "selectedType";
    private static final String SEVERITY = "severity";
    private static final String MARKER_TYPE_REFERENCE = "markerTypeReference";
    private static final String MARKER_CATEGORY = "markerTypeCategory";
    private static final String ATTRIBUTE_MAPPING = "markerAttributeMapping";
    private static final String MARKER_GROUPING = "markerGrouping";
    private static final String ATTRIBUTE = "attribute";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String MARKER_ATTRIBUTE_GROUPING = "markerAttributeGrouping";
    private static final String DEFAULT_GROUPING_ENTRY = "defaultGroupingEntry";
    private static final String MARKER_TYPE = "markerType";
    private static final String PRIORITY = "priority";
    private static final String MARKER_GROUPING_ENTRY = "markerGroupingEntry";
    private static final Object SEVERITY_ID = "org.eclipse.ui.ide.severity";
    private static MarkerSupportRegistry singleton;
    private static Object creationLock;
    private Collection registeredFilters = new ArrayList();
    private Map markerGroups = new HashMap();
    private Map markerGroupingEntries = new HashMap();
    private HashMap categories = new HashMap();
    private HashMap hierarchyOrders = new HashMap();
    private MarkerType rootType;

    static {
        creationLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MarkerSupportRegistry getInstance() {
        if (singleton == null) {
            Object object = creationLock;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new MarkerSupportRegistry();
                }
            }
        }
        return singleton;
    }

    private MarkerSupportRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.ide", MARKER_SUPPORT);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        HashMap groupingEntries = new HashMap();
        HashSet attributeMappings = new HashSet();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            this.processExtension(tracker, extension, groupingEntries, attributeMappings);
            ++i;
        }
        this.postProcessExtensions(groupingEntries, attributeMappings);
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)point));
    }

    private void processExtension(IExtensionTracker tracker, IExtension extension, Map groupingEntries, Collection attributeMappings) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            IConfigurationElement element = elements[j];
            if (element.getName().equals(PROBLEM_FILTER)) {
                ProblemFilter filter = this.newFilter(element);
                this.registeredFilters.add(filter);
                tracker.registerObject(extension, (Object)filter, 0);
            } else {
                if (element.getName().equals(MARKER_GROUPING)) {
                    FieldMarkerGroup group = new FieldMarkerGroup(element.getAttribute(LABEL), element.getAttribute(ID));
                    this.markerGroups.put(group.getId(), group);
                    tracker.registerObject(extension, (Object)group, 0);
                }
                if (element.getName().equals(MARKER_GROUPING_ENTRY)) {
                    MarkerGroupingEntry entry = new MarkerGroupingEntry(element.getAttribute(LABEL), element.getAttribute(ID), Integer.valueOf(element.getAttribute(PRIORITY)));
                    String groupName = element.getAttribute(MARKER_GROUPING);
                    Collection<MarkerGroupingEntry> entries = groupingEntries.containsKey(groupName) ? (Collection)groupingEntries.get(groupName) : new HashSet<MarkerGroupingEntry>();
                    entries.add(entry);
                    groupingEntries.put(groupName, entries);
                    tracker.registerObject(extension, (Object)entry, 0);
                }
                if (element.getName().equals(MARKER_ATTRIBUTE_GROUPING)) {
                    AttributeMarkerGrouping grouping = new AttributeMarkerGrouping(element.getAttribute(ATTRIBUTE), element.getAttribute(MARKER_TYPE), element.getAttribute(DEFAULT_GROUPING_ENTRY), element);
                    attributeMappings.add(grouping);
                    tracker.registerObject(extension, (Object)grouping, 0);
                }
                if (element.getName().equals(MARKER_CATEGORY)) {
                    String[] markerTypes = this.getMarkerTypes(element);
                    String categoryName = element.getAttribute(NAME);
                    int i = 0;
                    while (i < markerTypes.length) {
                        this.categories.put(markerTypes[i], categoryName);
                        ++i;
                    }
                    tracker.registerObject(extension, (Object)categoryName, 0);
                }
            }
            ++j;
        }
    }

    private void postProcessExtensions(Map groupingEntries, Collection attributeMappings) {
        this.processGroupingEntries(groupingEntries);
        this.processAttributeMappings(attributeMappings);
    }

    /*
     * Unable to fully structure code
     */
    private void processGroupingEntries(Map groupingEntries) {
        for (String nextGroupId : groupingEntries.keySet()) {
            nextEntriesIterator = ((Collection)groupingEntries.get(nextGroupId)).iterator();
            if (!this.markerGroups.containsKey(nextGroupId)) ** GOTO lbl13
            while (nextEntriesIterator.hasNext()) {
                next = (MarkerGroupingEntry)nextEntriesIterator.next();
                this.markerGroupingEntries.put(next.getId(), next);
                next.setGroupingEntry((FieldMarkerGroup)this.markerGroups.get(nextGroupId));
            }
            continue;
lbl-1000:
            // 1 sources

            {
                next = (MarkerGroupingEntry)nextEntriesIterator.next();
                IDEWorkbenchPlugin.log(NLS.bind((String)"markerGroupingEntry {0} defines invalid group {1}", (Object[])new String[]{next.getId(), nextGroupId}));
lbl13:
                // 2 sources

                ** while (nextEntriesIterator.hasNext())
            }
lbl14:
            // 1 sources

        }
    }

    private void processAttributeMappings(Collection attributeMappings) {
        for (AttributeMarkerGrouping next : attributeMappings) {
            String defaultEntryId = next.getDefaultGroupingEntry();
            if (defaultEntryId != null) {
                if (this.markerGroupingEntries.containsKey(defaultEntryId)) {
                    MarkerGroupingEntry entry = (MarkerGroupingEntry)this.markerGroupingEntries.get(defaultEntryId);
                    entry.setAsDefault(next.getMarkerType());
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invalid markerGroupingEntry {0}", (Object)defaultEntryId));
                }
            }
            IConfigurationElement[] mappings = next.getElement().getChildren(ATTRIBUTE_MAPPING);
            int i = 0;
            while (i < mappings.length) {
                String entryId = mappings[i].getAttribute(MARKER_GROUPING_ENTRY);
                if (this.markerGroupingEntries.containsKey(entryId)) {
                    MarkerGroupingEntry entry = (MarkerGroupingEntry)this.markerGroupingEntries.get(entryId);
                    entry.mapAttribute(next.getMarkerType(), next.getAttribute(), mappings[i].getAttribute(VALUE));
                } else {
                    IDEWorkbenchPlugin.log(NLS.bind((String)"Reference to invaild markerGroupingEntry {0}", (Object)defaultEntryId));
                }
                ++i;
            }
        }
    }

    private String[] getMarkerTypes(IConfigurationElement element) {
        IConfigurationElement[] types = element.getChildren(MARKER_TYPE_REFERENCE);
        String[] ids = new String[types.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = types[i].getAttribute(ID);
            ++i;
        }
        return ids;
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        HashMap groupingEntries = new HashMap();
        HashSet attributeMappings = new HashSet();
        this.processExtension(tracker, extension, groupingEntries, attributeMappings);
        this.postProcessExtensions(groupingEntries, attributeMappings);
    }

    public Collection getRegisteredFilters() {
        ArrayList<ProblemFilter> filteredFilters = new ArrayList<ProblemFilter>();
        for (ProblemFilter next : this.registeredFilters) {
            if (next.isFilteredOutByActivity()) continue;
            filteredFilters.add(next);
        }
        return filteredFilters;
    }

    private int getScopeValue(IConfigurationElement element) {
        String scope = element.getAttribute(SCOPE);
        if (scope == null) {
            return -1;
        }
        if (scope.equals(ON_ANY)) {
            return 0;
        }
        if (scope.equals(ON_SELECTED_ONLY)) {
            return 1;
        }
        if (scope.equals(ON_SELECTED_AND_CHILDREN)) {
            return 2;
        }
        if (scope.equals(ON_ANY_IN_SAME_CONTAINER)) {
            return 3;
        }
        return -1;
    }

    private int getSeverityValue(IConfigurationElement element) {
        String severity = element.getAttribute(SEVERITY);
        if (severity == null) {
            return -1;
        }
        if (severity.equals(INFO)) {
            return 1;
        }
        if (severity.equals(WARNING)) {
            return 2;
        }
        if (severity.equals(ERROR)) {
            return 4;
        }
        return -1;
    }

    private ProblemFilter newFilter(IConfigurationElement element) {
        int severityValue;
        String description;
        ProblemFilter filter = new ProblemFilter(element.getAttribute(NAME));
        filter.createContributionFrom(element);
        String enabledValue = element.getAttribute(ENABLED);
        filter.setEnabled(enabledValue == null || Boolean.valueOf(enabledValue) != false);
        int scopeValue = this.getScopeValue(element);
        if (scopeValue >= 0) {
            filter.setOnResource(scopeValue);
        }
        if ((description = element.getAttribute(DESCRIPTION)) != null) {
            boolean contains = true;
            if (description.charAt(0) == '!') {
                description = description.substring(1, description.length());
                contains = false;
            }
            filter.setContains(contains);
            filter.setDescription(description);
        }
        if ((severityValue = this.getSeverityValue(element)) > 0) {
            filter.setSelectBySeverity(true);
            filter.setSeverity(severityValue);
        } else {
            filter.setSelectBySeverity(false);
        }
        ArrayList<MarkerType> selectedTypes = new ArrayList<MarkerType>();
        IConfigurationElement[] types = element.getChildren(SELECTED_TYPE);
        int j = 0;
        while (j < types.length) {
            String markerId = types[j].getAttribute(MARKER_ID);
            if (markerId != null) {
                MarkerType type = filter.getMarkerType(markerId);
                if (type == null) {
                    Status status = new Status(2, "org.eclipse.ui.ide", 2, MarkerMessages.ProblemFilterRegistry_nullType, null);
                    IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                } else {
                    selectedTypes.add(type);
                }
            }
            ++j;
        }
        if (selectedTypes.size() > 0) {
            filter.setSelectedTypes(selectedTypes);
        }
        return filter;
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        ArrayList<Object> removedGroups = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ProblemFilter) {
                this.registeredFilters.remove(objects[i]);
            }
            if (objects[i] instanceof FieldMarkerGroup) {
                this.markerGroups.remove(((FieldMarkerGroup)objects[i]).getId());
                removedGroups.add(objects[i]);
            }
            if (objects[i] instanceof MarkerGroupingEntry) {
                MarkerGroupingEntry entry = (MarkerGroupingEntry)objects[i];
                entry.getMarkerGroup().remove(entry);
                this.markerGroupingEntries.remove(entry.getId());
            }
            if (objects[i] instanceof String) {
                this.removeValues(objects[i], this.categories);
            }
            ++i;
        }
        Iterator entriesIterator = this.markerGroupingEntries.keySet().iterator();
        ArrayList<String> removedKeys = new ArrayList<String>();
        while (entriesIterator.hasNext()) {
            String entryId = (String)entriesIterator.next();
            MarkerGroupingEntry entry = (MarkerGroupingEntry)this.markerGroupingEntries.get(entryId);
            if (!removedGroups.contains(entry.getMarkerGroup())) continue;
            removedKeys.add(entryId);
        }
        Iterator removedIterator = removedKeys.iterator();
        while (removedIterator.hasNext()) {
            this.markerGroupingEntries.remove(removedIterator.next());
        }
    }

    private void removeValues(Object value, HashMap cache) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : cache.keySet()) {
            Object next = cache.get(key);
            if (next instanceof Collection) {
                Collection collection = (Collection)next;
                if (!collection.contains(value)) continue;
                collection.remove(value);
                if (!collection.isEmpty()) break;
                keysToRemove.add(key);
                break;
            }
            if (!cache.get(key).equals(value)) continue;
            keysToRemove.add(key);
        }
        Iterator keysToRemoveIterator = keysToRemove.iterator();
        while (keysToRemoveIterator.hasNext()) {
            cache.remove(keysToRemoveIterator.next());
        }
    }

    public String getCategory(IMarker marker) {
        try {
            return this.getCategory(marker.getType());
        }
        catch (CoreException e) {
            Util.log(e);
            return null;
        }
    }

    public String getCategory(String markerType) {
        if (this.categories.containsKey(markerType)) {
            return (String)this.categories.get(markerType);
        }
        return null;
    }

    public TableSorter getSorterFor(String type) {
        if (this.hierarchyOrders.containsKey(type)) {
            return (TableSorter)this.hierarchyOrders.get(type);
        }
        TableSorter sorter = this.findSorterInChildren(type, this.getRootType());
        if (sorter == null) {
            return new TableSorter(new IField[0], new int[0], new int[0]);
        }
        return sorter;
    }

    private MarkerType getRootType() {
        if (this.rootType == null) {
            this.rootType = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.problemmarker");
        }
        return this.rootType;
    }

    private TableSorter findSorterInChildren(String typeName, MarkerType type) {
        MarkerType[] types = type.getAllSubTypes();
        TableSorter defaultSorter = null;
        if (this.hierarchyOrders.containsKey(type.getId())) {
            defaultSorter = (TableSorter)this.hierarchyOrders.get(type.getId());
        }
        int i = 0;
        while (i < types.length) {
            MarkerType[] subtypes = types[i].getAllSubTypes();
            int j = 0;
            while (j < subtypes.length) {
                TableSorter sorter = this.findSorterInChildren(typeName, subtypes[j]);
                if (sorter != null) {
                    return sorter;
                }
                ++j;
            }
            ++i;
        }
        return defaultSorter;
    }

    public Collection getMarkerGroups() {
        return this.markerGroups.values();
    }

    public IField getDefaultGroup() {
        return (IField)this.markerGroups.get(SEVERITY_ID);
    }
}

