/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.internal.ide.model.WorkingSetResourceMapping;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkingSetAdapterFactory
implements IAdapterFactory {
    private IContributorResourceAdapter2 contributorResourceAdapter = new ContributorResourceAdapter();
    private IWorkbenchAdapter workbenchAdapter = new WorkbenchAdapter();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IWorkingSet) {
            if (adapterType == IContributorResourceAdapter.class) {
                return this.contributorResourceAdapter;
            }
            if (adapterType == IWorkbenchAdapter.class) {
                return this.workbenchAdapter;
            }
            if (adapterType == ResourceMapping.class) {
                IWorkingSet workingSet = (IWorkingSet)adaptableObject;
                IAdaptable[] elements = workingSet.getElements();
                ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
                int i = 0;
                while (i < elements.length) {
                    IAdaptable element = elements[i];
                    ResourceMapping mapping = WorkingSetAdapterFactory.getResourceMapping(element);
                    if (mapping != null) {
                        result.add(mapping);
                    }
                    ++i;
                }
                if (!result.isEmpty()) {
                    return new WorkingSetResourceMapping(workingSet);
                }
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IContributorResourceAdapter2.class, IWorkbenchAdapter.class, ResourceMapping.class};
    }

    static ResourceMapping getResourceMapping(Object o) {
        Object mapping = WorkingSetAdapterFactory.internalGetAdapter(o, ResourceMapping.class);
        if (mapping instanceof ResourceMapping) {
            return (ResourceMapping)mapping;
        }
        Object resource = WorkingSetAdapterFactory.internalGetAdapter(o, IResource.class);
        if (resource != null && (mapping = WorkingSetAdapterFactory.internalGetAdapter(resource, ResourceMapping.class)) instanceof ResourceMapping) {
            return (ResourceMapping)mapping;
        }
        return null;
    }

    static ResourceMapping getContributedResourceMapping(IAdaptable element) {
        Object resourceAdapter = WorkingSetAdapterFactory.internalGetAdapter(element, IContributorResourceAdapter.class);
        if (resourceAdapter != null) {
            IResource resource;
            IContributorResourceAdapter2 mappingAdapter;
            Object mapping;
            if (resourceAdapter instanceof IContributorResourceAdapter2 && (mapping = (mappingAdapter = (IContributorResourceAdapter2)resourceAdapter).getAdaptedResourceMapping(element)) != null) {
                return mapping;
            }
            if (resourceAdapter instanceof IContributorResourceAdapter && (resource = ((IContributorResourceAdapter)resourceAdapter).getAdaptedResource(element)) != null && (mapping = WorkingSetAdapterFactory.internalGetAdapter(resource, ResourceMapping.class)) instanceof ResourceMapping) {
                return mapping;
            }
        }
        return null;
    }

    static Object internalGetAdapter(Object o, Class adapter) {
        IAdaptable element;
        Object adapted;
        if (o instanceof IAdaptable && (adapted = (element = (IAdaptable)o).getAdapter(adapter)) != null) {
            return adapted;
        }
        return Platform.getAdapterManager().getAdapter(o, adapter);
    }

    class ContributorResourceAdapter
    implements IContributorResourceAdapter2 {
        ContributorResourceAdapter() {
        }

        public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
            if (adaptable instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)adaptable;
                IAdaptable[] elements = workingSet.getElements();
                ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
                int i = 0;
                while (i < elements.length) {
                    IAdaptable element = elements[i];
                    ResourceMapping mapping = WorkingSetAdapterFactory.getContributedResourceMapping(element);
                    if (mapping == null) {
                        mapping = WorkingSetAdapterFactory.getResourceMapping(element);
                    }
                    if (mapping != null) {
                        result.add(mapping);
                    }
                    ++i;
                }
                if (!result.isEmpty()) {
                    return new WorkingSetResourceMapping(workingSet);
                }
            }
            return null;
        }

        public IResource getAdaptedResource(IAdaptable adaptable) {
            return null;
        }
    }

    class WorkbenchAdapter
    implements IWorkbenchAdapter {
        WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            if (o instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)o;
                return set.getElements();
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object o) {
            if (o instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)o;
                return set.getImage();
            }
            return null;
        }

        public String getLabel(Object o) {
            if (o instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)o;
                return set.getLabel();
            }
            return null;
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

