/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.dialogs.OpenResourceDialog;

public final class OpenResourceHandler
extends Action
implements IHandler,
IWorkbenchWindowActionDelegate {
    private static final String PARAM_ID_FILE_PATH = "filePath";
    private transient ListenerList listenerList = null;

    public OpenResourceHandler() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_workspace_file_action_context");
    }

    public final void addHandlerListener(IHandlerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public final void dispose() {
        this.listenerList = null;
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IFile file;
        if (event.getParameter(PARAM_ID_FILE_PATH) == null) {
            file = this.queryFileResource();
        } else {
            IResource resource = (IResource)event.getObjectParameterForExecution(PARAM_ID_FILE_PATH);
            if (!(resource instanceof IFile)) {
                throw new ExecutionException("filePath parameter must identify a file");
            }
            file = (IFile)resource;
        }
        if (file == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            throw new ExecutionException("no active workbench window");
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            throw new ExecutionException("no active workbench page");
        }
        try {
            IDE.openEditor(page, file, true);
        }
        catch (PartInitException e) {
            throw new ExecutionException("error opening file in editor", (Throwable)e);
        }
        return null;
    }

    public final void init(IWorkbenchWindow window) {
    }

    private final IFile queryFileResource() {
        IWorkspaceRoot input;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell parent = window.getShell();
        OpenResourceDialog dialog = new OpenResourceDialog(parent, (IContainer)(input = ResourcesPlugin.getWorkspace().getRoot()), 1);
        int resultCode = dialog.open();
        if (resultCode != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IFile)) {
            return null;
        }
        return (IFile)result[0];
    }

    public final void removeHandlerListener(IHandlerListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    public final void run(IAction action) {
        try {
            this.execute(new ExecutionEvent());
        }
        catch (ExecutionException executionException) {}
    }

    public final void selectionChanged(IAction action, ISelection selection) {
    }
}

