/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.dialogs.InternalErrorDialog;

public final class IDEExceptionHandler {
    private int exceptionCount = 0;
    private InternalErrorDialog dialog;
    private Shell defaultParent = new Shell();
    private boolean closing = false;
    private IWorkbenchConfigurer workbenchConfigurer;
    private static String MSG_OutOfMemoryError = IDEWorkbenchMessages.FatalError_OutOfMemoryError;
    private static String MSG_StackOverflowError = IDEWorkbenchMessages.FatalError_StackOverflowError;
    private static String MSG_VirtualMachineError = IDEWorkbenchMessages.FatalError_VirtualMachineError;
    private static String MSG_SWTError = IDEWorkbenchMessages.FatalError_SWTError;
    private static String MSG_FATAL_ERROR = IDEWorkbenchMessages.FatalError;
    private static String MSG_FATAL_ERROR_Recursive = IDEWorkbenchMessages.FatalError_RecursiveError;
    private static String MSG_FATAL_ERROR_RecursiveTitle = IDEWorkbenchMessages.Internal_error;

    public IDEExceptionHandler(IWorkbenchConfigurer configurer) {
        this.workbenchConfigurer = configurer;
    }

    public void handleException(Throwable t) {
        try {
            ++this.exceptionCount;
            if (this.exceptionCount > 1) {
                if (this.closing) {
                    return;
                }
                Shell parent = this.defaultParent;
                if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                    parent = this.dialog.getShell();
                }
                MessageBox box = new MessageBox(parent, 131265);
                box.setText(MSG_FATAL_ERROR_RecursiveTitle);
                box.setMessage(MessageFormat.format((String)MSG_FATAL_ERROR, (Object[])new Object[]{MSG_FATAL_ERROR_Recursive}));
                int result = box.open();
                if (result == 64) {
                    this.closeWorkbench();
                }
            } else if (this.openQuestionDialog(t)) {
                this.closeWorkbench();
            }
        }
        finally {
            --this.exceptionCount;
        }
    }

    private void closeWorkbench() {
        if (this.closing) {
            return;
        }
        try {
            this.closing = true;
            if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                this.dialog.close();
            }
            this.workbenchConfigurer.emergencyClose();
        }
        catch (RuntimeException re) {
            System.err.println("Fatal runtime error happened during workbench emergency close.");
            re.printStackTrace();
            throw re;
        }
        catch (Error e) {
            System.err.println("Fatal error happened during workbench emergency close.");
            e.printStackTrace();
            throw e;
        }
    }

    private boolean openQuestionDialog(Throwable internalError) {
        String msg;
        block9: {
            try {
                msg = null;
                if (internalError instanceof OutOfMemoryError) {
                    msg = MSG_OutOfMemoryError;
                    break block9;
                }
                if (internalError instanceof StackOverflowError) {
                    msg = MSG_StackOverflowError;
                    break block9;
                }
                if (internalError instanceof VirtualMachineError) {
                    msg = MSG_VirtualMachineError;
                    break block9;
                }
                if (internalError instanceof SWTError) {
                    msg = MSG_SWTError;
                    break block9;
                }
                msg = internalError.getMessage() == null ? IDEWorkbenchMessages.InternalErrorNoArg : NLS.bind((String)IDEWorkbenchMessages.InternalErrorOneArg, (Object)internalError.getMessage());
                if (Policy.DEBUG_OPEN_ERROR_DIALOG) {
                    return this.openQuestion(null, IDEWorkbenchMessages.Internal_error, msg, internalError, 1);
                }
                return false;
            }
            catch (Throwable th) {
                System.err.println("Error while informing user about event loop exception:");
                internalError.printStackTrace();
                System.err.println("Dialog open exception:");
                th.printStackTrace();
                return true;
            }
        }
        Throwable detail = internalError;
        if (!Policy.DEBUG_OPEN_ERROR_DIALOG) {
            detail = null;
        }
        return InternalErrorDialog.openQuestion(null, IDEWorkbenchMessages.Internal_error, MessageFormat.format((String)MSG_FATAL_ERROR, (Object[])new Object[]{msg}), detail, 1);
    }

    private boolean openQuestion(Shell parent, String title, String message, Throwable detail, int defaultIndex) {
        String[] labels = detail == null ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        this.dialog = new InternalErrorDialog(parent, title, null, message, detail, 3, labels, defaultIndex);
        if (detail != null) {
            this.dialog.setDetailButton(2);
        }
        boolean result = this.dialog.open() == 0;
        this.dialog = null;
        return result;
    }
}

