/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.css.core.internal.metamodelimpl;

import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMStyleSheet;

class CSSMMStyleSheetImpl extends CSSMMNodeImpl implements CSSMMStyleSheet {


	public CSSMMStyleSheetImpl() {
		super();
	}

	public String getType() {
		return TYPE_STYLE_SHEET;
	}

	public String getName() {
		return NAME_NOT_AVAILABLE;
	}

	/*
	 * @see CSSMMNodeImpl#canContain(CSSMMNode)
	 */
	boolean canContain(CSSMMNode child) {
		if (child == null) {
			return false;
		}
		String type = child.getType();
		return (type == TYPE_CHARSET_RULE || type == TYPE_IMPORT_RULE || type == TYPE_PAGE_RULE || type == TYPE_MEDIA_RULE || type == TYPE_FONT_FACE_RULE || type == TYPE_STYLE_RULE);
	}

	short getError() {
		if (getChildCount() == 0) {
			return MetaModelErrors.ERROR_NO_CHILD;
		}
		else {
			return MetaModelErrors.NO_ERROR;
		}
	}
}