/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.resources.ResourceTimestampMappings;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ComponentImplManager {
    private static final String NO_FACETS = "NONE";
    private static final String COMPONENT_IMPL_EXTENSION_POINT = "componentimpl";
    private static final String TAG_COMPONENT_IMPL = "componentimpl";
    private static final String ATT_TYPE = "typeID";
    private static final String ATT_CLASS = "class";
    private static final ComponentImplManager instance = new ComponentImplManager();
    private static final Object LOAD_FAILED = new Object();
    private final Map descriptors = new Hashtable();
    private final Map instances = new Hashtable();
    private final ResourceTimestampMappings factoryMap = new ResourceTimestampMappings();

    public static ComponentImplManager instance() {
        return instance;
    }

    public ComponentImplManager() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ModulecorePlugin.logError(0, exception.getMessage(), exception);
            }

            public void run() throws Exception {
                new ComponentImplRegistryReader().readRegistry();
            }
        });
    }

    private IComponentImplFactory getComponentImplFactory(String typeID) {
        ComponentImplDescriptor descriptor = (ComponentImplDescriptor)this.descriptors.get(typeID);
        IComponentImplFactory factory = null;
        if (descriptor != null && (factory = (IComponentImplFactory)this.instances.get(descriptor)) == null) {
            factory = descriptor.createFactory();
            if (factory != null) {
                this.instances.put(descriptor, factory);
            } else {
                this.descriptors.remove(descriptor);
            }
        }
        return factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IComponentImplFactory findFactoryForProject(IProject project) {
        try {
            IFacetedProject facetedProject;
            IComponentImplFactory factory = null;
            if (!this.factoryMap.hasChanged((IResource)project)) {
                if (this.factoryMap.hasCacheError((IResource)project)) {
                    return null;
                }
                if (this.factoryMap.hasCacheData((IResource)project)) {
                    return (IComponentImplFactory)this.factoryMap.getData((IResource)project);
                }
            }
            if ((facetedProject = ProjectFacetsManager.create((IProject)project)) == null) {
                factory = this.getComponentImplFactory(NO_FACETS);
                this.factoryMap.mark((IResource)project, factory);
                return factory;
            }
            Iterator keys = this.descriptors.keySet().iterator();
            while (true) {
                if (!keys.hasNext()) {
                    return null;
                }
                String typeID = (String)keys.next();
                if (typeID.equals(NO_FACETS)) continue;
                try {
                    IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
                    if (projectFacet == null || !facetedProject.hasProjectFacet(projectFacet) || (factory = this.getComponentImplFactory(typeID)) == null) continue;
                    this.factoryMap.mark((IResource)project, factory);
                    return factory;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            ModulecorePlugin.logError(0, "Returning null factory for project: " + project, e);
            this.factoryMap.markError((IResource)project);
        }
        return null;
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        try {
            IComponentImplFactory factory = this.findFactoryForProject(aProject);
            if (factory != null) {
                return factory.createFolder(aProject, aRuntimePath);
            }
        }
        catch (Exception exception) {}
        return new VirtualFolder(aProject, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject project) {
        try {
            IComponentImplFactory factory = this.findFactoryForProject(project);
            if (factory != null) {
                return factory.createComponent(project);
            }
        }
        catch (Exception exception) {}
        if (!ModuleCoreNature.isFlexibleProject(project)) {
            return null;
        }
        return new VirtualComponent(project, (IPath)new Path("/"));
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String aComponentName) {
        try {
            IComponentImplFactory factory = this.findFactoryForProject(aProject);
            if (factory != null) {
                return factory.createArchiveComponent(aProject, aComponentName, (IPath)new Path("/"));
            }
        }
        catch (Exception exception) {}
        return new VirtualArchiveComponent(aProject, aComponentName, (IPath)new Path("/"));
    }

    private class ComponentImplDescriptor {
        private final IConfigurationElement element;
        private final String type;

        public ComponentImplDescriptor(IConfigurationElement configElement) {
            this.element = configElement;
            this.type = this.element.getAttribute(ComponentImplManager.ATT_TYPE);
        }

        public IComponentImplFactory createFactory() {
            IComponentImplFactory[] factory = new IComponentImplFactory[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, factory){
                final /* synthetic */ ComponentImplDescriptor this$1;
                private final /* synthetic */ IComponentImplFactory[] val$factory;
                {
                    this.this$1 = componentImplDescriptor;
                    this.val$factory = iComponentImplFactoryArray;
                }

                public void handleException(Throwable exception) {
                    ModulecorePlugin.logError(0, exception.getMessage(), exception);
                }

                public void run() throws Exception {
                    this.val$factory[0] = (IComponentImplFactory)ComponentImplDescriptor.access$0(this.this$1).createExecutableExtension("class");
                }
            });
            return factory[0];
        }

        public String getType() {
            return this.type;
        }

        static /* synthetic */ IConfigurationElement access$0(ComponentImplDescriptor componentImplDescriptor) {
            return componentImplDescriptor.element;
        }
    }

    private class ComponentImplRegistryReader
    extends RegistryReader {
        public ComponentImplRegistryReader() {
            super("org.eclipse.wst.common.modulecore", "componentimpl");
        }

        public boolean readElement(IConfigurationElement element) {
            if ("componentimpl".equals(element.getName())) {
                String type = element.getAttribute(ComponentImplManager.ATT_TYPE);
                if (type != null) {
                    ComponentImplManager.this.descriptors.put(element.getAttribute(ComponentImplManager.ATT_TYPE), new ComponentImplDescriptor(element));
                } else {
                    ModulecorePlugin.logError(0, "No type attribute is specified for org.eclipse.wst.common.modulecore.componentimpl extension in " + element.getDeclaringExtension().getNamespaceIdentifier(), null);
                }
                return true;
            }
            return false;
        }
    }
}

