/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtension;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensionReader;

public class ComposedExtendedOperationHolder {
    private ArrayList preOps = null;
    private ArrayList postOps = null;

    protected ComposedExtendedOperationHolder() {
    }

    public static ComposedExtendedOperationHolder createExtendedOperationHolder(String operationID) {
        Collection extensions = (Collection)OperationExtensionReader.getExtensionPoints().get(operationID);
        if (extensions == null) {
            return null;
        }
        ComposedExtendedOperationHolder extOperationHolder = new ComposedExtendedOperationHolder();
        Object preOp = null;
        Object postOp = null;
        OperationExtension currentExt = null;
        Iterator iterator = extensions.iterator();
        while (iterator.hasNext()) {
            currentExt = (OperationExtension)iterator.next();
            if (!EnablementManager.INSTANCE.getIdentifier(currentExt.getExtensionId(), null).isEnabled()) continue;
            try {
                preOp = currentExt.getPreOperation();
                if (preOp != null) {
                    extOperationHolder.addPreOperation(preOp);
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            try {
                postOp = currentExt.getPostOperation();
                if (postOp == null) continue;
                extOperationHolder.addPostOperation(postOp);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        return extOperationHolder;
    }

    protected void addPreOperation(Object preOperation) {
        if (this.preOps == null) {
            this.preOps = new ArrayList();
        }
        this.preOps.add(preOperation);
    }

    protected void addPostOperation(Object postOperation) {
        if (this.postOps == null) {
            this.postOps = new ArrayList();
        }
        this.postOps.add(postOperation);
    }

    public boolean hasPreOps() {
        return this.preOps != null;
    }

    public boolean hasPostOps() {
        return this.postOps != null;
    }

    public ArrayList getPostOps() {
        return this.postOps;
    }

    public ArrayList getPreOps() {
        return this.preOps;
    }
}

