/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal.cactus;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jst.server.ui.internal.JavaServerUIPlugin;
import org.eclipse.jst.server.ui.internal.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.osgi.framework.Bundle;

public class CactusAddLibrariesProposal
implements IJavaCompletionProposal {
    private final IInvocationContext fContext;

    public CactusAddLibrariesProposal(IInvocationContext context) {
        this.fContext = context;
    }

    public int getRelevance() {
        return 0;
    }

    public void apply(IDocument document) {
        ICompilationUnit javaFile = this.fContext.getCompilationUnit();
        CactusAddLibrariesProposal.installLibraries(javaFile.getJavaProject().getProject());
    }

    public static void installLibraries(IProject project) {
        block6: {
            try {
                Bundle bundle = Platform.getBundle((String)"org.apache.cactus");
                if (bundle == null) {
                    CactusAddLibrariesProposal.showInstallFailedDialog(Messages.CactusAddLibrariesProposal_ErrorMessageCactusBundleNotFound);
                    return;
                }
                URL cactusLibDir = FileLocator.find((Bundle)bundle, (IPath)new Path("lib"), null);
                if (cactusLibDir == null) {
                    CactusAddLibrariesProposal.showInstallFailedDialog(Messages.CactusAddLibrariesProposal_ErrorMessageInstallDirNotFound);
                    return;
                }
                URL localURL = FileLocator.toFileURL((URL)cactusLibDir);
                File sourceDirectory = new File(localURL.getPath());
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                IVirtualFolder vf = component.getRootFolder().getFolder("WEB-INF/lib");
                IContainer destinationDirectory = vf.getUnderlyingFolder();
                IFolder destinationFolder = project.getFolder(destinationDirectory.getProjectRelativePath());
                if (destinationFolder.exists()) {
                    File[] filesToCopy = sourceDirectory.listFiles();
                    String[] filesToCopyNames = new String[filesToCopy.length];
                    int i = 0;
                    while (i < filesToCopy.length) {
                        filesToCopyNames[i] = filesToCopy[i].getAbsolutePath();
                        ++i;
                    }
                    CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(JavaServerUIPlugin.getActiveWorkbenchShell());
                    operation.copyFiles(filesToCopyNames, (IContainer)destinationFolder);
                    break block6;
                }
                CactusAddLibrariesProposal.showInstallFailedDialog(Messages.CactusAddLibrariesProposal_ErrorMessageDestDirNotFound);
                return;
            }
            catch (IOException e) {
                JavaServerUIPlugin.log(e);
                CactusAddLibrariesProposal.showInstallFailedDialog(Messages.CactusAddLibrariesProposal_ErrorMessageInstallationOfLibsFailed);
            }
        }
    }

    private static void showInstallFailedDialog(String message) {
        MessageDialog.openError((Shell)JavaServerUIPlugin.getActiveWorkbenchShell(), (String)Messages.CactusAddLibrariesProposal_ErrorMessageCouldntInstallLibraries, (String)message);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }

    public String getAdditionalProposalInfo() {
        return Messages.CactusAddLibrariesProposal_AdditionalInfoAddCactusLibraries;
    }

    public String getDisplayString() {
        return Messages.CactusAddLibrariesProposal_DisplayStringAddCactusLibs;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

