/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.uml2.common.util.DerivedSubsetEObjectEList;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;

public class ClassifierOperations
extends NamespaceOperations {
    protected static final int[] GENERAL_ESUPERSETS = new int[]{25};
    static /* synthetic */ Class class$0;

    protected ClassifierOperations() {
    }

    public static boolean validateNoCyclesInGeneralization(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (classifier.allParents().contains((Object)classifier)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 20, UMLPlugin.INSTANCE.getString("_UI_Classifier_NoCyclesInGeneralization_diagnostic", ClassifierOperations.getMessageSubstitutions((Map)context, (Object)classifier)), new Object[]{classifier}));
            }
        }
        return result;
    }

    public static boolean validateSpecializeType(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator parents = classifier.parents().iterator();
        while (parents.hasNext()) {
            Classifier parent = (Classifier)parents.next();
            if (classifier.maySpecializeType(parent)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 22, UMLPlugin.INSTANCE.getString("_UI_Classifier_SpecializeType_diagnostic", ClassifierOperations.getMessageSubstitutions((Map)context, (Object)classifier, (Object)parent)), new Object[]{classifier, parent}));
        }
        return result;
    }

    public static boolean validateGeneralizationHierarchies(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateMapsToGeneralizationSet(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static EList getAllAttributes(Classifier classifier) {
        UniqueEList.FastCompare allAttributes = new UniqueEList.FastCompare();
        Iterator allFeatures = classifier.allFeatures().iterator();
        while (allFeatures.hasNext()) {
            Object feature = allFeatures.next();
            if (!(feature instanceof Property)) continue;
            allAttributes.add(feature);
        }
        return ECollections.unmodifiableEList((EList)allAttributes);
    }

    public static EList getOperations(Classifier classifier) {
        UniqueEList.FastCompare operations = new UniqueEList.FastCompare();
        Iterator features = classifier.getFeatures().iterator();
        while (features.hasNext()) {
            Object feature = features.next();
            if (!(feature instanceof Operation)) continue;
            operations.add(feature);
        }
        return ECollections.unmodifiableEList((EList)operations);
    }

    public static EList getAllOperations(Classifier classifier) {
        UniqueEList.FastCompare allOperations = new UniqueEList.FastCompare();
        Iterator allFeatures = classifier.allFeatures().iterator();
        while (allFeatures.hasNext()) {
            Object feature = allFeatures.next();
            if (!(feature instanceof Operation)) continue;
            allOperations.add(feature);
        }
        return ECollections.unmodifiableEList((EList)allOperations);
    }

    public static Operation getOperation(Classifier classifier, String name, EList parameterNames, EList parameterTypes) {
        return classifier.getOperation(name, parameterNames, parameterTypes, false);
    }

    public static Operation getOperation(Classifier classifier, String name, EList parameterNames, EList parameterTypes, boolean ignoreCase) {
        Iterator i = classifier.getOperations().iterator();
        block0: while (i.hasNext()) {
            Operation ownedOperation = (Operation)i.next();
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(ownedOperation.getName()) : !name.equals(ownedOperation.getName()))) continue;
            EList ownedParameterList = ownedOperation.getOwnedParameters();
            int ownedParameterListSize = ownedParameterList.size();
            if (parameterNames != null && parameterNames.size() != ownedParameterListSize || parameterTypes != null && parameterTypes.size() != ownedParameterListSize) continue;
            int j = 0;
            while (j < ownedParameterListSize) {
                Parameter ownedParameter = (Parameter)ownedParameterList.get(j);
                if (parameterNames != null && (!ignoreCase ? !parameterNames.get(j).equals(ownedParameter.getName()) : !((String)parameterNames.get(j)).equalsIgnoreCase(ownedParameter.getName()))) continue block0;
                if (parameterTypes != null && !parameterTypes.get(j).equals(ownedParameter.getType())) continue block0;
                ++j;
            }
            return ownedOperation;
        }
        return null;
    }

    public static EList getUsedInterfaces(Classifier classifier) {
        return ClassifierOperations.getUsedInterfaces(classifier, (EList)new UniqueEList.FastCompare());
    }

    public static EList getAllUsedInterfaces(Classifier classifier) {
        return ClassifierOperations.getAllUsedInterfaces(classifier, (EList)new UniqueEList.FastCompare());
    }

    public static boolean maySpecializeType(Classifier classifier, Classifier c) {
        return c.eClass().isSuperTypeOf(classifier.eClass());
    }

    public static EList getGenerals(Classifier classifier) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.uml2.uml.Classifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new GeneralEList(clazz, (InternalEObject)classifier, 30, GENERAL_ESUPERSETS);
    }

    public static EList getInheritedMembers(Classifier classifier) {
        UniqueEList.FastCompare inheritedMembers = new UniqueEList.FastCompare();
        Iterator parents = classifier.parents().iterator();
        while (parents.hasNext()) {
            inheritedMembers.addAll((Collection)((Classifier)parents.next()).inheritableMembers(classifier));
        }
        EList inherit = classifier.inherit((EList)inheritedMembers);
        return new UnionEObjectEList((InternalEObject)classifier, (EStructuralFeature)UMLPackage.Literals.CLASSIFIER__INHERITED_MEMBER, inherit.size(), inherit.toArray());
    }

    public static EList allFeatures(Classifier classifier) {
        UniqueEList.FastCompare allFeatures = new UniqueEList.FastCompare();
        Iterator members = classifier.getMembers().iterator();
        while (members.hasNext()) {
            Object member = members.next();
            if (!(member instanceof Feature)) continue;
            allFeatures.add(member);
        }
        return ECollections.unmodifiableEList((EList)allFeatures);
    }

    public static EList parents(Classifier classifier) {
        UniqueEList.FastCompare parents = new UniqueEList.FastCompare();
        Iterator generalizations = classifier.getGeneralizations().iterator();
        while (generalizations.hasNext()) {
            Classifier general = ((Generalization)generalizations.next()).getGeneral();
            if (general == null) continue;
            parents.add((Object)general);
        }
        return ECollections.unmodifiableEList((EList)parents);
    }

    public static EList inheritableMembers(Classifier classifier, Classifier c) {
        UniqueEList.FastCompare inheritableMembers = new UniqueEList.FastCompare();
        if (c == classifier || !c.allParents().contains((Object)classifier) || classifier.allParents().contains((Object)c)) {
            return inheritableMembers;
        }
        Iterator members = classifier.getMembers().iterator();
        while (members.hasNext()) {
            NamedElement member = (NamedElement)members.next();
            if (!c.hasVisibilityOf(member)) continue;
            inheritableMembers.add((Object)member);
        }
        return ECollections.unmodifiableEList((EList)inheritableMembers);
    }

    public static boolean hasVisibilityOf(Classifier classifier, NamedElement n) {
        Iterator allParents = classifier.allParents().iterator();
        while (allParents.hasNext()) {
            Classifier parent = (Classifier)allParents.next();
            if (parent == classifier || !parent.getMembers().contains((Object)n)) continue;
            return n.getVisibility() != VisibilityKind.PRIVATE_LITERAL;
        }
        return false;
    }

    public static boolean conformsTo(Classifier classifier, Classifier other) {
        return classifier == other || classifier.allParents().contains((Object)other);
    }

    public static EList inherit(Classifier classifier, EList inhs) {
        return ECollections.unmodifiableEList((EList)inhs);
    }

    protected static EList allParents(Classifier classifier, EList allParents) {
        Iterator parents = classifier.parents().iterator();
        while (parents.hasNext()) {
            Classifier parent = (Classifier)parents.next();
            if (!allParents.add((Object)parent)) continue;
            ClassifierOperations.allParents(parent, allParents);
        }
        return allParents;
    }

    public static EList allParents(Classifier classifier) {
        return ECollections.unmodifiableEList((EList)ClassifierOperations.allParents(classifier, (EList)new UniqueEList.FastCompare()));
    }

    public static boolean isTemplate(Classifier classifier) {
        if (classifier.getOwnedTemplateSignature() == null) {
            Iterator allParents = classifier.allParents().iterator();
            while (allParents.hasNext()) {
                if (((Classifier)allParents.next()).getOwnedTemplateSignature() == null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected static EList getUsedInterfaces(Classifier classifier, EList usedInterfaces) {
        Iterator clientDependencies = classifier.getClientDependencies().iterator();
        while (clientDependencies.hasNext()) {
            Dependency dependency = (Dependency)clientDependencies.next();
            if (!(dependency instanceof Usage)) continue;
            Iterator suppliers = dependency.getSuppliers().iterator();
            while (suppliers.hasNext()) {
                Object supplier = suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                usedInterfaces.add(supplier);
            }
        }
        return usedInterfaces;
    }

    protected static EList getAllUsedInterfaces(Classifier classifier, EList allUsedInterfaces) {
        ClassifierOperations.getUsedInterfaces(classifier, allUsedInterfaces);
        Iterator allParents = classifier.allParents().iterator();
        while (allParents.hasNext()) {
            ClassifierOperations.getUsedInterfaces((Classifier)allParents.next(), allUsedInterfaces);
        }
        return allUsedInterfaces;
    }

    protected static class GeneralEList
    extends DerivedSubsetEObjectEList {
        protected GeneralEList(Class dataClass, InternalEObject owner, int featureID, int[] sourceFeatureIDs) {
            super(dataClass, owner, featureID, sourceFeatureIDs);
        }

        public List basicList() {
            return new GeneralEList(this, this.dataClass, this.owner, this.featureID, this.sourceFeatureIDs){
                final /* synthetic */ GeneralEList this$1;
                {
                    this.this$1 = generalEList;
                    super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                }

                public ListIterator listIterator(int index) {
                    return this.basicListIterator(index);
                }
            };
        }

        protected boolean isIncluded(EStructuralFeature feature) {
            return false;
        }

        protected Object derive(Object object) {
            return ((Generalization)object).getGeneral();
        }

        protected Object validate(int index, Object object) {
            Generalization generalization = UMLFactory.eINSTANCE.createGeneralization();
            generalization.setGeneral((Classifier)super.validate(index, object));
            return generalization;
        }
    }
}

