/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.annotations.AnnotateBlock;
import org.tigris.subversion.subclipse.ui.annotations.RemoteAnnotationEditorInput;
import org.tigris.subversion.subclipse.ui.history.SVNHistoryPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class AnnotateView
extends ViewPart
implements ISelectionChangedListener {
    ITextEditor editor;
    IHistoryView historyView;
    IWorkbenchPage page;
    ListViewer viewer;
    IDocument document;
    Collection svnAnnotateBlocks;
    ISVNRemoteFile svnFile;
    InputStream contents;
    IStructuredSelection previousListSelection;
    ITextSelection previousTextSelection;
    boolean lastSelectionWasText = false;
    public static final String VIEW_ID = "org.tigris.subversion.subclipse.ui.annotations.AnnotateView";
    private Composite top;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (AnnotateView.this.editor != null && part == AnnotateView.this.editor) {
                AnnotateView.this.disconnect();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public void createPartControl(Composite parent) {
        this.top = parent;
        Label label = new Label(this.top, 64);
        label.setText(Policy.bind("SVNAnnotateView.viewInstructions"));
        label.setLayoutData((Object)new GridData(1808));
        this.top.layout();
    }

    public void showAnnotations(ISVNRemoteFile svnFile, Collection svnAnnotateBlocks, InputStream contents) throws PartInitException {
        this.showAnnotations(svnFile, svnAnnotateBlocks, contents, true);
    }

    public void showAnnotations(ISVNRemoteFile svnFile, Collection svnAnnotateBlocks, InputStream contents, boolean useHistoryView) throws PartInitException {
        this.disconnect();
        Control[] oldChildren = this.top.getChildren();
        if (oldChildren != null) {
            int i = 0;
            while (i < oldChildren.length) {
                oldChildren[i].dispose();
                ++i;
            }
        }
        this.viewer = new ListViewer(this.top, 772);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.tigris.subversion.subclipse.ui.annotations_view_context");
        this.top.layout();
        this.svnFile = svnFile;
        this.contents = contents;
        this.svnAnnotateBlocks = svnAnnotateBlocks;
        this.page = SVNUIPlugin.getActivePage();
        this.viewer.setInput((Object)svnAnnotateBlocks);
        this.editor = (ITextEditor)this.openEditor();
        IDocumentProvider provider = this.editor.getDocumentProvider();
        this.document = provider.getDocument((Object)this.editor.getEditorInput());
        this.setPartName(Policy.bind("SVNAnnotateView.showFileAnnotation", new Object[]{svnFile.getName()}));
        this.setTitleToolTip(svnFile.getName());
        if (!useHistoryView) {
            return;
        }
        this.historyView = (IHistoryView)this.page.showView("org.eclipse.team.ui.GenericHistoryView");
        if (this.historyView != null) {
            this.historyView.showHistoryFor((Object)svnFile);
        }
    }

    protected void disconnect() {
        if (this.editor != null) {
            if (this.editor.getSelectionProvider() instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.editor.getSelectionProvider()).removePostSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.editor.getSite().getPage().removePartListener(this.partListener);
            this.editor = null;
            this.document = null;
        }
    }

    public static AnnotateView openInActivePerspective() throws PartInitException {
        return (AnnotateView)SVNUIPlugin.getActivePage().showView(VIEW_ID);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            this.listSelectionChanged((IStructuredSelection)event.getSelection());
        } else if (event.getSelection() instanceof ITextSelection) {
            this.textSelectionChanged((ITextSelection)event.getSelection());
        }
    }

    public void dispose() {
        this.disconnect();
    }

    private void textSelectionChanged(ITextSelection selection) {
        this.lastSelectionWasText = true;
        AnnotateBlock match = null;
        Iterator iterator = this.svnAnnotateBlocks.iterator();
        while (iterator.hasNext()) {
            AnnotateBlock block = (AnnotateBlock)iterator.next();
            if (!block.contains(selection.getStartLine())) continue;
            match = block;
            break;
        }
        if (match == null) {
            return;
        }
        StructuredSelection listSelection = new StructuredSelection(match);
        this.viewer.setSelection((ISelection)listSelection, true);
    }

    private void listSelectionChanged(IStructuredSelection selection) {
        ISelectionProvider selectionProvider;
        if (this.editor == null || this.editor.getSelectionProvider() == null) {
            try {
                this.contents.reset();
                this.showAnnotations(this.svnFile, this.svnAnnotateBlocks, this.contents, false);
            }
            catch (PartInitException partInitException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        if ((selectionProvider = this.editor.getSelectionProvider()) == null) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selectionProvider.getSelection();
        AnnotateBlock listSelection = null;
        try {
            listSelection = (AnnotateBlock)selection.getFirstElement();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (listSelection == null) {
            return;
        }
        if (textSelection.getStartLine() == listSelection.getStartLine() && textSelection.getEndLine() == listSelection.getEndLine() && selection.equals(this.previousListSelection)) {
            return;
        }
        if (!this.lastSelectionWasText) {
            try {
                int start = this.document.getLineOffset(listSelection.getStartLine());
                int end = this.document.getLineOffset(listSelection.getEndLine() + 1);
                this.editor.selectAndReveal(start, end - start);
                if (this.editor != null && !this.page.isPartVisible((IWorkbenchPart)this.editor)) {
                    this.page.activate((IWorkbenchPart)this.editor);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (this.historyView != null) {
            SVNHistoryPage page = (SVNHistoryPage)this.historyView.getHistoryPage();
            page.selectRevision(new SVNRevision.Number(listSelection.getRevision()));
        }
        this.lastSelectionWasText = false;
    }

    private IEditorPart openEditor() throws PartInitException {
        IEditorPart part;
        String id;
        IEditorRegistry registry = SVNUIPlugin.getPlugin().getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(this.svnFile.getName());
        if (descriptor == null || !(descriptor instanceof EditorDescriptor) || !((EditorDescriptor)descriptor).isInternal()) {
            id = "org.eclipse.ui.DefaultTextEditor";
        } else {
            try {
                Object obj = IDEWorkbenchPlugin.createExtension((IConfigurationElement)((EditorDescriptor)descriptor).getConfigurationElement(), (String)"class");
                id = obj instanceof ITextEditor ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
            }
            catch (CoreException coreException) {
                id = "org.eclipse.ui.DefaultTextEditor";
            }
        }
        if (this.editor != null && this.editor instanceof IReusableEditor && this.page.isPartVisible((IWorkbenchPart)this.editor) && this.editor.getSite().getId().equals(id)) {
            ((IReusableEditor)this.editor).setInput((IEditorInput)new RemoteAnnotationEditorInput(this.svnFile, this.contents));
            part = this.editor;
        } else {
            if (this.editor != null) {
                this.page.closeEditor((IEditorPart)this.editor, false);
                this.editor = null;
            }
            part = this.page.openEditor((IEditorInput)new RemoteAnnotationEditorInput(this.svnFile, this.contents), id);
        }
        ITextEditor editor = (ITextEditor)part;
        if (editor.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)editor.getSelectionProvider()).addPostSelectionChangedListener((ISelectionChangedListener)this);
        }
        part.getSite().getPage().addPartListener(this.partListener);
        return part;
    }

    public void setFocus() {
    }
}

