/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.testunit.ITestRunListener;
import org.rubypeople.rdt.testunit.TestunitPlugin;
import org.rubypeople.rdt.testunit.views.ITestRunListener2;
import org.rubypeople.rdt.testunit.views.ITestRunListener3;

public class RemoteTestRunnerClient {
    ProcessingState fDefaultState = new DefaultProcessingState();
    ProcessingState fTraceState = new TraceProcessingState();
    ProcessingState fExpectedState = new ExpectedProcessingState();
    ProcessingState fActualState = new ActualProcessingState();
    ProcessingState fRerunState = new RerunTraceProcessingState();
    ProcessingState fCurrentState = this.fDefaultState;
    private ITestRunListener[] fListeners;
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private int fPort = -1;
    private PrintWriter fWriter;
    private BufferedReader fBufferedReader;
    private String fVersion;
    private String fFailedTest;
    private String fFailedTestId;
    private String fFailedTrace;
    private String fExpectedResult;
    private String fActualResult;
    private String fFailedRerunTrace;
    private int fFailureKind;
    private boolean fDebug = false;

    public synchronized void startListening(ITestRunListener[] iTestRunListenerArray, int n) {
        this.fListeners = iTestRunListenerArray;
        this.fPort = n;
        ServerConnection serverConnection = new ServerConnection(n);
        serverConnection.start();
    }

    public synchronized void stopTest() {
        if (this.isRunning()) {
            this.fWriter.println(">STOP   ");
            this.fWriter.flush();
        }
    }

    private synchronized void shutDown() {
        if (this.fDebug) {
            System.out.println("shutdown " + this.fPort);
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean isRunning() {
        return this.fSocket != null;
    }

    private String readMessage(BufferedReader bufferedReader) throws IOException {
        return bufferedReader.readLine();
    }

    private void receiveMessage(String string) {
        this.fCurrentState = this.fCurrentState.readMessage(string);
    }

    private void scanOldReranMessage(String string) {
        int n = string.indexOf(" ");
        int n2 = string.indexOf(" ", n + 1);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        int n3 = 0;
        if (string4.equals("FAILURE")) {
            n3 = 2;
        } else if (string4.equals("ERROR")) {
            n3 = 1;
        }
        String string5 = "";
        if (n3 != 0) {
            string5 = this.fFailedRerunTrace;
        }
        this.notifyTestReran(String.valueOf(string2) + string3, string2, string3, n3, string5);
    }

    private void scanReranMessage(String string) {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        int n3 = string.indexOf(32, n2 + 1);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1, n3);
        String string5 = string.substring(n3 + 1);
        int n4 = 0;
        if (string5.equals("FAILURE")) {
            n4 = 2;
        } else if (string5.equals("ERROR")) {
            n4 = 1;
        }
        String string6 = "";
        if (n4 != 0) {
            string6 = this.fFailedRerunTrace;
        }
        this.notifyTestReran(string2, string3, string4, n4, string6);
    }

    private void extractFailure(String string, int n) {
        String[] stringArray = this.extractTestId(string);
        this.fFailedTestId = stringArray[0];
        this.fFailedTest = stringArray[1];
        this.fFailureKind = n;
    }

    String[] extractTestId(String string) {
        String[] stringArray = new String[2];
        if (!this.hasTestId()) {
            stringArray[0] = string;
            stringArray[1] = string;
            return stringArray;
        }
        int n = string.indexOf(44);
        stringArray[0] = string.substring(0, n);
        stringArray[1] = string.substring(n + 1, string.length());
        return stringArray;
    }

    private boolean hasTestId() {
        if (this.fVersion == null) {
            return true;
        }
        return this.fVersion.equals("v2");
    }

    private void notifyTestReran(final String string, final String string2, final String string3, final int n, final String string4) {
        int n2 = 0;
        while (n2 < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n2];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    if (iTestRunListener instanceof ITestRunListener3) {
                        ((ITestRunListener3)iTestRunListener).testReran(string, string2, string3, n, string4, RemoteTestRunnerClient.this.fExpectedResult, RemoteTestRunnerClient.this.fActualResult);
                    } else {
                        iTestRunListener.testReran(string, string2, string3, n, string4);
                    }
                }
            });
            ++n2;
        }
    }

    private void notifyTestTreeEntry(String string) {
        int n = 0;
        while (n < this.fListeners.length) {
            if (this.fListeners[n] instanceof ITestRunListener2) {
                ITestRunListener2 iTestRunListener2 = (ITestRunListener2)this.fListeners[n];
                if (!this.hasTestId()) {
                    iTestRunListener2.testTreeEntry(this.fakeTestId(string));
                } else {
                    iTestRunListener2.testTreeEntry(string);
                }
            }
            ++n;
        }
    }

    private String fakeTestId(String string) {
        int n = string.indexOf(44);
        String string2 = string.substring(0, n).trim();
        return String.valueOf(string2) + "," + string;
    }

    private void notifyTestRunStopped(final long l) {
        int n = 0;
        while (n < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    iTestRunListener.testRunStopped(l);
                }
            });
            ++n;
        }
    }

    private void testRunEnded(final long l) {
        int n = 0;
        while (n < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    iTestRunListener.testRunEnded(l);
                }
            });
            ++n;
        }
    }

    private void notifyTestEnded(final String string) {
        int n = 0;
        while (n < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    String[] stringArray = RemoteTestRunnerClient.this.extractTestId(string);
                    iTestRunListener.testEnded(stringArray[0], stringArray[1]);
                }
            });
            ++n;
        }
    }

    private void notifyTestStarted(final String string) {
        int n = 0;
        while (n < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    String[] stringArray = RemoteTestRunnerClient.this.extractTestId(string);
                    iTestRunListener.testStarted(stringArray[0], stringArray[1]);
                }
            });
            ++n;
        }
    }

    private void notifyTestRunStarted(final int n) {
        int n2 = 0;
        while (n2 < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n2];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    iTestRunListener.testRunStarted(n);
                }
            });
            ++n2;
        }
    }

    private void notifyTestFailed() {
        int n = 0;
        while (n < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    if (iTestRunListener instanceof ITestRunListener3) {
                        ((ITestRunListener3)iTestRunListener).testFailed(RemoteTestRunnerClient.this.fFailureKind, RemoteTestRunnerClient.this.fFailedTestId, RemoteTestRunnerClient.this.fFailedTest, RemoteTestRunnerClient.this.fFailedTrace, RemoteTestRunnerClient.this.fExpectedResult, RemoteTestRunnerClient.this.fActualResult);
                    } else {
                        iTestRunListener.testFailed(RemoteTestRunnerClient.this.fFailureKind, RemoteTestRunnerClient.this.fFailedTestId, RemoteTestRunnerClient.this.fFailedTest, RemoteTestRunnerClient.this.fFailedTrace);
                    }
                }
            });
            ++n;
        }
    }

    private void notifyTestRunTerminated() {
        int n = 0;
        while (n < this.fListeners.length) {
            final ITestRunListener iTestRunListener = this.fListeners[n];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    iTestRunListener.testRunTerminated();
                }
            });
            ++n;
        }
    }

    public void rerunTest(String string, String string2, String string3) {
        if (this.isRunning()) {
            this.fWriter.println(">RERUN  " + string + " " + string2 + " " + string3);
            this.fWriter.flush();
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable throwable) {
            TestunitPlugin.log(throwable);
        }
    }

    abstract class ProcessingState {
        ProcessingState() {
        }

        abstract ProcessingState readMessage(String var1);
    }

    class DefaultProcessingState
    extends ProcessingState {
        DefaultProcessingState() {
        }

        ProcessingState readMessage(String string) {
            if (string.startsWith("%TRACES ")) {
                RemoteTestRunnerClient.this.fFailedTrace = "";
                return RemoteTestRunnerClient.this.fTraceState;
            }
            if (string.startsWith("%EXPECTS")) {
                RemoteTestRunnerClient.this.fExpectedResult = null;
                return RemoteTestRunnerClient.this.fExpectedState;
            }
            if (string.startsWith("%ACTUALS")) {
                RemoteTestRunnerClient.this.fActualResult = null;
                return RemoteTestRunnerClient.this.fActualState;
            }
            if (string.startsWith("%RTRACES")) {
                RemoteTestRunnerClient.this.fFailedRerunTrace = "";
                return RemoteTestRunnerClient.this.fRerunState;
            }
            String string2 = string.substring(8);
            if (string.startsWith("%TESTC  ")) {
                int n = 0;
                int n2 = string2.indexOf(32);
                if (n2 == -1) {
                    RemoteTestRunnerClient.this.fVersion = "v1";
                    n = Integer.parseInt(string2);
                } else {
                    RemoteTestRunnerClient.this.fVersion = string2.substring(n2 + 1);
                    String string3 = string2.substring(0, n2);
                    n = Integer.parseInt(string3);
                }
                RemoteTestRunnerClient.this.notifyTestRunStarted(n);
                return this;
            }
            if (string.startsWith("%TESTS  ")) {
                RemoteTestRunnerClient.this.notifyTestStarted(string2);
                return this;
            }
            if (string.startsWith("%TESTE  ")) {
                RemoteTestRunnerClient.this.notifyTestEnded(string2);
                return this;
            }
            if (string.startsWith("%ERROR  ")) {
                RemoteTestRunnerClient.this.extractFailure(string2, 1);
                return this;
            }
            if (string.startsWith("%FAILED ")) {
                RemoteTestRunnerClient.this.extractFailure(string2, 2);
                return this;
            }
            if (string.startsWith("%RUNTIME")) {
                long l = Long.parseLong(string2);
                RemoteTestRunnerClient.this.testRunEnded(l);
                return this;
            }
            if (string.startsWith("%TSTSTP ")) {
                long l = Long.parseLong(string2);
                RemoteTestRunnerClient.this.notifyTestRunStopped(l);
                RemoteTestRunnerClient.this.shutDown();
                return this;
            }
            if (string.startsWith("%TSTTREE")) {
                RemoteTestRunnerClient.this.notifyTestTreeEntry(string2);
                return this;
            }
            if (string.startsWith("%TSTRERN")) {
                if (RemoteTestRunnerClient.this.hasTestId()) {
                    RemoteTestRunnerClient.this.scanReranMessage(string2);
                } else {
                    RemoteTestRunnerClient.this.scanOldReranMessage(string2);
                }
                return this;
            }
            return this;
        }
    }

    class TraceProcessingState
    extends ProcessingState {
        TraceProcessingState() {
        }

        ProcessingState readMessage(String string) {
            if (string.startsWith("%TRACEE ")) {
                RemoteTestRunnerClient.this.notifyTestFailed();
                RemoteTestRunnerClient.this.fFailedTrace = "";
                RemoteTestRunnerClient.this.fExpectedResult = null;
                RemoteTestRunnerClient.this.fActualResult = null;
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            RemoteTestRunnerClient remoteTestRunnerClient = RemoteTestRunnerClient.this;
            remoteTestRunnerClient.fFailedTrace = String.valueOf(remoteTestRunnerClient.fFailedTrace) + string + '\n';
            return this;
        }
    }

    class ExpectedProcessingState
    extends ProcessingState {
        ExpectedProcessingState() {
        }

        ProcessingState readMessage(String string) {
            if (string.startsWith("%EXPECTE")) {
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            if (RemoteTestRunnerClient.this.fExpectedResult == null) {
                RemoteTestRunnerClient.this.fExpectedResult = String.valueOf(string) + '\n';
            } else {
                RemoteTestRunnerClient remoteTestRunnerClient = RemoteTestRunnerClient.this;
                remoteTestRunnerClient.fExpectedResult = String.valueOf(remoteTestRunnerClient.fExpectedResult) + string + '\n';
            }
            return this;
        }
    }

    class ActualProcessingState
    extends ProcessingState {
        ActualProcessingState() {
        }

        ProcessingState readMessage(String string) {
            if (string.startsWith("%ACTUALE")) {
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            if (RemoteTestRunnerClient.this.fActualResult == null) {
                RemoteTestRunnerClient.this.fActualResult = String.valueOf(string) + '\n';
            } else {
                RemoteTestRunnerClient remoteTestRunnerClient = RemoteTestRunnerClient.this;
                remoteTestRunnerClient.fActualResult = String.valueOf(remoteTestRunnerClient.fActualResult) + string + '\n';
            }
            return this;
        }
    }

    class RerunTraceProcessingState
    extends ProcessingState {
        RerunTraceProcessingState() {
        }

        ProcessingState readMessage(String string) {
            if (string.startsWith("%RTRACEE")) {
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            RemoteTestRunnerClient remoteTestRunnerClient = RemoteTestRunnerClient.this;
            remoteTestRunnerClient.fFailedRerunTrace = String.valueOf(remoteTestRunnerClient.fFailedRerunTrace) + string + '\n';
            return this;
        }
    }

    private class ServerConnection
    extends Thread {
        int fServerPort;

        public ServerConnection(int n) {
            super("ServerConnection");
            this.fServerPort = n;
        }

        public void run() {
            try {
                String string;
                if (RemoteTestRunnerClient.this.fDebug) {
                    System.out.println("Creating server socket " + this.fServerPort);
                }
                RemoteTestRunnerClient.this.fServerSocket = new ServerSocket(this.fServerPort);
                RemoteTestRunnerClient.this.fSocket = RemoteTestRunnerClient.this.fServerSocket.accept();
                try {
                    RemoteTestRunnerClient.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteTestRunnerClient.this.fSocket.getInputStream(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    RemoteTestRunnerClient.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteTestRunnerClient.this.fSocket.getInputStream()));
                }
                try {
                    RemoteTestRunnerClient.this.fWriter = new PrintWriter((Writer)new OutputStreamWriter(RemoteTestRunnerClient.this.fSocket.getOutputStream(), "UTF-8"), true);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    RemoteTestRunnerClient.this.fWriter = new PrintWriter((Writer)new OutputStreamWriter(RemoteTestRunnerClient.this.fSocket.getOutputStream()), true);
                }
                while (RemoteTestRunnerClient.this.fBufferedReader != null && (string = RemoteTestRunnerClient.this.readMessage(RemoteTestRunnerClient.this.fBufferedReader)) != null) {
                    RemoteTestRunnerClient.this.receiveMessage(string);
                }
            }
            catch (SocketException socketException) {
                RemoteTestRunnerClient.this.notifyTestRunTerminated();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            RemoteTestRunnerClient.this.shutDown();
        }
    }
}

