/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.SocketUtil;
import org.rubypeople.rdt.internal.launching.InterpreterRunnerConfiguration;
import org.rubypeople.rdt.testunit.TestunitPlugin;

public class TestUnitRunnerConfiguration
extends InterpreterRunnerConfiguration {
    private int port = -1;

    public TestUnitRunnerConfiguration(ILaunchConfiguration iLaunchConfiguration) {
        super(iLaunchConfiguration);
    }

    public String getAbsoluteFileName() {
        return new File(this.getFileName()).getAbsolutePath();
    }

    public String getFileName() {
        return TestUnitRunnerConfiguration.getTestRunnerPath();
    }

    public String getAbsoluteFileDirectory() {
        Path path = new Path(this.getFileName());
        path = path.removeLastSegments(1);
        return path.toOSString();
    }

    public String getAbsoluteTestFileName() {
        String string = "";
        try {
            string = this.configuration.getAttribute("org.rubypeople.rdt.testunit.CONTAINER", "");
        }
        catch (CoreException coreException) {}
        Path path = new Path(string);
        path = path.removeLastSegments(1);
        return path.toOSString();
    }

    public int getPort() {
        if (this.port == -1) {
            this.port = SocketUtil.findFreePort();
        }
        return this.port;
    }

    public String getProgramArguments() {
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        try {
            string = this.configuration.getAttribute("org.rubypeople.rdt.testunit.CONTAINER", "");
            string2 = this.configuration.getAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "");
            string3 = this.configuration.getAttribute("org.rubypeople.rdt.testunit.TESTNAME", "");
        }
        catch (CoreException coreException) {
            TestunitPlugin.log(coreException);
            throw new RuntimeException("Could not get necessary attributes from the launch configuration.");
        }
        return String.valueOf(string) + " " + this.getPort() + " " + bl + " " + string2 + " " + string3;
    }

    public List renderLoadPath() {
        List list = super.renderLoadPath();
        String string = this.getAbsoluteTestFileName();
        if (string.length() != 0) {
            list.add("-I");
            list.add(string);
        }
        return list;
    }

    public static String getTestRunnerPath() {
        String string = RubyCore.getOSDirectory((Plugin)TestunitPlugin.getDefault());
        File file = new File(string, "ruby");
        if (!file.exists()) {
            throw new RuntimeException("Expected directory of RemoteTestRunner.rb does not exist: " + file.getAbsolutePath());
        }
        return String.valueOf(file.getAbsolutePath()) + File.separator + "RemoteTestRunner.rb";
    }
}

