/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.parsing;

import java.util.ArrayList;
import org.rubypeople.rdt.internal.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;

public class VariableReader
extends XmlStreamReader {
    private RubyStackFrame stackFrame;
    private RubyVariable parent;
    private ArrayList variables;
    private String exceptionMessage;
    private String exceptionType;

    public VariableReader(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
    }

    public VariableReader(AbstractReadStrategy abstractReadStrategy) {
        super(abstractReadStrategy);
    }

    public RubyVariable[] readVariables(RubyVariable rubyVariable) throws RubyProcessingException {
        return this.readVariables(rubyVariable.getStackFrame(), rubyVariable);
    }

    public RubyVariable[] readVariables(RubyStackFrame rubyStackFrame) throws RubyProcessingException {
        return this.readVariables(rubyStackFrame, null);
    }

    public RubyVariable[] readVariables(RubyStackFrame rubyStackFrame, RubyVariable rubyVariable) throws RubyProcessingException {
        this.stackFrame = rubyStackFrame;
        this.parent = rubyVariable;
        this.variables = new ArrayList();
        try {
            this.read();
        }
        catch (Exception exception) {
            RdtDebugCorePlugin.log(exception);
            return new RubyVariable[0];
        }
        if (this.exceptionMessage != null) {
            throw new RubyProcessingException(this.exceptionType, this.exceptionMessage);
        }
        RubyVariable[] rubyVariableArray = new RubyVariable[this.variables.size()];
        this.variables.toArray(rubyVariableArray);
        return rubyVariableArray;
    }

    protected boolean processStartElement(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getName();
        if (string.equals("variables")) {
            return true;
        }
        if (string.equals("variable")) {
            RubyVariable rubyVariable;
            String string2 = xmlPullParser.getAttributeValue("", "name");
            String string3 = xmlPullParser.getAttributeValue("", "value");
            String string4 = xmlPullParser.getAttributeValue("", "kind");
            if (string3 == null) {
                rubyVariable = new RubyVariable(this.stackFrame, string2, string4);
            } else {
                String string5 = xmlPullParser.getAttributeValue("", "type");
                boolean bl = xmlPullParser.getAttributeValue("", "hasChildren").equals("true");
                String string6 = xmlPullParser.getAttributeValue("", "objectId");
                rubyVariable = new RubyVariable(this.stackFrame, string2, string4, string3, string5, bl, string6);
            }
            rubyVariable.setParent(this.parent);
            this.variables.add(rubyVariable);
            return true;
        }
        if (string.equals("processingException")) {
            this.exceptionMessage = xmlPullParser.getAttributeValue("", "message");
            this.exceptionType = xmlPullParser.getAttributeValue("", "type");
            return true;
        }
        return false;
    }

    protected boolean processEndElement(XmlPullParser xmlPullParser) {
        return !xmlPullParser.getName().equals("variable");
    }
}

