/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rubypeople.rdt.internal.ui.util.LineBasedEditorOpener;

public class StackTraceLine {
    private static Pattern OPEN_TRACE_LINE_PATTERN = Pattern.compile("\\s*(\\S.*?):(\\d+)(:|$)");
    private static Pattern BRACKETED_TRACE_LINE_PATTERN = Pattern.compile("\\[(.*):(\\d+)\\]:");
    private static Pattern OPTIONAL_PREFIX = Pattern.compile("^[ \\t^]*from ");
    private String fFilename;
    private int fLineNumber;
    private int length;
    private int offset;

    public static boolean isTraceLine(String string) {
        Matcher matcher = BRACKETED_TRACE_LINE_PATTERN.matcher(string);
        Matcher matcher2 = OPEN_TRACE_LINE_PATTERN.matcher(string);
        return matcher.find() || matcher2.find();
    }

    public StackTraceLine(String string) {
        int n = 0;
        Matcher matcher = OPTIONAL_PREFIX.matcher(string);
        if (matcher.find()) {
            string = string.substring(matcher.group(0).length());
            n = matcher.group(0).length();
        }
        if (!(matcher = BRACKETED_TRACE_LINE_PATTERN.matcher(string)).find() && !(matcher = OPEN_TRACE_LINE_PATTERN.matcher(string)).find()) {
            return;
        }
        this.fFilename = matcher.group(1);
        String string2 = matcher.group(2);
        this.fLineNumber = Integer.parseInt(string2);
        this.offset = matcher.start(1) + n;
        this.length = this.fFilename.length() + string2.length() + 1;
    }

    public void openEditor() {
        if (this.fFilename == null) {
            return;
        }
        new LineBasedEditorOpener(this.fFilename, this.fLineNumber).open();
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public String getFilename() {
        return this.fFilename;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }
}

