/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesAccess;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.rubypeople.rdt.internal.ui.preferences.formatter.CodeFormatterConfigurationBlock;

public class CodeFormatterPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.rubypeople.rdt.ui.preferences.CodeFormatterPreferencePage";
    public static final String PROP_ID = "org.rubypeople.rdt.ui.propertyPages.CodeFormatterPreferencePage";
    private CodeFormatterConfigurationBlock fConfigurationBlock;

    public CodeFormatterPreferencePage() {
        this.setDescription(PreferencesMessages.CodeFormatterPreferencePage_description);
        this.setTitle(PreferencesMessages.CodeFormatterPreferencePage_title);
    }

    public void createControl(Composite composite) {
        PreferencesAccess preferencesAccess;
        IPreferencePageContainer iPreferencePageContainer = this.getContainer();
        if (iPreferencePageContainer instanceof IWorkbenchPreferenceContainer) {
            IWorkingCopyManager iWorkingCopyManager = ((IWorkbenchPreferenceContainer)iPreferencePageContainer).getWorkingCopyManager();
            preferencesAccess = PreferencesAccess.getWorkingCopyPreferences(iWorkingCopyManager);
        } else {
            preferencesAccess = PreferencesAccess.getOriginalPreferences();
        }
        this.fConfigurationBlock = new CodeFormatterConfigurationBlock(this.getProject(), preferencesAccess);
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.rubypeople.rdt.ui.codeformatter_preference_page_context");
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.fConfigurationBlock.createContents(composite);
    }

    protected boolean hasProjectSpecificOptions(IProject iProject) {
        return this.fConfigurationBlock.hasProjectSpecificOptions(iProject);
    }

    protected void enableProjectSpecificSettings(boolean bl) {
        super.enableProjectSpecificSettings(bl);
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.enableProjectSpecificSettings(bl);
        }
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    public void dispose() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.dispose();
        }
        super.dispose();
    }

    protected void performDefaults() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fConfigurationBlock != null && !this.fConfigurationBlock.performOk()) {
            return false;
        }
        return super.performOk();
    }

    public void setElement(IAdaptable iAdaptable) {
        super.setElement(iAdaptable);
        this.setDescription(null);
    }
}

