/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.internal.core.builder.AbstractRdtCompiler;
import org.rubypeople.rdt.internal.core.builder.IMarkerManager;
import org.rubypeople.rdt.internal.core.builder.MarkerManager;
import org.rubypeople.rdt.internal.core.symbols.SymbolIndex;
import org.rubypeople.rdt.internal.core.util.Util;

public class IncrementalRdtCompiler
extends AbstractRdtCompiler {
    private List filesToCompile;
    private List filesToClear;
    private final IResourceDelta rootDelta;

    public IncrementalRdtCompiler(IProject iProject, IResourceDelta iResourceDelta, SymbolIndex symbolIndex, IMarkerManager iMarkerManager, List list) {
        super(iProject, symbolIndex, iMarkerManager, list);
        this.rootDelta = iResourceDelta;
    }

    public IncrementalRdtCompiler(IProject iProject, IResourceDelta iResourceDelta, SymbolIndex symbolIndex) {
        this(iProject, iResourceDelta, symbolIndex, new MarkerManager());
    }

    private IncrementalRdtCompiler(IProject iProject, IResourceDelta iResourceDelta, SymbolIndex symbolIndex, MarkerManager markerManager) {
        this(iProject, iResourceDelta, symbolIndex, markerManager, IncrementalRdtCompiler.compilers(markerManager));
    }

    protected void removeMarkers(IMarkerManager iMarkerManager) {
        Iterator iterator = this.filesToClear.iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            iMarkerManager.removeProblemsAndTasksFor((IResource)iFile);
        }
    }

    protected void flushIndexEntries(SymbolIndex symbolIndex) {
        Iterator iterator = this.filesToClear.iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            symbolIndex.flush(iFile);
        }
    }

    protected List getFilesToCompile() {
        return this.filesToCompile;
    }

    protected void analyzeFiles() throws CoreException {
        this.filesToClear = new ArrayList();
        this.filesToCompile = new ArrayList();
        this.rootDelta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                IResource iResource = iResourceDelta.getResource();
                if (this.isRubyFile(iResource)) {
                    if (iResourceDelta.getKind() == 2) {
                        IncrementalRdtCompiler.this.filesToClear.add(iResource);
                    } else if (iResourceDelta.getKind() == 1 || iResourceDelta.getKind() == 4) {
                        IncrementalRdtCompiler.this.filesToCompile.add(iResource);
                    }
                }
                return true;
            }

            private boolean isRubyFile(IResource iResource) {
                return iResource instanceof IFile && Util.isRubyLikeFileName(iResource.getName());
            }
        });
        this.filesToClear.addAll(this.filesToCompile);
    }
}

