/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.cpcontainer;

import fr.jayasoft.ivy.Configuration;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.jayasoft.ivyde.eclipse.IvyPlugin;
import org.jayasoft.ivyde.eclipse.cpcontainer.IvyClasspathContainer;

public class IvydeContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IJavaProject _project;
    private IClasspathEntry _entry;
    private Text _ivyFilePathText;
    private CheckboxTableViewer _confTableViewer;
    static /* synthetic */ Class class$0;

    public IvydeContainerPage() {
        super("IvyDE Container");
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean finish() {
        if (this._ivyFilePathText.getText().length() > 0 && this.getConfigurationsText().length() > 0) {
            return true;
        }
        MessageDialog.openWarning((Shell)this._ivyFilePathText.getShell(), (String)"Missing information", (String)"Please select a valid file and choose at least one configuration");
        return false;
    }

    public IClasspathEntry getSelection() {
        return this.createEntry();
    }

    public void setSelection(IClasspathEntry entry) {
        this._entry = entry != null ? entry : this.createDefaultEntry();
    }

    private IClasspathEntry createEntry() {
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)new Path("org.jayasoft.ivyde.eclipse.cpcontainer.IVYDE_CONTAINER").append(this._ivyFilePathText.getText()).append(this.getConfigurationsText()));
        return entry;
    }

    private String getConfigurationsText() {
        Object[] confs = this._confTableViewer.getCheckedElements();
        int tot = this._confTableViewer.getTable().getItemCount();
        if (confs != null && confs.length == tot) {
            return "*";
        }
        String text = "";
        int i = 0;
        while (i < confs.length) {
            Configuration conf = (Configuration)confs[i];
            text = String.valueOf(text) + conf.getName() + (i < confs.length ? "," : "");
            ++i;
        }
        return text;
    }

    private IClasspathEntry createDefaultEntry() {
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)new Path("org.jayasoft.ivyde.eclipse.cpcontainer.IVYDE_CONTAINER").append("ivy.xml/*"));
        return entry;
    }

    public void createControl(Composite parent) {
        this.setTitle("IvyDE Managed Libraries");
        this.setDescription("Choose ivy file and its configurations.");
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        control.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)data);
        this.addMainSection(control);
        this.setControl((Control)control);
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void addMainSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText("Ivy File");
        this._ivyFilePathText = new Text(composite, 2052);
        this._ivyFilePathText.setText(IvyClasspathContainer.getIvyFilePath(this._entry.getPath()));
        this._ivyFilePathText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                IvydeContainerPage.this.refreshConfigurationTable();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this._ivyFilePathText.setLayoutData((Object)gridData);
        Button btn = new Button(composite, 0);
        btn.setText("Browse");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] elements;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class[] acceptedClasses = classArray;
                TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
                dialog.setValidator((ISelectionStatusValidator)validator);
                dialog.setTitle("choose ivy file");
                dialog.setMessage("choose the ivy file to use to resolve dependencies");
                dialog.setInput((Object)IvydeContainerPage.this._project.getProject());
                dialog.setSorter((ViewerSorter)new ResourceSorter(1));
                if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0 && elements[0] instanceof IFile) {
                    IPath p = ((IFile)elements[0]).getProjectRelativePath();
                    IvydeContainerPage.this._ivyFilePathText.setText(p.toString());
                    IvydeContainerPage.this.refreshConfigurationTable();
                }
            }
        });
        Label confLabel = new Label(composite, 0);
        confLabel.setText("Configurations");
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        confLabel.setLayoutData((Object)gridData);
        this._confTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this._confTableViewer.getTable().setHeaderVisible(true);
        TableColumn col1 = new TableColumn(this._confTableViewer.getTable(), 0);
        col1.setText("Name");
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(this._confTableViewer.getTable(), 0);
        col2.setText("Description");
        col2.setWidth(300);
        this._confTableViewer.setColumnProperties(new String[]{"Name", "Description"});
        this._confTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this._confTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement != null && !"".equals(inputElement)) {
                    return IvydeContainerPage.this.getConfigurations((String)inputElement);
                }
                return new Configuration[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this._confTableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this._confTableViewer.setInput((Object)this._ivyFilePathText.getText());
        this.initTableSelection(this._ivyFilePathText.getText());
        Button refreshConf = new Button(composite, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        refreshConf.setLayoutData((Object)gridData);
        refreshConf.setText("Refresh");
        refreshConf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IvydeContainerPage.this._confTableViewer.setInput((Object)IvydeContainerPage.this._ivyFilePathText.getText());
            }
        });
        new Composite(composite, 0);
        Link select = new Link(composite, 8);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        select.setLayoutData((Object)gridData);
        select.setText("<A>All</A>/<A>None</A>");
        select.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text.equals("All")) {
                    IvydeContainerPage.this._confTableViewer.setCheckedElements((Object[])IvydeContainerPage.this.getConfigurations(IvydeContainerPage.this._ivyFilePathText.getText()));
                } else {
                    IvydeContainerPage.this._confTableViewer.setCheckedElements((Object[])new Configuration[0]);
                }
            }
        });
    }

    private void initTableSelection(String ivyFile) {
        String selectedConfsString = IvyClasspathContainer.getConfigurationsText(this._entry.getPath());
        if ("*".equals(selectedConfsString)) {
            this._confTableViewer.setCheckedElements((Object[])this.getConfigurations(ivyFile));
        } else {
            ModuleDescriptor md;
            String[] selectedConf = IvyClasspathContainer.getConfigurations(this._entry.getPath());
            if (selectedConf != null && (md = this.getModuleDescriptor(ivyFile)) != null) {
                int i = 0;
                while (i < selectedConf.length) {
                    String name = selectedConf[i];
                    Configuration configuration = md.getConfiguration(name);
                    if (configuration != null) {
                        this._confTableViewer.setChecked((Object)configuration, true);
                    }
                    ++i;
                }
            }
        }
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this._project = project;
    }

    private void refreshConfigurationTable() {
        if (this._confTableViewer.getInput() == null || !this._confTableViewer.getInput().equals(this._ivyFilePathText.getText())) {
            this._confTableViewer.setInput((Object)this._ivyFilePathText.getText());
        }
    }

    private Configuration[] getConfigurations(String ivyfile) {
        try {
            ModuleDescriptor moduleDescriptor = this.getModuleDescriptor(ivyfile);
            if (moduleDescriptor != null) {
                return moduleDescriptor.getConfigurations();
            }
        }
        catch (Exception exception) {}
        return new Configuration[0];
    }

    private ModuleDescriptor getModuleDescriptor(String ivyfile) {
        try {
            IFile file = this._project.getProject().getFile(ivyfile);
            URL url = new File(file.getLocation().toOSString()).toURL();
            return ModuleDescriptorParserRegistry.getInstance().parseDescriptor(IvyPlugin.getIvy(this._project), url, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class ConfigurationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ConfigurationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((Configuration)element).getName();
            }
            return ((Configuration)element).getDescription();
        }
    }
}

