/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.webdav.WebdavConnectionManager;
import org.apache.commons.vfs.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;
import org.apache.webdav.lib.WebdavResource;

public class WebdavClientFactory {
    private WebdavClientFactory() {
    }

    public static HttpClient createConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient client;
        try {
            HttpURL url = new HttpURL(UserAuthenticatorUtils.toString(username), UserAuthenticatorUtils.toString(password), hostname, port, "/");
            WebdavResource resource = new WebdavResource(){};
            if (fileSystemOptions != null) {
                String proxyHost = WebdavFileSystemConfigBuilder.getInstance().getProxyHost(fileSystemOptions);
                int proxyPort = WebdavFileSystemConfigBuilder.getInstance().getProxyPort(fileSystemOptions);
                if (proxyHost != null && proxyPort > 0) {
                    resource.setProxy(proxyHost, proxyPort);
                }
            }
            resource.setHttpURL(url, 1, 1);
            client = resource.retrieveSessionInstance();
            client.setHttpConnectionManager((HttpConnectionManager)new WebdavConnectionManager());
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider.webdav/connect.error", hostname, (Throwable)e);
        }
        return client;
    }
}

