/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.internal.ui.rulers.GuideEditPart;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.rulers.RulerProvider;

public class RulerEditPartFactory
implements EditPartFactory {
    protected GraphicalViewer diagramViewer;

    public RulerEditPartFactory(GraphicalViewer primaryViewer) {
        this.diagramViewer = primaryViewer;
    }

    public EditPart createEditPart(EditPart parentEditPart, Object model) {
        EditPart part = null;
        if (this.isRuler(model)) {
            part = this.createRulerEditPart(parentEditPart, model);
        } else if (model != null) {
            part = this.createGuideEditPart(parentEditPart, model);
        }
        return part;
    }

    protected EditPart createGuideEditPart(EditPart parentEditPart, Object model) {
        return new GuideEditPart(model);
    }

    protected EditPart createRulerEditPart(EditPart parentEditPart, Object model) {
        return new RulerEditPart(model);
    }

    protected Object getHorizontalRuler() {
        Object ruler = null;
        RulerProvider provider = (RulerProvider)this.diagramViewer.getProperty("horizontal ruler");
        if (provider != null) {
            ruler = provider.getRuler();
        }
        return ruler;
    }

    protected Object getVerticalRuler() {
        Object ruler = null;
        RulerProvider provider = (RulerProvider)this.diagramViewer.getProperty("vertical ruler");
        if (provider != null) {
            ruler = provider.getRuler();
        }
        return ruler;
    }

    protected boolean isRuler(Object model) {
        boolean result = false;
        if (model != null) {
            result = model == this.getHorizontalRuler() || model == this.getVerticalRuler();
        }
        return result;
    }
}

