/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;

public class ReturnPathType {
    private static final int CAN_RETURN_NORMALLY = 0;
    private static final int CANNOT_RETURN_NORMALLY = 1;
    private static final int TOP = 2;
    private int type = 2;

    public boolean canReturnNormally() throws DataflowAnalysisException {
        if (!this.isValid()) {
            throw new DataflowAnalysisException("Checking invalid ReturnPathType");
        }
        return this.type == 0;
    }

    public void copyFrom(ReturnPathType other) {
        this.type = other.type;
    }

    public void setTop() {
        this.type = 2;
    }

    public boolean isTop() {
        return this.type == 2;
    }

    public void setCanReturnNormally(boolean canReturnNormally) {
        this.type = canReturnNormally ? 0 : 1;
    }

    public void mergeWith(ReturnPathType fact) {
        if (fact.isTop()) {
            return;
        }
        if (this.isTop()) {
            this.copyFrom(fact);
        } else if (fact.type == 0) {
            this.type = 0;
        }
    }

    boolean sameAs(ReturnPathType other) {
        return this.type == other.type;
    }

    public boolean isValid() {
        return this.type != 2;
    }

    public String toString() {
        switch (this.type) {
            case 2: {
                return "[TOP]";
            }
            case 0: {
                return "-";
            }
            case 1: {
                return "X";
            }
        }
        throw new IllegalStateException();
    }
}

