/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.util.Strings;
import edu.umd.cs.findbugs.util.Util;

public class IsNullConditionDecision
implements EdgeTypes {
    @CheckForNull
    private final ValueNumber value;
    @CheckForNull
    private final IsNullValue ifcmpDecision;
    @CheckForNull
    private final IsNullValue fallThroughDecision;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IsNullConditionDecision(@CheckForNull ValueNumber value, @CheckForNull IsNullValue ifcmpDecision, @CheckForNull IsNullValue fallThroughDecision) {
        this.value = value;
        if (!$assertionsDisabled && ifcmpDecision == null && fallThroughDecision == null) {
            throw new AssertionError();
        }
        this.ifcmpDecision = ifcmpDecision;
        this.fallThroughDecision = fallThroughDecision;
    }

    public int hashCode() {
        return Util.nullSafeHashcode(this.value) + 5 * Util.nullSafeHashcode(this.ifcmpDecision) + 17 * Util.nullSafeHashcode(this.fallThroughDecision);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IsNullConditionDecision)) {
            return false;
        }
        IsNullConditionDecision other = (IsNullConditionDecision)o;
        return Util.nullSafeEquals(this.value, other.value) && Util.nullSafeEquals(this.ifcmpDecision, other.ifcmpDecision) && Util.nullSafeEquals(this.fallThroughDecision, other.fallThroughDecision);
    }

    public ValueNumber getValue() {
        return this.value;
    }

    public boolean isRedundant() {
        return this.ifcmpDecision == null || this.fallThroughDecision == null;
    }

    public boolean isEdgeFeasible(int edgeType) {
        IsNullValue decision = this.getDecision(edgeType);
        return decision != null;
    }

    @CheckForNull
    public IsNullValue getDecision(int edgeType) {
        if (!$assertionsDisabled && edgeType != 1 && edgeType != 0) {
            throw new AssertionError();
        }
        if (edgeType == 1) {
            return this.ifcmpDecision;
        }
        return this.fallThroughDecision;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.value != null ? this.value.toString() : "NoValue,");
        buf.append("ifcmp=");
        buf.append(this.ifcmpDecision != null ? Strings.trimComma(this.ifcmpDecision.toString()) : "INFEASIBLE");
        buf.append(",fallthru=");
        buf.append(this.fallThroughDecision != null ? Strings.trimComma(this.fallThroughDecision.toString()) : "INFEASIBLE");
        return buf.toString();
    }

    static {
        $assertionsDisabled = !IsNullConditionDecision.class.desiredAssertionStatus();
    }
}

