/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.deref;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.BackwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.npe.IsNullConditionDecision;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconditionalValueDerefAnalysis
extends BackwardDataflowAnalysis<UnconditionalValueDerefSet> {
    public static final boolean DEBUG;
    public static final boolean ASSUME_NONZERO_TRIP_LOOPS;
    public static final boolean IGNORE_DEREF_OF_NCP;
    public static final boolean CHECK_ANNOTATIONS;
    public static final boolean CHECK_CALLS;
    public static final boolean DEBUG_CHECK_CALLS;
    private CFG cfg;
    private final Method method;
    private MethodGen methodGen;
    private ValueNumberDataflow vnaDataflow;
    private AssertionMethods assertionMethods;
    private IsNullValueDataflow invDataflow;
    private TypeDataflow typeDataflow;
    public static final boolean VERBOSE_NULLARG_DEBUG;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$deref$UnconditionalValueDerefAnalysis;

    public UnconditionalValueDerefAnalysis(ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs, CFG cfg, Method method, MethodGen methodGen, ValueNumberDataflow vnaDataflow, AssertionMethods assertionMethods) {
        super(rdfs, dfs);
        this.cfg = cfg;
        this.methodGen = methodGen;
        this.method = method;
        this.vnaDataflow = vnaDataflow;
        this.assertionMethods = assertionMethods;
        if (DEBUG) {
            System.out.println(new StringBuffer().append("UnconditionalValueDerefAnalysis analysis ").append(methodGen.getClassName()).append(".").append(methodGen.getName()).append(" : ").append(methodGen.getSignature()).toString());
        }
    }

    public void clearDerefsOnNonNullBranches(IsNullValueDataflow invDataflow) {
        this.invDataflow = invDataflow;
    }

    public void setTypeDataflow(TypeDataflow typeDataflow) {
        this.typeDataflow = typeDataflow;
    }

    @Override
    public boolean isFactValid(UnconditionalValueDerefSet fact) {
        return !fact.isTop() && !fact.isBottom();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        Instruction instruction = handle.getInstruction();
        if (fact.isTop()) {
            return;
        }
        Location location = new Location(handle, basicBlock);
        if (this.isAssertion(handle)) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("MAKING BOTTOM0 AT: ").append(location).toString());
            }
            fact.clear();
            return;
        }
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
        if (!vnaFrame.isValid()) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("MAKING TOP1 AT: ").append(location).toString());
            }
            this.makeFactTop(fact);
            return;
        }
        if (CHECK_CALLS && instruction instanceof InvokeInstruction) {
            this.checkUnconditionalDerefDatabase(location, vnaFrame, fact);
        }
        if (CHECK_ANNOTATIONS && instruction instanceof InvokeInstruction) {
            this.checkNonNullParams(location, vnaFrame, fact);
        }
        if (CHECK_ANNOTATIONS && instruction instanceof ARETURN) {
            XMethod thisMethod = XFactory.createXMethod(this.methodGen);
            this.checkNonNullReturnValue(thisMethod, location, vnaFrame, fact);
        }
        if (CHECK_ANNOTATIONS && (instruction instanceof PUTFIELD || instruction instanceof PUTSTATIC)) {
            this.checkNonNullPutField(location, vnaFrame, fact);
        }
        this.checkInstance(location, vnaFrame, fact);
        if (DEBUG && fact.isTop()) {
            System.out.println(new StringBuffer().append("MAKING TOP2 At: ").append(location).toString());
        }
    }

    private void checkUnconditionalDerefDatabase(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        InvokeInstruction inv = (InvokeInstruction)location.getHandle().getInstruction();
        SignatureParser sigParser = new SignatureParser(inv.getSignature(this.methodGen.getConstantPool()));
        int numParams = sigParser.getNumParameters();
        if (numParams == 0) {
            return;
        }
        ParameterNullnessPropertyDatabase database = AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase();
        if (database == null) {
            if (DEBUG_CHECK_CALLS) {
                System.out.println("no database!");
            }
            return;
        }
        TypeFrame typeFrame = this.typeDataflow.getFactAtLocation(location);
        if (!typeFrame.isValid()) {
            if (DEBUG_CHECK_CALLS) {
                System.out.println("invalid type frame!");
            }
            return;
        }
        try {
            IsNullValueFrame invFrame;
            Set<JavaClassAndMethod> targetSet = Hierarchy.resolveMethodCallTargets(inv, typeFrame, this.methodGen.getConstantPool());
            if (targetSet.isEmpty()) {
                return;
            }
            if (DEBUG_CHECK_CALLS) {
                System.out.println(new StringBuffer().append("target set size: ").append(targetSet.size()).toString());
            }
            ParameterNullnessProperty derefParamSet = null;
            for (JavaClassAndMethod target : targetSet) {
                ParameterNullnessProperty targetDerefParamSet;
                if (DEBUG_CHECK_CALLS) {
                    System.out.print(new StringBuffer().append("Checking: ").append(target).append(": ").toString());
                }
                if ((targetDerefParamSet = (ParameterNullnessProperty)database.getProperty(target.toXMethod())) == null) {
                    if (DEBUG_CHECK_CALLS) {
                        System.out.println("==> no information, assume no guaranteed dereferences");
                    }
                    return;
                }
                if (DEBUG_CHECK_CALLS) {
                    System.out.println(new StringBuffer().append("==> ").append(targetDerefParamSet).toString());
                }
                if (derefParamSet == null) {
                    derefParamSet = new ParameterNullnessProperty();
                    derefParamSet.copyFrom(targetDerefParamSet);
                    continue;
                }
                derefParamSet.intersectWith(targetDerefParamSet);
            }
            if (derefParamSet == null || derefParamSet.isEmpty()) {
                if (DEBUG) {
                    System.out.println("** Nothing");
                }
                return;
            }
            if (DEBUG_CHECK_CALLS) {
                System.out.println(new StringBuffer().append("** Summary of call @ ").append(location.getHandle().getPosition()).append(": ").append(derefParamSet).toString());
            }
            if ((invFrame = this.invDataflow.getFactAtLocation(location)) != null && invFrame.isValid()) {
                for (int i = 0; i < numParams; ++i) {
                    int argSlot;
                    if (!derefParamSet.isNonNull(i) || !this.reportDereference(invFrame, argSlot = vnaFrame.getStackLocation(sigParser.getSlotsFromTopOfStackForParameter(i)))) continue;
                    if (DEBUG_CHECK_CALLS) {
                        System.out.println(new StringBuffer().append("  dereference @ ").append(location.getHandle().getPosition()).append(" of parameter ").append(i).toString());
                    }
                    fact.addDeref((ValueNumber)vnaFrame.getValue(argSlot), location);
                }
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
    }

    private void checkNonNullReturnValue(XMethod thisMethod, Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        NullnessAnnotationDatabase database = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        if (database == null) {
            return;
        }
        IsNullValueFrame invFrame = this.invDataflow.getFactAtLocation(location);
        if (!invFrame.isValid()) {
            return;
        }
        if (database.getResolvedAnnotation(thisMethod, true) != NullnessAnnotation.NONNULL) {
            return;
        }
        IsNullValue value = (IsNullValue)invFrame.getTopValue();
        if (value.isDefinitelyNotNull()) {
            return;
        }
        if (value.isDefinitelyNull()) {
            return;
        }
        ValueNumber vn = (ValueNumber)vnaFrame.getTopValue();
        fact.addDeref(vn, location);
    }

    private void checkNonNullPutField(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        IsNullValueFrame invFrame;
        IsNullValue value;
        NullnessAnnotationDatabase database = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        if (database == null) {
            return;
        }
        FieldInstruction fieldIns = (FieldInstruction)location.getHandle().getInstruction();
        XField field = XFactory.createXField(fieldIns, this.methodGen.getConstantPool());
        char firstChar = field.getSignature().charAt(0);
        if (firstChar != 'L' && firstChar != '[') {
            return;
        }
        NullnessAnnotation resolvedAnnotation = database.getResolvedAnnotation(field, true);
        if (resolvedAnnotation == NullnessAnnotation.NONNULL && this.reportDereference(value = (IsNullValue)(invFrame = this.invDataflow.getFactAtLocation(location)).getTopValue())) {
            ValueNumber vn = (ValueNumber)vnaFrame.getTopValue();
            fact.addDeref(vn, location);
        }
    }

    private void checkNonNullParams(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        NullnessAnnotationDatabase database = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        if (database == null) {
            return;
        }
        InvokeInstruction inv = (InvokeInstruction)location.getHandle().getInstruction();
        XMethod called = XFactory.createXMethod(inv, this.methodGen.getConstantPool());
        SignatureParser sigParser = new SignatureParser(called.getSignature());
        int numParams = sigParser.getNumParameters();
        IsNullValueFrame invFrame = this.invDataflow.getFactAtLocation(location);
        if (!invFrame.isValid()) {
            return;
        }
        for (int i = 0; i < numParams; ++i) {
            int offset = sigParser.getSlotsFromTopOfStackForParameter(i);
            int slot = invFrame.getStackLocation(offset);
            IsNullValue value = (IsNullValue)invFrame.getValue(slot);
            if (!this.reportDereference(invFrame, slot) || !database.parameterMustBeNonNull(called, i)) continue;
            ValueNumber vn = (ValueNumber)vnaFrame.getArgument(inv, this.methodGen.getConstantPool(), i, sigParser);
            fact.addDeref(vn, location);
        }
    }

    private void checkInstance(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        ValueNumber v;
        if (!location.isFirstInstructionInBasicBlock()) {
            return;
        }
        if (this.invDataflow == null) {
            return;
        }
        BasicBlock fallThroughPredecessor = this.cfg.getPredecessorWithEdgeType(location.getBasicBlock(), 0);
        if (fallThroughPredecessor == null || !fallThroughPredecessor.isNullCheck()) {
            return;
        }
        ValueNumber vn = (ValueNumber)vnaFrame.getInstance(location.getHandle().getInstruction(), this.methodGen.getConstantPool());
        if (!this.methodGen.isStatic() && (v = (ValueNumber)vnaFrame.getValue(0)).equals(vn)) {
            return;
        }
        if (vn.hasFlag(4)) {
            return;
        }
        IsNullValueFrame startFact = null;
        startFact = (IsNullValueFrame)this.invDataflow.getStartFact(fallThroughPredecessor);
        if (!startFact.isValid()) {
            return;
        }
        int slot = startFact.getInstanceSlot(location.getHandle().getInstruction(), this.methodGen.getConstantPool());
        if (!this.reportDereference(startFact, slot)) {
            return;
        }
        if (DEBUG) {
            System.out.println("FOUND GUARANTEED DEREFERENCE");
            System.out.println(new StringBuffer().append("Load: ").append(vnaFrame.getLoad(vn)).toString());
            System.out.println(new StringBuffer().append("Pred: ").append(fallThroughPredecessor).toString());
            System.out.println(new StringBuffer().append("startFact: ").append(startFact).toString());
            System.out.println(new StringBuffer().append("Location: ").append(location).toString());
            System.out.println(new StringBuffer().append("Value number frame: ").append(vnaFrame).toString());
            System.out.println(new StringBuffer().append("Dereferenced valueNumber: ").append(vn).toString());
            System.out.println(new StringBuffer().append("invDataflow: ").append(startFact).toString());
            System.out.println(new StringBuffer().append("IGNORE_DEREF_OF_NCP: ").append(IGNORE_DEREF_OF_NCP).toString());
        }
        fact.addDeref(vn, location);
    }

    private boolean reportDereference(IsNullValueFrame invFrameAtNullCheck, int instance) {
        return this.reportDereference((IsNullValue)invFrameAtNullCheck.getValue(instance));
    }

    private boolean reportDereference(IsNullValue value) {
        if (value.isDefinitelyNotNull()) {
            return false;
        }
        if (value.isDefinitelyNull()) {
            return false;
        }
        return !IGNORE_DEREF_OF_NCP || !value.isNullOnComplicatedPath();
    }

    private boolean isAssertion(InstructionHandle handle) {
        return this.assertionMethods.isAssertionInstruction(handle.getInstruction(), this.methodGen.getConstantPool());
    }

    @Override
    public void copy(UnconditionalValueDerefSet source, UnconditionalValueDerefSet dest) {
        dest.makeSameAs(source);
    }

    @Override
    public UnconditionalValueDerefSet createFact() {
        return new UnconditionalValueDerefSet(((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getNumValuesAllocated());
    }

    @Override
    public void initEntryFact(UnconditionalValueDerefSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void initResultFact(UnconditionalValueDerefSet result) {
        result.setIsTop();
    }

    @Override
    public void makeFactTop(UnconditionalValueDerefSet fact) {
        fact.setIsTop();
    }

    @Override
    public boolean isTop(UnconditionalValueDerefSet fact) {
        return fact.isTop();
    }

    @Override
    public void meetInto(UnconditionalValueDerefSet fact, Edge edge, UnconditionalValueDerefSet result) throws DataflowAnalysisException {
        this.meetInto(fact, edge, result, false);
    }

    public void meetInto(UnconditionalValueDerefSet fact, Edge edge, UnconditionalValueDerefSet result, boolean onlyEdge) throws DataflowAnalysisException {
        if (this.isExceptionEdge(edge) && !onlyEdge) {
            if (DEBUG) {
                System.out.println("Skipping exception edge");
            }
            return;
        }
        ValueNumber knownNonnullOnBranch = null;
        if (this.isFactValid(fact)) {
            fact = this.propagateDerefSetsToMergeInputValues(fact, edge);
            if (this.invDataflow != null && (knownNonnullOnBranch = this.findValueKnownNonnullOnBranch(fact, edge)) != null) {
                fact = this.duplicateFact(fact);
                fact.clearDerefSet(knownNonnullOnBranch);
            }
        }
        boolean isBackEdge = edge.isBackwardInBytecode();
        Set<Integer> loopExitBranches = ClassContext.getLoopExitBranches(this.method, this.methodGen);
        if (!$assertionsDisabled && loopExitBranches == null) {
            throw new AssertionError();
        }
        boolean sourceIsTopOfLoop = edge.sourceIsTopOfLoop(loopExitBranches);
        if (sourceIsTopOfLoop && edge.getType() == 0) {
            isBackEdge = true;
        }
        if (result.isTop() || fact.isBottom()) {
            this.copy(fact, result);
            if (ASSUME_NONZERO_TRIP_LOOPS && isBackEdge && !fact.isTop()) {
                result.resultsFromBackEdge = true;
            }
        } else if (ASSUME_NONZERO_TRIP_LOOPS && isBackEdge && !fact.isTop()) {
            result.unionWith(fact, ((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getFactory());
            result.resultsFromBackEdge = true;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("\n Forcing union of ").append(System.identityHashCode(result)).append(" due to backedge info").toString());
                System.out.println(new StringBuffer().append("  result: ").append(result).toString());
            }
        } else if (!result.isBottom() && !fact.isTop()) {
            if (ASSUME_NONZERO_TRIP_LOOPS && result.resultsFromBackEdge) {
                ++result.backEdgeUpdateCount;
                if (result.backEdgeUpdateCount < 10) {
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("\n Union update of ").append(System.identityHashCode(result)).append(" due to backedge info").toString());
                    }
                    result.unionWith(fact, ((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getFactory());
                    return;
                }
            }
            result.mergeWith(fact, knownNonnullOnBranch, ((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getFactory());
            if (DEBUG) {
                System.out.println(new StringBuffer().append("  updated: ").append(System.identityHashCode(result)).toString());
                System.out.println(new StringBuffer().append("  result: ").append(result).toString());
            }
        }
        if (DEBUG && isBackEdge && edge.getType() == 1) {
            System.out.println(new StringBuffer().append("  result: ").append(result).toString());
        }
    }

    private UnconditionalValueDerefSet propagateDerefSetsToMergeInputValues(UnconditionalValueDerefSet fact, Edge edge) {
        ValueNumberFrame blockValueNumberFrame = (ValueNumberFrame)this.vnaDataflow.getResultFact((BasicBlock)edge.getSource());
        ValueNumberFrame targetValueNumberFrame = (ValueNumberFrame)this.vnaDataflow.getStartFact((BasicBlock)edge.getTarget());
        UnconditionalValueDerefSet originalFact = fact;
        fact = this.duplicateFact(fact);
        if (blockValueNumberFrame.isValid() && targetValueNumberFrame.isValid() && blockValueNumberFrame.getNumSlots() == targetValueNumberFrame.getNumSlots()) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("** Valid VNA frames for ").append(edge).toString());
                System.out.println(new StringBuffer().append("** Block : ").append(blockValueNumberFrame).toString());
                System.out.println(new StringBuffer().append("** Target: ").append(targetValueNumberFrame).toString());
            }
            for (int i = 0; i < blockValueNumberFrame.getNumSlots(); ++i) {
                ValueNumber targetVN;
                ValueNumber blockVN = (ValueNumber)blockValueNumberFrame.getValue(i);
                if (blockVN.equals(targetVN = (ValueNumber)targetValueNumberFrame.getValue(i))) continue;
                fact.clearDerefSet(blockVN);
                if (!originalFact.isUnconditionallyDereferenced(targetVN)) continue;
                fact.setDerefSet(blockVN, originalFact.getUnconditionalDerefLocationSet(targetVN));
            }
            for (ValueNumber blockVN : blockValueNumberFrame.valueNumbersForLoads()) {
                ValueNumber[] targetVNs;
                AvailableLoad load = blockValueNumberFrame.getLoad(blockVN);
                if (load == null || (targetVNs = targetValueNumberFrame.getAvailableLoad(load)) == null) continue;
                for (ValueNumber targetVN : targetVNs) {
                    AvailableLoad targetLoad;
                    if (!targetVN.hasFlag(8) || !fact.isUnconditionallyDereferenced(targetVN) || fact.isUnconditionallyDereferenced(blockVN) || !load.equals(targetLoad = targetValueNumberFrame.getLoad(targetVN))) continue;
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("** Copy vn derefs for ").append(load).append(" from ").append(targetVN).append(" --> ").append(blockVN).toString());
                        System.out.println(new StringBuffer().append("** block phi for ").append(System.identityHashCode(blockValueNumberFrame)).append(" is ").append(blockValueNumberFrame.phiNodeForLoads).toString());
                        System.out.println(new StringBuffer().append("** target phi for ").append(System.identityHashCode(targetValueNumberFrame)).append(" is ").append(targetValueNumberFrame.phiNodeForLoads).toString());
                    }
                    fact.setDerefSet(blockVN, fact.getUnconditionalDerefLocationSet(targetVN));
                }
            }
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Target VNF: ").append(targetValueNumberFrame).toString());
            System.out.println(new StringBuffer().append("Block VNF: ").append(blockValueNumberFrame).toString());
            System.out.println(new StringBuffer().append("fact: ").append(fact).toString());
        }
        fact.cleanDerefSet(null, blockValueNumberFrame);
        return fact;
    }

    private UnconditionalValueDerefSet duplicateFact(UnconditionalValueDerefSet fact) {
        UnconditionalValueDerefSet copyOfFact = this.createFact();
        this.copy(fact, copyOfFact);
        fact = copyOfFact;
        return fact;
    }

    @CheckForNull
    private ValueNumber findValueKnownNonnullOnBranch(UnconditionalValueDerefSet fact, Edge edge) {
        IsNullValueFrame invFrame = (IsNullValueFrame)this.invDataflow.getResultFact((BasicBlock)edge.getSource());
        if (!invFrame.isValid()) {
            return null;
        }
        IsNullConditionDecision decision = invFrame.getDecision();
        if (decision == null) {
            return null;
        }
        IsNullValue inv = decision.getDecision(edge.getType());
        if (inv == null || !inv.isDefinitelyNotNull()) {
            return null;
        }
        ValueNumber value = decision.getValue();
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Value number ").append(value).append(" is known nonnull on ").append(edge).toString());
        }
        return value;
    }

    private boolean isExceptionEdge(Edge edge) {
        boolean isExceptionEdge = edge.isExceptionEdge();
        if (DEBUG && isExceptionEdge) {
            System.out.println(new StringBuffer().append("Ignoring ").append(edge).toString());
        }
        return isExceptionEdge;
    }

    @Override
    public boolean same(UnconditionalValueDerefSet fact1, UnconditionalValueDerefSet fact2) {
        return fact1.resultsFromBackEdge || fact1.isSameAs(fact2);
    }

    @Override
    public void startIteration() {
    }

    @Override
    public int getLastUpdateTimestamp(UnconditionalValueDerefSet fact) {
        return fact.getLastUpdateTimestamp();
    }

    @Override
    public void setLastUpdateTimestamp(UnconditionalValueDerefSet fact, int lastUpdate) {
        fact.setLastUpdateTimestamp(lastUpdate);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$deref$UnconditionalValueDerefAnalysis == null ? (class$edu$umd$cs$findbugs$ba$deref$UnconditionalValueDerefAnalysis = UnconditionalValueDerefAnalysis.class$("edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis")) : class$edu$umd$cs$findbugs$ba$deref$UnconditionalValueDerefAnalysis).getName()).append(" <classfile>").toString());
            System.exit(1);
        }
        DataflowTestDriver<UnconditionalValueDerefSet, UnconditionalValueDerefAnalysis> driver = new DataflowTestDriver<UnconditionalValueDerefSet, UnconditionalValueDerefAnalysis>(){

            @Override
            public Dataflow<UnconditionalValueDerefSet, UnconditionalValueDerefAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return classContext.getUnconditionalValueDerefDataflow(method);
            }
        };
        if (SystemProperties.getBoolean("forwardcfg")) {
            driver.overrideIsForwards();
        }
        driver.execute(args[0]);
    }

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((UnconditionalValueDerefSet)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (UnconditionalValueDerefSet)x2);
    }

    @Override
    public /* synthetic */ void setLastUpdateTimestamp(Object x0, int x1) {
        this.setLastUpdateTimestamp((UnconditionalValueDerefSet)x0, x1);
    }

    @Override
    public /* synthetic */ int getLastUpdateTimestamp(Object x0) {
        return this.getLastUpdateTimestamp((UnconditionalValueDerefSet)x0);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((UnconditionalValueDerefSet)x0, x1, (UnconditionalValueDerefSet)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((UnconditionalValueDerefSet)x0, (UnconditionalValueDerefSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((UnconditionalValueDerefSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((UnconditionalValueDerefSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((UnconditionalValueDerefSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((UnconditionalValueDerefSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((UnconditionalValueDerefSet)x0, (UnconditionalValueDerefSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$ba$deref$UnconditionalValueDerefAnalysis == null ? (class$edu$umd$cs$findbugs$ba$deref$UnconditionalValueDerefAnalysis = UnconditionalValueDerefAnalysis.class$("edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis")) : class$edu$umd$cs$findbugs$ba$deref$UnconditionalValueDerefAnalysis).desiredAssertionStatus();
        DEBUG = SystemProperties.getBoolean("fnd.derefs.debug");
        ASSUME_NONZERO_TRIP_LOOPS = SystemProperties.getBoolean("fnd.derefs.nonzerotrip");
        IGNORE_DEREF_OF_NCP = SystemProperties.getBoolean("fnd.derefs.ignoreNCP", false);
        CHECK_ANNOTATIONS = SystemProperties.getBoolean("fnd.derefs.checkannotations", true);
        CHECK_CALLS = SystemProperties.getBoolean("fnd.derefs.checkcalls", true);
        DEBUG_CHECK_CALLS = SystemProperties.getBoolean("fnd.derefs.checkcalls.debug");
        VERBOSE_NULLARG_DEBUG = SystemProperties.getBoolean("fnd.debug.nullarg.verbose");
    }
}

