/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.InstructionScanner;
import edu.umd.cs.findbugs.InstructionScannerGenerator;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Edge;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionScannerDriver {
    private Iterator<Edge> edgeIter;
    private LinkedList<InstructionScanner> scannerList;
    private static final boolean DEBUG = SystemProperties.getBoolean("isd.debug");

    public InstructionScannerDriver(Iterator<Edge> edgeIter) {
        this.edgeIter = edgeIter;
        this.scannerList = new LinkedList();
    }

    public void execute(InstructionScannerGenerator generator) {
        while (this.edgeIter.hasNext()) {
            Edge edge = this.edgeIter.next();
            BasicBlock source = (BasicBlock)edge.getSource();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("ISD: scanning instructions in block ").append(source.getId()).toString());
            }
            BasicBlock.InstructionIterator i = source.instructionIterator();
            int count = 0;
            while (i.hasNext()) {
                InstructionHandle handle = (InstructionHandle)i.next();
                if (generator.start(handle)) {
                    this.scannerList.add(generator.createScanner());
                }
                for (InstructionScanner scanner : this.scannerList) {
                    scanner.scanInstruction(handle);
                }
                ++count;
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("ISD: scanned ").append(count).append(" instructions").toString());
            }
            for (InstructionScanner scanner : this.scannerList) {
                scanner.traverseEdge(edge);
            }
        }
    }
}

